package ishitai.oopad;

import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.lang.reflect.*;
import ishitai.bots.*;
/**
 * Adapter.java
 *
 *
 * Created: Thu Sep 02 14:45:41 1999
 *
 * @author Richard Harris
 * @version 1.0
 */

public class Adapter implements MenuEventListener {
   private EditorMenu menu;
   private Object theTarget;
   private Class theTargetClass;
   private Hashtable methodCalls = new Hashtable();
   private ExcepBot ebot = BotFactory.getExcepBot();
   
   public Adapter(EditorMenu em) {
      menu = em;
      menu.addMenuEventListener(this);
   }

	/**
	 * Returns an array currently containing the guis
	 * TextArea, status TextField and Frame.  This call
	 * passes through the EditorMenu to be loaded by the
	 * EditorGui.
	 *
	 * @param target The module that needs the gui references
	 * @param wl The AppCloser to be hooked to the Frame
	 * @return An array of Components
	 */
   public Component[] setTarget(Object target, WindowListener wl) {
      theTarget = target;
      theTargetClass = target.getClass();
      return menu.addListeners(theTarget, wl);
   }

	/**
	 * Invokes a method in the target which the target
	 * has related to a command String
	 *
	 * @param me The incoming MenuEvent
	 */
   public void handleMenuEvent(MenuEvent me){
      String command = me.getMenucmd();
      Method m = (Method)methodCalls.get(command);
      try{
			m.invoke(theTarget, null);
      }catch(IllegalAccessException iae){
			ebot.dump(iae);
      }catch(InvocationTargetException ite){
			ebot.dump(ite);
      }
   }

	/**
	 * Allows the Module to connect its methods to the
	 * ActionCommand of the menus
	 *
	 * @param call The menu's actionCommand, i.e. "exit"
	 * @param methodname The Module's method, i.e. "exit()"
	 */
   public void registerCall(String call, String methodname){
      Method m = null;
      try{
			m = theTargetClass.getMethod(methodname, null);
      }catch(NoSuchMethodException nsme){
			ebot.dump(nsme);
      }
      methodCalls.put(call, m);
   }
   
} // Adapter
