#define STRICT
#define NOTREEVIEW
#define NOIMAGEAPIS
#define UNTITLED "(untitled)"

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <commctrl.h>
#include "heximain.h"

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ChildWndProc (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AboutDlgProc (HWND, UINT, WPARAM, LPARAM);

void HexFileInitialize (HWND);
BOOL HexFileOpenDlg    (HWND, PSTR, PSTR);
BOOL HexFileRead       (HWND, PSTR);
BOOL HexFileExportDlg  (HWND, PSTR, PSTR);
BOOL HexFileWrite      (HWND, PSTR);
BOOL HexFileSaveDlg    (HWND, PSTR, PSTR);
BOOL HexFileSave       (HWND, PSTR);

HWND HexFindDlg        (HWND);
HWND HexGoToDlg        (HWND);
BOOL FindHexValue      (HWND, LPFINDREPLACE);
BOOL FindAsciiValue    (HWND, LPFINDREPLACE);
BOOL GotoOffset        (HWND, LPFINDREPLACE);

char                szFileName[_MAX_PATH+_MAX_FNAME+_MAX_EXT]; 
char                szTitleName[_MAX_FNAME+_MAX_EXT];
char                szAppName[]="Hexiwin";
char                lpszSbIoffset[17];
char                szCurDir[_MAX_PATH];
char                szHelpFile[_MAX_PATH+_MAX_FNAME+_MAX_EXT];
int                 cyClient,cxClient,yCaret=0,xCaret=10;
int                 iSbParts[3],xCaretCount=1,cxChar,cyChar;
int                 x, l, iVscrollPos, *z;
HANDLE              hFile;
HWND                hDlgModeless, hwndChild, hStatusWindow;
BOOL                bNeedSave=FALSE;
LPFINDREPLACE       pfr;
extern BOOL         bFind;
extern OPENFILENAME ofn;
HMENU               hMenu;
HINSTANCE           hInstance;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
     {
     HWND        hwnd;
     MSG         msg;
     WNDCLASSEX  wndclass;

     wndclass.cbSize        = sizeof (wndclass);
     wndclass.style         = CS_HREDRAW|CS_VREDRAW|CS_BYTEALIGNWINDOW;
     wndclass.lpfnWndProc   = WndProc;
     wndclass.cbClsExtra    = 0;
     wndclass.cbWndExtra    = 0;
     wndclass.hInstance     = hInstance;
     wndclass.hIcon         = LoadIcon (hInstance, szAppName);
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
     wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH);
     wndclass.lpszMenuName  = szAppName;
     wndclass.lpszClassName = szAppName;
     wndclass.hIconSm       = 0;

     RegisterClassEx (&wndclass);

     wndclass.lpszClassName = "HexClientClass";
     wndclass.style         = CS_HREDRAW | CS_VREDRAW;
     wndclass.lpfnWndProc   = ChildWndProc;
     wndclass.cbWndExtra    = 0;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
     wndclass.hIcon         = 0;
     wndclass.lpszMenuName  = 0;
     wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH);
     wndclass.hIconSm       = 0;

     RegisterClassEx (&wndclass);

     hwnd = CreateWindowEx (WS_EX_WINDOWEDGE, szAppName, " Hexiwin",
            WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_VISIBLE | WS_BORDER,
            CW_USEDEFAULT, CW_USEDEFAULT, 635, 353, NULL, NULL, hInstance, NULL);

     GetCurrentDirectory(_MAX_PATH, szCurDir);
     wsprintf(szHelpFile, "%s\\%s", szCurDir, "hexiwin.hlp");
	 if (lstrlen(szCmdLine) > 0) {
	  if (HexFileRead (hwndChild, szCmdLine))
	  {
	   hMenu = GetMenu(hwnd);
	   wsprintf(szFileName, "%s", szCmdLine);
	   wsprintf(szTitleName, "%s", szCmdLine);
       SendMessage (hwnd, WM_SETFOCUS, 0, 0L);
	   DoCaption(hwnd, szTitleName);
	   EnableMenuItem(hMenu, IDM_SAVEAS, MF_ENABLED);
       EnableMenuItem(hMenu, IDM_SAVE, MF_ENABLED);
       EnableMenuItem(hMenu, IDM_EXPORTAS, MF_ENABLED);
       EnableMenuItem(hMenu, IDM_FIND, MF_ENABLED);
       EnableMenuItem(hMenu, IDM_GOTO, MF_ENABLED);
	  } else { OkMessage (hwnd, "Could not find file: '%s'", szCmdLine); }
	 } 
	 
     while (GetMessage (&msg, 0, 0, 0)>0)
          {
          if (hDlgModeless == 0 || !IsDialogMessage (hDlgModeless, &msg))
               {
                TranslateMessage (&msg);
                DispatchMessage (&msg);
               }
          }
     return msg.wParam;
     }

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
extern unsigned char *c;
extern int           numLines, iFileLength;
static UINT          iMsgFindReplace;

	switch (iMsg)
   	{
    case WM_SETFOCUS:
         if (lstrlen(szTitleName) > 0) { SetFocus(hwndChild); }
         return 0;

    case WM_COMMAND:
         hMenu = GetMenu(hwnd);
    switch (LOWORD (wParam))
    {
    case IDM_OPEN:
         if (bNeedSave && IDCANCEL == AskAboutSave (hwnd, szTitleName)) { return 0; }
         if (HexFileOpenDlg (hwnd, szFileName, szTitleName)) {
         if (!HexFileRead (hwndChild, szFileName)) {
             OkMessage (hwnd, "Could not read file %s!", szTitleName);
             szFileName[0]  = '\0';
             szTitleName[0] = '\0';
         }
         if (lstrlen(szTitleName) > 0) {
             yCaret=0;
             xCaret=10;
             xCaretCount=1;
             SetCaretPos (xCaret * cxChar, yCaret * cyChar);
             DoCaption (hwnd, szTitleName);
             EnableMenuItem(hMenu, IDM_SAVEAS, MF_ENABLED);
             EnableMenuItem(hMenu, IDM_SAVE, MF_ENABLED);
             EnableMenuItem(hMenu, IDM_EXPORTAS, MF_ENABLED);
             EnableMenuItem(hMenu, IDM_FIND, MF_ENABLED);
             EnableMenuItem(hMenu, IDM_GOTO, MF_ENABLED);
         } else { HideCaret(hwndChild); }
         free(z);
         x=0;
         bNeedSave=FALSE;
         }
         return 0;

    case IDM_SAVE:
         if (lstrlen(szTitleName) == 0) { break;}
         if (HexFileSave (hwndChild, szFileName)) {
             bNeedSave = FALSE;
             free(z);
             x=0;
             return 1;
         }
         else {
               OkMessage (hwnd, "Could not write to file %s!", szTitleName);
               szFileName[0]  = '\0';
               szTitleName[0] = '\0';
              }
         return 0;

    case IDM_SAVEAS:
         if (lstrlen(szTitleName) == 0) { break; }
         if (HexFileSaveDlg (hwnd, szFileName, szTitleName)) {
         if (HexFileSave (hwndChild, szFileName)) {
             bNeedSave=FALSE;
             free(z);
             x=0;
             return 1;
         }
         else { OkMessage (hwnd, "Could not write to file %s!", szTitleName); }
         }
         return 0;

    case IDM_EXPORTAS:
         if (lstrlen(szTitleName) == 0) { break; }
         if (HexFileExportDlg (hwnd, szFileName, szTitleName)) {
         if (HexFileWrite (hwndChild, szFileName)) { return 1; }
         else { OkMessage (hwnd, "Could not write file %s", szTitleName); }
         }
         return 0;

    case IDM_EXIT:
         SendMessage (hwnd, WM_CLOSE, 0, 0L);
         return 0;

    case IDM_FIND:
         hDlgModeless = HexFindDlg (hwnd);
         return 0;

    case IDM_GOTO:
         hDlgModeless = HexGoToDlg (hwnd);
         return 0;

    case IDM_HELP:
         WinHelp(hwnd, szHelpFile, HELP_FINDER, 0);
         return 0;

    case IDM_ABOUT :
         DialogBox (GetModuleHandle(NULL), "AboutBox", hwnd, AboutDlgProc);
         return 0 ;
    }
    return 0;

    case WM_CREATE:
         HexFileInitialize (hwnd);
         hwndChild = CreateWindowEx (WS_EX_CLIENTEDGE, "HexClientClass", NULL,
         WS_CHILDWINDOW | WS_VISIBLE | WS_VSCROLL | WS_CLIPSIBLINGS | WS_BORDER,
         CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
         hwnd, NULL, hInstance, NULL);

         hStatusWindow = CreateStatusWindow(WS_CHILD | WS_VISIBLE | CCS_BOTTOM |
         SBARS_SIZEGRIP | WS_CLIPSIBLINGS | WS_BORDER, "Ready", hwnd, 2);
         SendMessage (hStatusWindow, SB_SETPARTS, 3, (LPARAM) (LPINT) iSbParts);
         SendMessage (hStatusWindow, SB_SETTEXT, 1 | 0, (LPARAM) "Offset: 00000000");
         SendMessage (hStatusWindow, SB_SETTEXT, 2 | 0, (LPARAM) "00000000 Bytes");
         iMsgFindReplace = RegisterWindowMessage (FINDMSGSTRING);
         return 0;

    case WM_SIZE:
         cxClient = LOWORD (lParam);
         cyClient = HIWORD (lParam)-20;
         MoveWindow(hwndChild, 0, 0, cxClient, cyClient, TRUE);
         MoveWindow(hStatusWindow, 0, cyClient, cxClient, 20, TRUE);
         iSbParts[0] = cxClient-214;
         iSbParts[1] = cxClient-114;
         iSbParts[2] = cxClient-20;
         SendMessage (hStatusWindow, SB_SETPARTS, 3, (LPARAM) (LPINT) iSbParts);
         return 0;

    case WM_CLOSE:
         if (!bNeedSave || IDCANCEL != AskAboutSave (hwnd, szTitleName)) {
             DestroyWindow (hwnd);}
         UnmapViewOfFile(c);
         free(z);
         return 0;

    case WM_DESTROY:
         PostQuitMessage (0);
         return 0;

    default:
         if (iMsg == iMsgFindReplace)
         {
         pfr = (LPFINDREPLACE) lParam;
         if (pfr->Flags & FR_DIALOGTERM)
             hDlgModeless = NULL;

         if (pfr->Flags & FR_FINDNEXT && IsDlgButtonChecked(hDlgModeless, 1018) == BST_CHECKED) 
         if (!FindHexValue (hwnd, pfr))
             OkMessage (NULL,  "Hex value\n%s\nnot found!", pfr->lpstrFindWhat);

         if (pfr->Flags & FR_FINDNEXT && IsDlgButtonChecked(hDlgModeless, 1019) == BST_CHECKED)
         if (!FindAsciiValue (hwnd, pfr))
             OkMessage (NULL,  "Ascii string\n\"%s\"\nnot found!", pfr->lpstrFindWhat);

         if (pfr->Flags & FR_FINDNEXT && IsDlgButtonChecked(hDlgModeless, 1021) == BST_CHECKED)
         if (!GotoOffset (hwnd, pfr))
             OkMessage (NULL,  "Hex offset\n%s\nout of range!", pfr->lpstrFindWhat);

         if (pfr->Flags & FR_FINDNEXT && IsDlgButtonChecked(hDlgModeless, 1022) == BST_CHECKED)
         if (!GotoOffset (hwnd, pfr))
             OkMessage (NULL,  "Decimal offset\n%s\nout of range!", pfr->lpstrFindWhat);

         return 0;
         }
      break;
      }
return DefWindowProc (hwnd, iMsg, wParam, lParam);
}
        
LRESULT CALLBACK ChildWndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
static int           iVscrollMax;
int                  a=0, t=0, i, b, y, iVscrollInc=0, iPaintBeg, iPaintEnd, xPos, yPos, edHex=0;
char                 szBuffer[9], szBuffer2[3], enterHex[2], *endptr;
static unsigned int  iHex1;
extern unsigned char *c;
HDC                  hdc;
SCROLLINFO           si;
TEXTMETRIC           tm;
PAINTSTRUCT          ps;
extern int           numLines, iFileLength, iOffset, iFindPos;
RECT                 rcHex, rcAscii, rcBottom;

    switch (iMsg)
    {
    case WM_LBUTTONDOWN:
         xPos = LOWORD(lParam);
         yPos = HIWORD(lParam);

    if (xPos > cxChar*10 && xPos < cxChar*66) {
        yCaret=yPos/cyChar;
     if (xPos >= cxChar*10 && xPos < cxChar*12) { xCaret=10; xCaretCount=1; }
     if (xPos >= cxChar*12 && xPos < cxChar*14) { xCaret=12; xCaretCount=2; }
     if (xPos >= cxChar*15 && xPos < cxChar*17) { xCaret=15; xCaretCount=3; }
     if (xPos >= cxChar*17 && xPos < cxChar*19) { xCaret=17; xCaretCount=4; }
     if (xPos >= cxChar*20 && xPos < cxChar*22) { xCaret=20; xCaretCount=5; }
     if (xPos >= cxChar*22 && xPos < cxChar*24) { xCaret=22; xCaretCount=6; }
     if (xPos >= cxChar*25 && xPos < cxChar*27) { xCaret=25; xCaretCount=7; }
     if (xPos >= cxChar*27 && xPos < cxChar*29) { xCaret=27; xCaretCount=8; }
     if (xPos >= cxChar*30 && xPos < cxChar*32) { xCaret=30; xCaretCount=9; }
     if (xPos >= cxChar*32 && xPos < cxChar*34) { xCaret=32; xCaretCount=10; }
     if (xPos >= cxChar*35 && xPos < cxChar*37) { xCaret=35; xCaretCount=11; }
     if (xPos >= cxChar*37 && xPos < cxChar*39) { xCaret=37; xCaretCount=12; }
     if (xPos >= cxChar*40 && xPos < cxChar*42) { xCaret=40; xCaretCount=13; }
     if (xPos >= cxChar*42 && xPos < cxChar*44) { xCaret=42; xCaretCount=14; }
     if (xPos >= cxChar*45 && xPos < cxChar*47) { xCaret=45; xCaretCount=15; }
     if (xPos >= cxChar*47 && xPos < cxChar*49) { xCaret=47; xCaretCount=16; }
     if (xPos >= cxChar*50 && xPos < cxChar*67) { xCaret=xPos/cxChar; xCaretCount=xCaret-49; }
     if ((iVscrollPos*16)+(yCaret*16)+(xCaretCount) > iFileLength) { break; }
     bFind=FALSE;
     SetCaretPos (xCaret*cxChar, yCaret*cyChar);
     InvalidateRect(hwndChild, NULL, FALSE);
     wsprintf(lpszSbIoffset, "Offset: %08X", (xCaretCount-1)+
     (yCaret*16)+(iVscrollPos*16));
     SendMessage (hStatusWindow, SB_SETTEXT, 1 | 0, (LPARAM) lpszSbIoffset);
     }
     return 0;
 
    case WM_SETFOCUS :
         CreateCaret (hwndChild, NULL, 2, cyChar);
         SetCaretPos (xCaret * cxChar, yCaret * cyChar);
         ShowCaret (hwndChild);
         return 0;

    case WM_KILLFOCUS:
         HideCaret (hwndChild);
         DestroyCaret();
         return 0;

    case WM_KEYDOWN:
     	 switch (wParam)
         {
    case VK_HOME:
         if (xCaret <= 47) { yCaret=0; xCaret=10; xCaretCount=1; }
         if (xCaret > 47) { yCaret=0; xCaret=50; xCaretCount=1; }
         SendMessage (hwndChild, WM_VSCROLL, SB_TOP, 0L);
         break;

    case VK_END:
         if ((iFileLength/16)-1 <= cyClient/cyChar && iFileLength%16 == 0 && xCaret < 49) {
         yCaret=(iFileLength/16)-1;
         xCaret=47;
         xCaretCount=16;
         break;
         }
         if ((iFileLength/16)-1 <= cyClient/cyChar && iFileLength%16 == 0 && xCaret > 49) {
             yCaret=(iFileLength/16)-1;
             xCaret=65;
             xCaretCount=16;
             break;
         }
         if (iFileLength/16 <= cyClient/cyChar && iFileLength%16 != 0 && xCaret < 49) {
             yCaret=iFileLength/16;
             xCaret=9+(iFileLength%16);
             xCaretCount=iFileLength%16;
             break;
         }
         if (iFileLength/16 <= cyClient/cyChar && iFileLength%16 != 0 && xCaret > 49) {
             yCaret=iFileLength/16;
             xCaret=49+(iFileLength%16);
             xCaretCount=iFileLength%16;
             break;
         } else { yCaret=(cyClient/cyChar)-2; }
         if (xCaret > 49) {
         if (iFileLength%16 == 0) { xCaret=65; xCaretCount=16; }
         if (iFileLength%16 != 0) {
             xCaret=49+iFileLength%16;
             xCaretCount=iFileLength%16;
         }
         SendMessage (hwndChild, WM_VSCROLL, SB_BOTTOM, 0L);
         break;
         }
         if (iFileLength%16 == 0) { xCaret=47; xCaretCount=16; }
         if (iFileLength%16 == 1 || iFileLength%16 == 2) {
             xCaret=8+(iFileLength%16 * 2);
             xCaretCount=iFileLength%16;
         }
         if (iFileLength%16 == 3 || iFileLength%16 == 4) {
             xCaret=8+(iFileLength%16 * 2)+1;
             xCaretCount=iFileLength%16;
         }
         if (iFileLength%16 == 5 || iFileLength%16 == 6) {
             xCaret=8+(iFileLength%16 * 2)+2;
             xCaretCount=iFileLength%16;
         }
         if (iFileLength%16 == 7 || iFileLength%16 == 8) {
             xCaret=8+(iFileLength%16 * 2)+3;
             xCaretCount=iFileLength%16;
         }
         if (iFileLength%16 == 9 || iFileLength%16 == 10) {
             xCaret=8+(iFileLength%16 * 2)+4;
             xCaretCount=iFileLength%16;
         }
         if (iFileLength%16 == 11 || iFileLength%16 == 12) {
             xCaret=8+(iFileLength%16 * 2)+5;
             xCaretCount=iFileLength%16;
         }
         if (iFileLength%16 == 13 || iFileLength%16 == 14) {
             xCaret=8+(iFileLength%16 * 2)+6;
             xCaretCount=iFileLength%16;
         }
         if (iFileLength%16 == 15) {
             xCaret=8+(iFileLength%16 * 2)+7;
             xCaretCount=iFileLength%16;
         }
         SendMessage (hwndChild, WM_VSCROLL, SB_BOTTOM, 0L);
         break;

    case VK_PRIOR:
          SendMessage (hwndChild, WM_VSCROLL, SB_PAGEUP, 0L);
          if(iVscrollPos == 0) { SendMessage(hwndChild, WM_KEYDOWN, VK_HOME, 0L); }
          break;

    case VK_NEXT:
         if(numLines <= cyClient/cyChar) { SendMessage(hwndChild, WM_KEYDOWN, VK_END, 0L); }
         SendMessage (hwndChild, WM_VSCROLL, SB_PAGEDOWN, 0L);
         SendMessage (hwndChild, WM_VSCROLL, SB_ENDSCROLL, 0L);
         break;

    case VK_UP:
         if(iVscrollPos == 0 && yCaret == 0 && xCaret < 49) { xCaret=10; xCaretCount=1; break; }
         if(iVscrollPos == 0 && yCaret == 0 && xCaret > 49) { xCaret=50; xCaretCount=1; break; }
         if(yCaret > 0) { yCaret=yCaret--; }
         else { SendMessage (hwndChild, WM_VSCROLL, SB_LINEUP, 0L); }
         break;

    case VK_RIGHT:
         if ((xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) == iFileLength) { break; }
         if (xCaret > 49 && xCaret < 66) {
             xCaret++;
             xCaretCount++;
         if (xCaret == 66 && yCaret*cyChar < cyClient-20) {
             yCaret++;
             xCaret=50;
             xCaretCount=1;
         }
         if (xCaret == 66 && yCaret*cyChar > cyClient-20) {
             SendMessage (hwndChild, WM_VSCROLL, SB_LINEDOWN, 0L);
         if (iVscrollPos+yCaret == iFileLength/16 && iFileLength%16 == 0) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
             yCaret++;
         }
         if (iVscrollPos+yCaret == iFileLength/16 && iFileLength%16 != 0) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
         }
         xCaretCount=1;
         xCaret=50;
         break;
         }
         }
         if (xCaret <= 48) {
         if (xCaret == 47 && yCaret*cyChar > cyClient-20) {
             SendMessage (hwndChild, WM_VSCROLL, SB_LINEDOWN, 0L);
         if (iVscrollPos+yCaret == iFileLength/16 && iFileLength%16 == 0) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
             yCaret++;
         }
         if (iVscrollPos+yCaret == iFileLength/16 && iFileLength%16 != 0) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
         }
         xCaret=10;
         xCaretCount=1;
         break;
         }
         if(xCaret == 47) {
            yCaret++;
            xCaret=10;
            xCaretCount=1;
            break;
         }
         if (xCaret == 10 || xCaret == 15 || xCaret == 20 || xCaret == 25 ||
             xCaret == 30 || xCaret == 35 || xCaret == 40 || xCaret == 45) {
             xCaret+=2;
             xCaretCount++;
             break;
         }
         if (xCaret == 12 || xCaret == 17 || xCaret == 22 || xCaret == 27 ||
             xCaret == 32 || xCaret == 37 || xCaret == 42 || xCaret == 47) {
             xCaret+=3;
             xCaretCount++;
             break;
         }
         if (xCaret == 11 || xCaret == 16 || xCaret == 21 || xCaret == 26 ||
             xCaret == 31 || xCaret == 36 || xCaret == 41 || xCaret == 46) {
             xCaret+=1;
             xCaretCount++;
             break;
         }
         if (xCaret == 13 || xCaret == 18 || xCaret == 23 || xCaret == 28 ||
             xCaret == 33 || xCaret == 38 || xCaret == 43) {
             xCaret+=2;
             xCaretCount++;
             break;
         }
         if (xCaret == 48) {
             xCaret=10;
             yCaret++;
             xCaretCount=1;
             break;
         }
         }
         break;

    case VK_BACK:
    case VK_LEFT:
         if (xCaret > 49 && xCaret < 66) {
         if (iVscrollPos == 0 && xCaret == 50 && yCaret == 0) { break; }
         if (xCaret == 50 && yCaret == 0) {
             SendMessage (hwndChild, WM_VSCROLL, SB_LINEUP, 0L);
             xCaret=65;
             xCaretCount=16;
             break;
         }
         if (xCaret == 50 && yCaret > 0){
             yCaret--;
             xCaret=65;
             xCaretCount=16;
             break;
         }
         xCaret--;
         xCaretCount--;
         break;
         }
         if (xCaret >= 10 && xCaret <= 48){
         if (iVscrollPos == 0 && xCaret == 10 && yCaret == 0) { break; }
         if (xCaret == 10 && yCaret == 0) {
             SendMessage (hwndChild, WM_VSCROLL, SB_LINEUP, 0L);
             xCaret=47;
             xCaretCount=16;
             break;
         }
         if (xCaret == 10 && yCaret != 0) {
             yCaret--;
             xCaret=47;
             xCaretCount=16;
             break;
         }
         if (xCaret == 12 || xCaret == 17 || xCaret == 22 || xCaret == 27 ||
             xCaret == 32 || xCaret == 37 || xCaret == 42 || xCaret == 47) {
             xCaret-=2;
             xCaretCount--;
             break;
         }
         if (xCaret == 15 || xCaret == 20 || xCaret == 25 || xCaret == 30 ||
             xCaret == 35 || xCaret == 40 || xCaret == 45) {
             xCaret-=3;
             xCaretCount--;
             break;
         }
         if (xCaret == 11 || xCaret == 13 || xCaret == 16 || xCaret == 18 ||
             xCaret == 21 || xCaret == 23 || xCaret == 26 || xCaret == 28 ||
             xCaret == 31 || xCaret == 33 || xCaret == 36 || xCaret == 38 ||
             xCaret == 41 || xCaret == 43 || xCaret == 46 || xCaret == 48) {
             xCaret-=1;
             break;
         }
         }
         break;

    case VK_DOWN:
         if (iFileLength/16 < cyClient/cyChar &&
             iFileLength/16-1 == yCaret) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
             break;
         }
         if (iFileLength/16 < cyClient/cyChar &&
             iFileLength/16 == yCaret) { break; }
         if (iVscrollPos == numLines-(cyClient/cyChar) &&
             yCaret == (cyClient/cyChar)-2 &&
             xCaretCount > iFileLength%16 &&
             iFileLength%16 != 0) { break; }
         if (iVscrollPos == numLines-(cyClient/cyChar) &&
             yCaret == (cyClient/cyChar)-1 &&
             iFileLength%16 == 0) { break; }
         if (iVscrollPos == numLines-(cyClient/cyChar) &&
             yCaret == (cyClient/cyChar)-2 &&
             (xCaretCount < iFileLength%16 || iFileLength%16 == 0)) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
         }
         if (iVscrollPos == numLines-(cyClient/cyChar) &&
             yCaret == (cyClient/cyChar)-3 &&
             xCaretCount >= iFileLength%16 &&
             iFileLength%16 != 0) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
         }
         if (iVscrollPos == (numLines-3)-(cyClient/cyChar) &&
             iFileLength%16 != 0 &&
             yCaret == cyClient/cyChar &&
             xCaretCount > iFileLength%16) {
             SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
         }
         if (iVscrollPos == (numLines-2)-(cyClient/cyChar) &&
            yCaret == cyClient/cyChar &&
            (xCaretCount <= iFileLength%16 || iFileLength%16 == 0)) {
            iVscrollPos+=2;
            SendMessage (hwndChild, WM_VSCROLL, 0L, 0L);
         }
         if (yCaret*cyChar < cyClient-20) { yCaret=yCaret++; }
         else { SendMessage (hwndChild, WM_VSCROLL, SB_LINEDOWN, 0L); }
         SendMessage (hwndChild, WM_VSCROLL, SB_ENDSCROLL, 0L);
         break;
         }
         SetCaretPos (xCaret * cxChar, yCaret * cyChar);

         if ((xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) < iFileLength) {
             wsprintf(lpszSbIoffset, "Offset: %08X", (xCaretCount-1)+
             (yCaret*16)+(iVscrollPos*16));
         } else { wsprintf(lpszSbIoffset, "%s", "EOF"); }
         SendMessage (hStatusWindow, SB_SETTEXT, 1 | 0, (LPARAM) lpszSbIoffset);
         return 0;

    case WM_CHAR:
         if (GetFileAttributes(ofn.lpstrFile) & 1)
         { OkMessage (hwnd,  "File [%s] is read only!", ofn.lpstrFileTitle); break; }
      switch (wParam)
      {
      default:
      if ((char) wParam == VK_BACK) { return 0; }
      if ((xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) == iFileLength) { break; }
      if (iVscrollPos == numLines-(cyClient/cyChar) &&
          yCaret == (cyClient/cyChar)-1 && xCaret == 10) {
          break;
      }
      if (xCaret >= 10 && xCaret <= 49) {
      if (((char) wParam >= '0' && (char) wParam <= '9') ||
         ((char) wParam >= 'a' && (char) wParam <= 'f') ||
         ((char) wParam >= 'A' && (char) wParam <= 'F')) {
         enterHex[0]= (char) wParam;
         enterHex[1]='\0';
         edHex = strtol(enterHex, &endptr, 16);

      if (xCaret == 10 || xCaret == 12 || xCaret == 15 || xCaret == 17 ||
          xCaret == 20 || xCaret == 22 || xCaret == 25 || xCaret == 27 ||
          xCaret == 30 || xCaret == 32 || xCaret == 35 || xCaret == 37 ||
          xCaret == 40 || xCaret == 42 || xCaret == 45 || xCaret == 47)
          {
          edHex = (c[(xCaretCount-1)+(16*yCaret)+(16*iVscrollPos)]%16)+(edHex*16);
          }

      if (xCaret == 11 || xCaret == 13 || xCaret == 16 || xCaret == 18 ||
          xCaret == 21 || xCaret == 23 || xCaret == 26 || xCaret == 28 ||
          xCaret == 31 || xCaret == 33 || xCaret == 36 || xCaret == 38 ||
          xCaret == 41 || xCaret == 43 || xCaret == 46 || xCaret == 48)
          {
          edHex = (c[(xCaretCount-1)+(16*yCaret)+(16*iVscrollPos)])-
          (c[(xCaretCount-1)+(16*yCaret)+(16*iVscrollPos)]%16)+(edHex);
          x++;
          }
          } else { MessageBeep(0); break; }
          }
      if (xCaret >= 50 && xCaret <= 65) {
          edHex = (char) wParam;
      if (z == NULL) { z = (int *) realloc (z, 100 * sizeof(int)); }
          x++;
      }
      if (x%100 == 0) { z = (int *) realloc (z, (x+100) * sizeof(int)); }
          c[(xCaretCount-1)+(16*yCaret)+(16*iVscrollPos)] = (char) edHex;
          bNeedSave=TRUE;
          bFind=FALSE;
          z[x]=(xCaretCount-1)+(16*yCaret)+(16*iVscrollPos);

      if (xCaret >= 10 && xCaret <= 49) {
          rcHex.left=cxChar*10;
          rcHex.top=cyChar*yCaret;
          rcHex.right=cxChar*49;
          rcHex.bottom=(cyChar*yCaret)+cyChar;
          InvalidateRect(hwndChild, &rcHex, FALSE);

          rcAscii.left=cxChar*50;
          rcAscii.top=cyChar*yCaret;
          rcAscii.right=cxChar*66;
          rcAscii.bottom=(cyChar*yCaret)+cyChar;
          InvalidateRect(hwndChild, &rcAscii, FALSE);
      }
      if (xCaret >= 50 && xCaret <= 65) {
          rcHex.left=((cxChar*xCaret)-(40*cxChar));
          rcHex.top=cyChar*yCaret;
          rcHex.right=cxChar*49;
          rcHex.bottom=(cyChar*yCaret)+cyChar;
          InvalidateRect(hwndChild, &rcHex, FALSE);

          rcAscii.left=cxChar*xCaret;
          rcAscii.top=cyChar*yCaret;
          rcAscii.right=(cxChar*xCaret)+cxChar;
          rcAscii.bottom=(cyChar*yCaret)+cyChar;
          InvalidateRect(hwndChild, &rcAscii, FALSE);
      }
      if (xCaret == 13 || xCaret == 18 || xCaret == 23 || xCaret == 28 ||
          xCaret == 33 || xCaret == 38 || xCaret == 43) { xCaret++; }

          xCaret++;

      if (xCaret == 49) {
      if (yCaret < cyClient/cyChar) {
          yCaret++;
          xCaret=10;
          xCaretCount=1;
      }
      if (cyClient/cyChar == yCaret && iFileLength%16 != 0 &&
         (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) >= iFileLength-(iFileLength%16+1)) {
          SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
          xCaret=10;
          xCaretCount=1;
      }
      if (yCaret == cyClient/cyChar && xCaretCount == 16 &&
         (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) < iFileLength-1) {
          xCaret=10;
          xCaretCount=1;
          SetCaretPos (xCaret * cxChar, yCaret * cyChar);
          SendMessage (hwndChild, WM_VSCROLL, SB_LINEDOWN, 0L);
      }
      if (cyClient/cyChar == yCaret &&
         (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) >= iFileLength-1) {
          SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
          yCaret++;
          xCaret=10;
          xCaretCount=1;
      }
      }
      if (xCaret == 66) {
      if (yCaret < cyClient/cyChar) {
          yCaret++;
          xCaret=50;
          xCaretCount=1;
      }
      if (yCaret == cyClient/cyChar && xCaretCount == 16 &&
         (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) < iFileLength-1) {
          xCaret=50;
          xCaretCount=1;
          SetCaretPos (xCaret * cxChar, yCaret * cyChar);
          SendMessage (hwndChild, WM_VSCROLL, SB_LINEDOWN, 0L);
      }
      if (cyClient/cyChar == yCaret && iFileLength%16 != 0 &&
         (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) >= iFileLength-(iFileLength%16+1)) {
          SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
          xCaret=50;
          xCaretCount=1;
      }
      if (cyClient/cyChar == yCaret && iFileLength%16 == 0 &&
         (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) >= iFileLength-1) {
          SendMessage (hwndChild, WM_KEYDOWN, VK_END, 0L);
          yCaret++;
          xCaret=50;
          xCaretCount=1;
      }
      }
      if (xCaret == 10 || xCaret == 50) { xCaretCount=1; }
      if (xCaret == 12 || xCaret == 51) { xCaretCount=2; }
      if (xCaret == 15 || xCaret == 52) { xCaretCount=3; }
      if (xCaret == 17 || xCaret == 53) { xCaretCount=4; }
      if (xCaret == 20 || xCaret == 54) { xCaretCount=5; }
      if (xCaret == 22 || xCaret == 55) { xCaretCount=6; }
      if (xCaret == 25 || xCaret == 56) { xCaretCount=7; }
      if (xCaret == 27 || xCaret == 57) { xCaretCount=8; }
      if (xCaret == 30 || xCaret == 58) { xCaretCount=9; }
      if (xCaret == 32 || xCaret == 59) { xCaretCount=10; }
      if (xCaret == 35 || xCaret == 60) { xCaretCount=11; }
      if (xCaret == 37 || xCaret == 61) { xCaretCount=12; }
      if (xCaret == 40 || xCaret == 62) { xCaretCount=13; }
      if (xCaret == 42 || xCaret == 63) { xCaretCount=14; }
      if (xCaret == 45 || xCaret == 64) { xCaretCount=15; }
      if (xCaret == 47 || xCaret == 65) { xCaretCount=16; }

      SetCaretPos (xCaret * cxChar, yCaret * cyChar);
      if ((xCaretCount-1)+(yCaret*16)+(iVscrollPos*16) < iFileLength) {
           wsprintf(lpszSbIoffset, "Offset: %08X", (xCaretCount-1)+
           (yCaret*16)+(iVscrollPos*16));
      } else { wsprintf(lpszSbIoffset, "%s", "EOF"); }
      SendMessage (hStatusWindow, SB_SETTEXT, 1 | 0, (LPARAM) lpszSbIoffset);
      break;
      }
      return 0;

    case WM_CREATE:
         hdc = GetDC (hwndChild);
         SelectObject(hdc, (CreateFont(18, 0, 0, 0, FW_NORMAL, 0, 0, 0,
         ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
         DEFAULT_PITCH | FF_MODERN, "Courier")));
         GetTextMetrics (hdc, &tm);
         cxChar = tm.tmAveCharWidth;
         cyChar = tm.tmHeight + tm.tmExternalLeading;
         ReleaseDC (hwndChild, hdc);
         return 0;

    case WM_SIZE:
         iVscrollMax = max (0, numLines - cyClient/cyChar);
         iVscrollPos = min (iVscrollPos, iVscrollMax);
   
         si.cbSize = sizeof(si);
         si.fMask  = SIF_POS|SIF_RANGE|SIF_DISABLENOSCROLL;
         si.nMin   = 0;
         si.nMax   = iVscrollMax;
         si.nPos   = iVscrollPos;
         SetScrollInfo(hwndChild, SB_VERT, &si, TRUE);
         return 0;

    case WM_VSCROLL:
     switch (LOWORD (wParam)) 
	 {
      case SB_ENDSCROLL:
        if (iVscrollPos == numLines-(cyClient/cyChar) &&
           ((yCaret == cyClient/cyChar) ||
           (yCaret == (cyClient/cyChar)-1)) &&
            iFileLength%16 == 0) {
            yCaret=(cyClient/cyChar)-2;
            SetCaretPos (xCaret * cxChar, yCaret * cyChar);
        }
        if (iVscrollPos == numLines-(cyClient/cyChar) &&
           iFileLength%16 != 0 &&
           (yCaret == cyClient/cyChar ||
           yCaret == (cyClient/cyChar)-1)){
           if (xCaretCount <= iFileLength%16) {
               yCaret=(cyClient/cyChar)-2;
               SetCaretPos (xCaret * cxChar, yCaret * cyChar);
           }
           if (xCaretCount > iFileLength%16) {
               yCaret=(cyClient/cyChar)-3;
               SetCaretPos (xCaret * cxChar, yCaret * cyChar);
           }
        }
        wsprintf(lpszSbIoffset, "Offset: %08X", (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16));
        SendMessage (hStatusWindow, SB_SETTEXT, 1 | 0, (LPARAM) lpszSbIoffset);
        return 0;

      case SB_TOP:
           iVscrollInc = -iVscrollPos;
           break;

      case SB_BOTTOM:
           iVscrollInc = iVscrollMax - iVscrollPos;
           break;

      case SB_LINEUP:
           iVscrollInc = -1;
           break;

      case SB_LINEDOWN:
           iVscrollInc = 1;
           break;

      case SB_PAGEUP:
           iVscrollInc = min (-1, -cyClient / cyChar);
           break;

      case SB_PAGEDOWN:
           iVscrollInc = max (1, cyClient / cyChar);
           break;
               
      case SB_THUMBTRACK:
           si.cbSize = sizeof(si);
           si.fMask  =  SIF_TRACKPOS;
           GetScrollInfo(hwndChild, SB_VERT, &si );
           iVscrollInc = (si.nTrackPos - iVscrollPos);
           break;
	 }

     iVscrollInc = max (-iVscrollPos, min (iVscrollInc, iVscrollMax - iVscrollPos));

     if (iVscrollInc != 0) {
         iVscrollPos += iVscrollInc;
         si.cbSize = sizeof(si);
         si.fMask  = SIF_POS;
         si.nPos   = iVscrollPos;
         SetScrollInfo(hwndChild, SB_VERT, &si, TRUE);
         InvalidateRect(hwndChild, NULL, FALSE);
         UpdateWindow(hwndChild);

      if (iVscrollPos >= numLines-((cyClient/cyChar)+1)) {
          rcBottom.left   = 0;
          rcBottom.top    = (cyClient)-(cyChar*3);
          rcBottom.right  = cxChar*66;
          rcBottom.bottom = cyClient;
          InvalidateRect(hwndChild, &rcBottom, TRUE);
          UpdateWindow(hwndChild);
      } 
      }
	 
      wsprintf(lpszSbIoffset, "Offset: %08X", (xCaretCount-1)+(yCaret*16)+(iVscrollPos*16));
      SendMessage (hStatusWindow, SB_SETTEXT, 1 | 0, (LPARAM) lpszSbIoffset);
      return 0;

    case WM_PAINT:
         hdc = BeginPaint (hwndChild, &ps);
         SelectObject(hdc, (CreateFont(18, 0, 0, 0, FW_NORMAL, 0, 0, 0,
         ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
         DEFAULT_QUALITY, DEFAULT_PITCH | FF_MODERN, "Courier")));

         iPaintBeg = max (0, (iVscrollPos + ps.rcPaint.top / cyChar));
         iPaintEnd = min (numLines, (iVscrollPos + ps.rcPaint.bottom / cyChar)+1);

      for (i=iPaintBeg;i<iPaintEnd;i++) {
        if ((t+a) >= iFileLength) { break; }
        y = cyChar * (0 - iVscrollPos + i);
        iHex1=(i*16);
        t=(i*16);
        wsprintf(szBuffer, "%08lX: ", iHex1);
        TextOut(hdc, cxChar*0, y, szBuffer, 9);
        b=0;

       for (a=0;a<16;a++) {
        if ((t+a) >= iFileLength) { break; }
        if (a < 15) { wsprintf(szBuffer2, "%02X ", c[t+a]); }
        if (a == 15 || t+a == (iFindPos+iOffset)-1) { wsprintf(szBuffer2, "%02X", c[t+a]); }
        if ((a & 1) == 1) { b+=2; } else { b+=3; }
        if (bNeedSave == TRUE) {
         for (l=0;l<=x;l++) { if (t+a == z[l]) { SetTextColor(hdc, RGB(255,0,0));} }
        }
        if (bFind == TRUE) {
         if (t+a >= iFindPos && t+a < iFindPos+iOffset) {
             SetTextColor(hdc, RGB(255,255,255));
             SetBkColor(hdc, RGB(0,0,0));
         }
       }
       TextOut(hdc, cxChar*(7+b), y, szBuffer2, lstrlen(szBuffer2));
       wsprintf(szBuffer2, "%hc", c[t+a]);
       if (szBuffer2[0] < 32 || szBuffer2[0] > 126) { szBuffer2[0]=46; }
       TextOut(hdc, cxChar*(50+a), y, szBuffer2, 1);
       SetTextColor(hdc, RGB(0,0,0));
       SetBkColor(hdc, RGB(255,255,255));
      }
     }
     DeleteObject (SelectObject (hdc, GetStockObject (SYSTEM_FONT)));
     EndPaint (hwndChild, &ps);
     return 0;
    }
return DefWindowProc (hwnd, iMsg, wParam, lParam);
}

int DoCaption (HWND hwnd, char *szTitleName)
     {
     char szCaption[64 + _MAX_FNAME + _MAX_EXT];

     wsprintf (szCaption, "%s - %s", " Hexiwin", szTitleName);

     SetWindowText (hwnd, szCaption);
	 return 0;
     }

int OkMessage (HWND hwnd, char *szMessage, char *szTitleName)
     {
     char szBuffer[64 + _MAX_FNAME + _MAX_EXT];

     wsprintf (szBuffer, szMessage, szTitleName[0] ? szTitleName : UNTITLED);

     MessageBox (hwnd, szBuffer, szAppName, MB_OK | MB_ICONEXCLAMATION | MB_TASKMODAL);
	 return 0;
     }

int AskAboutSave (HWND hwnd, char *szTitleName)
    {
    char szBuffer[64 + _MAX_FNAME + _MAX_EXT];
    int  iReturn;

    wsprintf (szBuffer, "Save current changes in %s?",
              szTitleName[0] ? szTitleName : UNTITLED);

    iReturn = MessageBox (hwnd, szBuffer, szAppName,
                          MB_YESNOCANCEL | MB_ICONQUESTION);

    if (iReturn == IDYES) {
      if (!SendMessage (hwnd, WM_COMMAND, IDM_SAVE, 0L)) { iReturn = IDCANCEL; }
    }
    return iReturn;
    }

LRESULT CALLBACK AboutDlgProc (HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
     {
     switch (iMsg)
          {
          case WM_INITDIALOG:
               return TRUE;

          case WM_COMMAND:
               switch (LOWORD (wParam))
                    {
		            case IDOK:
		            case IDCANCEL:
                         EndDialog (hDlg, 0);
			             return TRUE;
                    }
               break;
          }
     return FALSE;
     }

