/*
 * Decompiled with CFR 0.152.
 */
package com.jshift.ccu.sql;

import com.jshift.ccu.Attribute;
import com.jshift.ccu.AttributeMgr;
import com.jshift.ccu.CcuType;
import com.jshift.ccu.ColumnSet;
import com.jshift.ccu.Entity;
import com.jshift.ccu.EntityMgr;
import com.jshift.ccu.ExtrapolationParameters;
import com.jshift.ccu.IZ;
import com.jshift.ccu.TypeMapper;
import com.jshift.ccu.sql.A;
import com.jshift.ccu.sql.D;
import com.jshift.ccu.sql.E;
import com.jshift.ccu.sql.F;
import com.jshift.ccu.sql.J;
import com.jshift.ccu.sql.S;
import com.jshift.ccu.sql.SqlAttributeMgrStruct;
import com.jshift.ccu.util.Verifiable;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;

public abstract class SqlAttributeMgr
extends SqlAttributeMgrStruct {
    public static final String CHAR_TYPE = "char";
    public static final String NUMERIC_TYPE = "numeric";
    public static final String FIXED_WIDTH = "fixed_width";
    public static final String ENTITY_TYPE = "integer";

    public SqlAttributeMgr(Attribute attribute) {
        super(attribute);
        Verifiable verifiable = (Verifiable)this.getConditionalValues().get("format");
        this.getConditionalValues().put("format", new D(this, verifiable));
        this.getConditionalValues().put("explicitCheckConstraint", new F(this));
        this.getConditionalValues().put("checkConstraint", new J(this));
        this.appendConditionalVal("explicitMin", new S(this));
        this.appendConditionalVal("explicitFormat", new A(this));
        this.appendConditionalVal("explicitCode", new E(this));
    }

    public final byte getNameConversionOptions() {
        return 17;
    }

    public final char getNameConversionChar() {
        return '_';
    }

    public final Set getFixedWidthStringTypeSet() {
        SortedMap sortedMap = TypeMapper.getMapKeyedByVal(this.getLang(), TypeMapper.getTypeList(this.getLang()), FIXED_WIDTH);
        Set set = (Set)sortedMap.get("true");
        return set == null ? new HashSet() : set;
    }

    public Integer getMaxStrLength() {
        return null;
    }

    public final CcuType getType(ExtrapolationParameters extrapolationParameters) {
        CcuType ccuType = super.getType(extrapolationParameters);
        if (ccuType == null || ccuType.getArrayDepth() > 0) {
            return null;
        }
        if (this.isSimpleReference(extrapolationParameters)) {
            return ((Entity)ccuType.getVal()).getMgr(this.getLang()).getPrimaryKey(extrapolationParameters).getColumns()[0].getMgr(this.getLang()).getType(extrapolationParameters);
        }
        if (ccuType.getVal() instanceof Entity) {
            return new CcuType(ENTITY_TYPE);
        }
        return ccuType;
    }

    public final boolean isSimpleReference(ExtrapolationParameters extrapolationParameters) {
        CcuType ccuType = super.getType(extrapolationParameters);
        if (ccuType == null || ccuType.getArrayDepth() > 0 || !(ccuType.getVal() instanceof Entity)) {
            return false;
        }
        ColumnSet columnSet = ((Entity)ccuType.getVal()).getMgr(this.getLang()).getPrimaryKey(extrapolationParameters);
        return columnSet != null && columnSet.getColumns() != null && columnSet.getColumns().length == 1;
    }

    public Object getMax(ExtrapolationParameters extrapolationParameters) {
        if (this.isExplicitMax()) {
            return this.getMax();
        }
        if (this.getMaxStrLength() != null && this.getMasterEquivalentType(extrapolationParameters).getVal().equals("String") && this.getAttrib().getMgr(IZ.MASTER_STR).getMax(extrapolationParameters) == null) {
            return com.jshift.util.S.TO_NUMBER.execute(this.getMaxStrLength());
        }
        return super.getMax(extrapolationParameters);
    }

    public final boolean isNullable(ExtrapolationParameters extrapolationParameters) {
        if (!this.isExplicitNullable() && this.partOfPk(extrapolationParameters)) {
            return false;
        }
        return super.isNullable(extrapolationParameters);
    }

    public final Object getFormat(ExtrapolationParameters extrapolationParameters) {
        if (this.isExplicitFormat()) {
            return this.getFormat();
        }
        Object object = this.getAttrib().getMgr(IZ.MASTER_STR).getFormat(extrapolationParameters);
        CcuType ccuType = this.getMasterEquivalentType(extrapolationParameters);
        if (ccuType == null) {
            return null;
        }
        if (ccuType.getVal().equals("Number")) {
            if (this.getAttrib().getMgr(IZ.MASTER_STR).getFormat(extrapolationParameters) == null) {
                return new Byte(0);
            }
        } else {
            if (ccuType.getVal().equals("String")) {
                if (object == null) {
                    return null;
                }
                String string = ((Pattern)object).pattern();
                string = string.startsWith("^") ? string.substring(1) : ".*" + string;
                String string2 = string = string.endsWith("$") ? string.substring(0, string.length() - 1) : string + ".*";
                if (string.indexOf(92) != -1) {
                    return null;
                }
                if (string.matches("[^\\.][\\*\\+]")) {
                    return null;
                }
                string = string.replaceAll("\\.\\*", "%");
                string = string.replaceAll("\\.\\+", "_%");
                string = string.replaceAll("\\.", "_");
                return string;
            }
            if (ccuType.getVal().equals("Date")) {
                return null;
            }
        }
        return object;
    }

    public final Object getMasterEquivalentFormat(ExtrapolationParameters extrapolationParameters) {
        CcuType ccuType = this.getMasterEquivalentType(extrapolationParameters);
        if (ccuType == null) {
            return null;
        }
        if (ccuType.getVal().equals("String")) {
            String string = (String)this.getFormat(extrapolationParameters);
            if (string == null) {
                return null;
            }
            String string2 = string;
            string2 = string2.replace('_', '.');
            string2 = string2.replaceAll("%", ".*");
            string2.replaceAll("\\.\\.\\*", ".+");
            return Pattern.compile('^' + string2 + '$');
        }
        return super.getMasterEquivalentFormat(extrapolationParameters);
    }

    public final String getCheckConstraint(ExtrapolationParameters extrapolationParameters) {
        String string;
        if (this.isExplicitCheckConstraint()) {
            return this.getCheckConstraint();
        }
        CcuType ccuType = this.getMasterEquivalentType(extrapolationParameters);
        if (ccuType == null) {
            return null;
        }
        CcuType ccuType2 = this.getType(extrapolationParameters);
        if (ccuType2 == null) {
            return null;
        }
        String string2 = "";
        boolean bl = this.getFormat(extrapolationParameters) != null && ccuType.getVal().equals("String");
        Object object = this.getMin(extrapolationParameters);
        Object object2 = this.getMax(extrapolationParameters);
        String string3 = object == null ? null : object.toString();
        String string4 = string = object2 == null ? null : object2.toString();
        if (!bl && object == null && (object2 == null || ccuType.getVal().equals("String"))) {
            return null;
        }
        if (ccuType.getVal().equals("Date")) {
            if (object != null) {
                string3 = "to_date('" + object + "')";
            }
            if (object2 != null) {
                string = "to_date('" + object2 + "')";
            }
        } else if (ccuType.getVal().equals("String") && !this.getFixedWidthStringTypeSet().contains(ccuType2.getVal())) {
            string = null;
        }
        String string5 = this.getName(extrapolationParameters);
        if (ccuType.getVal().equals("String")) {
            String string6 = string5 = this.getFixedWidthStringTypeSet().contains(ccuType2.getVal()) ? "length(trim(" + string5 + "))" : "length(" + string5 + ')';
        }
        if (string3 != null || string != null) {
            string2 = string2 + string5 + ' ';
            if (string3 != null && string != null) {
                string2 = string2 + (this.minMaxEqualAndNotNull(extrapolationParameters) ? "= " + string3 : "between " + string3 + " and " + string);
            } else if (string3 != null) {
                if (!this.minMaxEqualAndNotNull(extrapolationParameters) && !ccuType.getVal().equals(CHAR_TYPE)) {
                    string2 = string2 + '>';
                }
                if (this.isInclusiveMin(extrapolationParameters) || this.minMaxEqualAndNotNull(extrapolationParameters)) {
                    string2 = string2 + '=';
                }
                string2 = string2 + ' ';
                string2 = string2 + string3;
            } else {
                string2 = string2 + '<';
                if (this.isInclusiveMax(extrapolationParameters)) {
                    string2 = string2 + '=';
                }
                string2 = string2 + ' ';
                string2 = string2 + string;
            }
            if (bl) {
                string2 = string2 + " and ";
            }
        }
        if (bl) {
            string2 = string2 + this.getName(extrapolationParameters) + " like '" + this.getFormat(extrapolationParameters) + '\'';
        }
        return string2;
    }

    public final String getCode(ExtrapolationParameters extrapolationParameters) {
        String string;
        if (this.isExplicitCode()) {
            return this.getCode();
        }
        CcuType ccuType = this.getMasterEquivalentType(extrapolationParameters);
        if (ccuType == null) {
            return null;
        }
        String string2 = this.getName(extrapolationParameters) + ' ';
        CcuType ccuType2 = this.getType(extrapolationParameters);
        if (ccuType2 == null) {
            return null;
        }
        string2 = string2 + ccuType2.getVal();
        if (ccuType.getVal().equals("String") && this.getMax(extrapolationParameters) != null) {
            string2 = string2 + '(';
            string2 = string2 + (this.isInclusiveMax(extrapolationParameters) || !this.isExplicitMax() ? ((Number)this.getMax(extrapolationParameters)).longValue() : ((Number)this.getMax(extrapolationParameters)).longValue() - 1L);
            string2 = string2 + ')';
        } else if (ccuType2.getVal().equals(NUMERIC_TYPE) && this.getMax(extrapolationParameters) != null) {
            byte by = (byte)Math.ceil(Math.log(((Number)this.getMax(extrapolationParameters)).intValue()) / Math.log(10.0));
            byte by2 = 0;
            try {
                by2 = ((Number)this.getFormat(extrapolationParameters)).byteValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = string2 + "(" + (by + by2) + ", " + by2 + ")";
        }
        if (this.getDefaultVal(extrapolationParameters) != null) {
            Character c = null;
            if (ccuType.getVal().equals("String")) {
                c = new Character('\'');
            }
            string2 = string2 + " default ";
            if (c != null) {
                string2 = string2 + c;
            }
            string2 = string2 + this.getDefaultVal(extrapolationParameters);
            if (c != null) {
                string2 = string2 + c;
            }
        }
        if (ccuType.getVal() instanceof Entity) {
            EntityMgr entityMgr = ((Entity)ccuType.getVal()).getMgr(this.getLang());
            string2 = string2 + " references " + entityMgr.getName(extrapolationParameters) + '.';
            if (this.isSimpleReference(extrapolationParameters)) {
                AttributeMgr attributeMgr = entityMgr.getPrimaryKey(extrapolationParameters).getColumns()[0].getMgr(this.getLang());
                string2 = string2 + attributeMgr.getName(extrapolationParameters);
            } else {
                string2 = string2 + "ID";
            }
        }
        if ((string = this.getCheckConstraint(extrapolationParameters)) != null) {
            string2 = string2 + " check " + string;
        }
        if (!this.isNullable(extrapolationParameters) && !this.partOfPk(extrapolationParameters)) {
            string2 = string2 + " not null";
        }
        return string2;
    }
}

