/************************************************
 *** Importing Functions Used Within Stickies ***
 ************************************************/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "filefuncs.h"
#include "sticky.h"

// ---------------------------------------------------------------------------

// convert old format to new format.
void Convert15to16 (StickyRec* pNewRec, StickyRecFMT15* pOldRec)
{    
    if ((pNewRec == NULL) || (pOldRec == NULL))
        return;

    memset (pNewRec, 0, sizeof (StickyRec));
    pNewRec->winDim        = pOldRec->winDim;               
    pNewRec->winDim.bottom = pNewRec->winDim.top + pNewRec->winDim.bottom;
    pNewRec->unrolledDim   = pNewRec->winDim;
    pNewRec->rolledDim     = pNewRec->winDim;

    pNewRec->textCol      = pOldRec->textCol;
    pNewRec->backCol      = pOldRec->backCol;
    pNewRec->backGH       = pOldRec->backGH;    
    pNewRec->rolledUp     = pOldRec->rolledUp;
    pNewRec->minimised    = pOldRec->minimised;
    pNewRec->restored     = pOldRec->restored;
    pNewRec->winShowState = pOldRec->winShowState;
    pNewRec->topMostWin   = pOldRec->topMostWin;
    pNewRec->vScrollBar   = pOldRec->vScrollBar;
    pNewRec->hScrollBar   = pOldRec->hScrollBar;
    pNewRec->thinEdge     = pOldRec->thinEdge;
    pNewRec->userMemo     = pOldRec->userMemo;
    pNewRec->wordWrapped  = pOldRec->wordWrapped;
    pNewRec->stickyWnd    = pOldRec->stickyWnd;
    pNewRec->editControl  = pOldRec->editControl;    
    pNewRec->editFont     = pOldRec->editFont;
    pNewRec->hFont        = pOldRec->hFont;
    pNewRec->titleFont    = pOldRec->titleFont;    
    
    strcpy (pNewRec->winCaption, pOldRec->winCaption);
   
    pNewRec->stickyAlrm.year          = pOldRec->stickyAlrm.year;
    pNewRec->stickyAlrm.month         = pOldRec->stickyAlrm.month;
    pNewRec->stickyAlrm.hour          = pOldRec->stickyAlrm.hour;
    pNewRec->stickyAlrm.minute        = pOldRec->stickyAlrm.minute;
    pNewRec->stickyAlrm.AMPM          = pOldRec->stickyAlrm.AMPM;
    pNewRec->stickyAlrm.alarmSndRpt   = pOldRec->stickyAlrm.alarmSndRpt;
    pNewRec->stickyAlrm.LoopPlayback  = pOldRec->stickyAlrm.LoopPlayback;
    pNewRec->stickyAlrm.alarmEnabled  = pOldRec->stickyAlrm.alarmEnabled;
    pNewRec->stickyAlrm.alarmBlinkCol = pOldRec->stickyAlrm.alarmBlinkCol;
    pNewRec->stickyAlrm.alarmBlinking = pOldRec->stickyAlrm.alarmBlinkCol;
    
    // Conver day alarm.
    if (pOldRec->stickyAlrm.day = ALRMEVERY)
    {
        pNewRec->stickyAlrm.day          = (unsigned int) ~0;
        pNewRec->stickyAlrm.everyDayTest = TRUE;
    }
    else
        pNewRec->stickyAlrm.day = (1 <<  (pOldRec->stickyAlrm.day-1));
}

/* import a exported sticky record or text file into a sticky.
   
   return values.

   0  : successful
   -1     : user quit, bad file.
*/
int ImportStickyFile (char* pFileName)
{
        // Load the contents of the file into a new sticky.
    FILE* inFile  = fopen (pFileName, "rb");
    int   wndIdx  = GetNextStickyFree ();
    long  fileLen = 0;
    char  testBuff[32];

    if (inFile == NULL)
    {
        MessageBox(NULL,"Unable to open file", "File Read Error", MB_OK | MB_ICONSTOP);
        return -1;
    }

    if (wndIdx < 0)
    {
        MessageBox(NULL,"Unable to allocate a sticky window", "Sticky Create Error", 
                   MB_OK | MB_ICONSTOP);
        fclose (inFile);
        return -1;
    }
 
    // Determine the type of file
    fread (testBuff, strlen(EXPORTVERSION16), 1, inFile);
    testBuff[strlen(EXPORTVERSION16)] = '\0';
    if ((strcmp (testBuff, EXPORTVERSION16) == 0) || 
        (strcmp (testBuff, EXPORTVERSION15) == 0))
    {
        // Load sticky window info from file
        if (strcmp (testBuff, EXPORTVERSION15) == 0)
        {
            StickyRecFMT15 oldFmt;
            fread (&oldFmt, sizeof (oldFmt), 1, inFile);
            Convert15to16 (&StickyRecords[wndIdx], &oldFmt);
        }
        else
            fread (&StickyRecords[wndIdx], sizeof (StickyRecords[wndIdx]), 1, inFile);

        StickyRecords[wndIdx].editControl = NULL;
        StickyRecords[wndIdx].stickyWnd   = NULL;
        StickyRecords[wndIdx].hFont       = NULL;
        StickyRecords[wndIdx].backGH      = NULL;

        // Load string 
        if (StickyRecords[wndIdx].userMemo.strLen > 0)
        {
            // Allocate the required memory.
            StickyRecords[wndIdx].userMemo.pString = new char[StickyRecords[wndIdx].userMemo.strLen+1];

            // Load string data from file.
            if (StickyRecords[wndIdx].userMemo.pString != NULL)
                fread (StickyRecords[wndIdx].userMemo.pString, StickyRecords[wndIdx].userMemo.strLen+1, 1, inFile);
        }
        else
           StickyRecords[wndIdx].userMemo.pString = NULL;
    }
    else
    {
        // Initialise the new sticky.
        StickyRecords[wndIdx] = StickyRecords[STICKRECNUM];

        // Fix the length of the file if it is too long
        if (strlen (pFileName) > (CAPTIONSIZE-1))
            pFileName[(CAPTIONSIZE-1)] = '\0';

        strcpy (StickyRecords[wndIdx].winCaption, pFileName);

        fseek (inFile, 0, SEEK_END);
        fileLen = ftell(inFile);
        fseek (inFile, 0, SEEK_SET);
    
        // Allocate memory for contents of file 
        if (fileLen <= 0)
        {
            StickyRecords[wndIdx].userMemo.pString = "";
            StickyRecords[wndIdx].userMemo.strLen  = 0;
        }
        else
        {
            // Allocate the required memory.
            StickyRecords[wndIdx].userMemo.pString = new char[fileLen+1];

            // Load string data from file.
            if (StickyRecords[wndIdx].userMemo.pString != NULL)
            {
                fread (StickyRecords[wndIdx].userMemo.pString, fileLen, 1, inFile);
                StickyRecords[wndIdx].userMemo.pString[fileLen] = '\0';
            }
        }
    
        StickyRecords[wndIdx].userMemo.strLen  = fileLen;
    }

    // Create the sticky !    
    LoadSticky (ParentStarter, wndIdx, TRUE);
    
    fclose (inFile);

    return 0;
}

// ---------------------------------------------------------------------------

/* import a exported sticky record or text file into a sticky with Dialogbox Prompt.
   
   return values.

   0  : successful
   -1     : user quit, bad file.
*/
int ImportStickyFile (void)
{
    const int       maxFile       = 1024;
    const char*     pFileTypes    = "Sticky Record Files\0*.exp\0"
                                    "text Files\0*.txt;*.doc;*.text;*.diz\0"
                                    "All Files\0*.*\0\0"; 
    char            Errstr[256]   = "GetOpenFileName returned Error #";
    OPENFILENAME    fileSelect;
    DWORD           Errval;         // Error value
    char            buf[5];         // Error buffer
    char            pFileName[maxFile];

    // Reset return pointers variables to null.
    pFileName[0]    = '\0';
    memset (&fileSelect, 0, sizeof (fileSelect));

    fileSelect.hwndOwner         = ParentStarter;
    fileSelect.lStructSize       = sizeof(OPENFILENAME);
    fileSelect.lpstrFilter       = (LPSTR)pFileTypes;  
    fileSelect.lpstrCustomFilter = NULL;
    fileSelect.nFilterIndex      = 1;
    fileSelect.lpstrFile         = (LPSTR)pFileName;  
    fileSelect.nMaxFile          = maxFile;
    fileSelect.lpstrFileTitle    = "";           
    fileSelect.nMaxFileTitle     = 0;
    fileSelect.lpstrInitialDir   = ".\\";            
    fileSelect.lpstrTitle        = "Select Text File To Import";
    fileSelect.Flags             = OFN_HIDEREADONLY  | OFN_FILEMUSTEXIST | 
                                   OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR;
    fileSelect.lpstrDefExt       = "*.txt";

    if(GetOpenFileName(&fileSelect) != TRUE)
    {
        Errval = CommDlgExtendedError();

        if(Errval != 0) // 0 value means user selected Cancel
        {
            sprintf(buf,"%ld",Errval);
            strcat(Errstr,buf);
            MessageBox(NULL,Errstr,"- WARNING - Something Weird Ocurred!", MB_OK | MB_ICONSTOP);
        }

        return -1;
    }

    return ImportStickyFile (pFileName);
}

// ---------------------------------------------------------------------------

BOOL ExportStickyRecord (char* pFileName, int wndIdx, int mode)
{
    FILE* outFile = fopen (pFileName, "wb");

    if (outFile == NULL)
        return FALSE;

    // Get Window text
    SaveStickyWinPos (wndIdx);
    StickyRecords[wndIdx].userMemo.strLen = (int) SendMessage(StickyRecords[wndIdx].editControl, WM_GETTEXTLENGTH, 0, 0L);

    if (StickyRecords[wndIdx].userMemo.strLen >= 0)
    {
        StickyRecords[wndIdx].userMemo.pString = new char[StickyRecords[wndIdx].userMemo.strLen+1];

        if (StickyRecords[wndIdx].userMemo.pString != NULL)
           SendMessage(StickyRecords[wndIdx].editControl, WM_GETTEXT, StickyRecords[wndIdx].userMemo.strLen+1,
                (LPARAM) ((LPSTR) StickyRecords[wndIdx].userMemo.pString));
    }

    // Save the contents of the sticky to a file 
    switch (mode)
    {
        case RECORDMODE:
            // Output the header 
            fprintf (outFile, "%s", EXPORTVERSION16);
            
            // Output the rest of the data ...
            fwrite (&StickyRecords[wndIdx], sizeof (StickyRecords[wndIdx]), 1, outFile);

            // Save Memo
            if (StickyRecords[wndIdx].userMemo.pString != NULL)                            
                fwrite (StickyRecords[wndIdx].userMemo.pString, StickyRecords[wndIdx].userMemo.strLen+1, 1, outFile);
            break;

        case TEXTMODE:
        default:            
            // Output the title ...
            if (strlen(StickyRecords[wndIdx].winCaption) > 0)
            {
                fprintf (outFile, "%s\r\n", StickyRecords[wndIdx].winCaption);

                for (int idx = 0; StickyRecords[wndIdx].winCaption[idx] != '\0'; idx++)
                    fprintf (outFile, "-");

                fprintf (outFile, "\r\n");
            }

            // Output the body
            if (StickyRecords[wndIdx].userMemo.pString != NULL)
                fprintf (outFile, "%s", StickyRecords[wndIdx].userMemo.pString);
    }

    // Clean up
    delete[] StickyRecords[wndIdx].userMemo.pString;
    StickyRecords[wndIdx].userMemo.pString = NULL;

    fclose (outFile);

    return TRUE;
}

// ---------------------------------------------------------------------------

BOOL SaveAsStickyRec (char* pFileName)
{
    const char* pExt = ".exp";

    _strlwr (pFileName);
    if (strlen (pFileName) < strlen (pExt))
        return FALSE;

    
    for (int chkIdx = strlen(pExt)-1, fIdx = strlen(pFileName)-1; chkIdx >= 0; chkIdx--, fIdx--)
    {
        if (pExt[chkIdx] != pFileName[fIdx])
            return FALSE;
    }

    return TRUE;
}

// ---------------------------------------------------------------------------

int ExportStickyFile (int wndIdx)
{
    const int       maxFile       = 1024;
    const char*     pFileTypes    = "Save As Sticky Record File\0*.exp\0"
                                    "Save As Text File\0*.txt\0\0";
    char            Errstr[256]   = "GetSaveFileName returned Error #";
    OPENFILENAME    fileSelect;
    DWORD           Errval;         // Error value
    char            buf[5];         // Error buffer
    char            pFileName[maxFile];

    // Copy over file name from sticky caption and remove directory control characters.        
    strcpy (pFileName, StickyRecords[wndIdx].winCaption);
    for (int idx =0; pFileName[idx] != '\0'; idx++)
    {
        switch (pFileName[idx])
        {
            case '|': case '<': case '>': case '"': case '?': 
            case '*': case ':': case '/': case '\\':
                pFileName[idx] = ' ';
                break;
        }
    }
    // Reset file select structure
    memset (&fileSelect, 0, sizeof (fileSelect));

    fileSelect.hwndOwner         = StickyRecords[wndIdx].stickyWnd;
    fileSelect.lStructSize       = sizeof(OPENFILENAME);
    fileSelect.lpstrFilter       = (LPSTR)pFileTypes;  
    fileSelect.lpstrCustomFilter = NULL;
    fileSelect.nFilterIndex      = 1;
    fileSelect.lpstrFile         = (LPSTR)pFileName;
    fileSelect.nMaxFile          = maxFile;
    fileSelect.lpstrFileTitle    = "";           
    fileSelect.nMaxFileTitle     = 0;
    fileSelect.lpstrInitialDir   = ".\\";            
    fileSelect.lpstrTitle        = "Select File Type To Export";
    fileSelect.Flags             = OFN_HIDEREADONLY  | OFN_OVERWRITEPROMPT | 
                                   OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR;
    fileSelect.lpstrDefExt       = "*.exp";

    if(GetSaveFileName(&fileSelect) != TRUE)
    {
        Errval = CommDlgExtendedError();

        if (Errval != 0)    // 0 value means user selected Cancel
        {
            sprintf(buf,"%ld",Errval);
            strcat(Errstr,buf);
            MessageBox(NULL,Errstr,"- WARNING - Something Weird Ocurred!", MB_OK | MB_ICONSTOP);
        }

        return -1;
    }

    if (SaveAsStickyRec (pFileName) != FALSE)
    {
        if (ExportStickyRecord (pFileName, wndIdx, RECORDMODE) == FALSE)
            return -1;
    }
    else
    {
        if (ExportStickyRecord (pFileName, wndIdx, TEXTMODE) == FALSE)
            return -1;
    }

    return 0;
}

// ---------------------------------------------------------------------------

/* import a drag/drop sticky...
   
   return values.

   0  : successful
   -1     : user quit, bad file.
*/
int ImportDragDropFile (char* pFileName, int mode, int wndIdx)
{
    FILE* inFile  = fopen (pFileName, "rb");
    char* pNewText;
    long  fileLen = 0;
    char  testBuff[32];
    int   savePos;

    if (inFile == NULL)
    {
        MessageBox(NULL,"Unable to open file", "File Read Error", MB_OK | MB_ICONSTOP);
        return -1;
    }

    if (wndIdx < 0)
    {
        MessageBox(NULL,"Bad sticky window error", "Unkown Error?", MB_OK | MB_ICONSTOP);
        fclose (inFile);
        return -1;
    }
 
    // Determine the type of file
    fread (testBuff, strlen(EXPORTVERSION15), 1, inFile);
    testBuff[strlen(EXPORTVERSION15)] = '\0';
    if (strcmp (testBuff, EXPORTVERSION15) == 0) 
        // Move past sticky window info, and go straight to the text.
        fseek(inFile, (ftell(inFile)+sizeof(StickyRecFMT15)), SEEK_SET);
    else if (strcmp (testBuff, EXPORTVERSION16) == 0)             
        // Move past sticky window info, and go straight to the text.
        fseek(inFile, (ftell(inFile)+sizeof(StickyRec)), SEEK_SET);
    else
        fseek (inFile, 0, SEEK_SET);

    savePos = ftell(inFile);
    fseek (inFile, 0, SEEK_END);
    fileLen = (ftell(inFile) - savePos);
    fseek (inFile, savePos, SEEK_SET);
    
    // Allocate memory for contents of file 
    if (fileLen <= 0)
        return -1;
    else
    {
        // Allocate the required memory.
        pNewText = new char[fileLen+1];

        // Load string data from file.
        if (pNewText != NULL)
        {
            fread (pNewText, fileLen, 1, inFile);
            pNewText[fileLen] = '\0';
        }
    }
    fclose (inFile);

    // Place text into current sticky control
    switch (mode)
    {
        case IDC_DDAPPEND:
            // Move cursor to the end of the edit control
            SendMessage (StickyRecords[wndIdx].editControl, EM_SETSEL, (WPARAM)(INT) 0, (LPARAM)(INT) -1);
            SendMessage (StickyRecords[wndIdx].editControl, EM_SETSEL, (WPARAM)(INT) -1, (LPARAM)(INT) -1);

            // Add new Text.
            SendMessage (StickyRecords[wndIdx].editControl, EM_REPLACESEL, 0, (LPARAM) (LPCSTR) pNewText);            
            break;

        case IDC_DDOVERWRITE:
            SetWindowText (StickyRecords[wndIdx].editControl, (LPCSTR) pNewText); 
            break;

        default:
            MessageBox(NULL,"Bad insert mode", "Unkown Error?", MB_OK | MB_ICONSTOP);
    }

    if (pNewText != NULL)
        delete[] pNewText;

    return 0;
}

// ---------------------------------------------------------------------------

int ImportStickyFileIntoEditControl (int mode, int wndIdx)
{
    const int       maxFile       = 1024;
    const char*     pFileTypes    = "Sticky Record Files\0*.exp\0"
                                    "text Files\0*.txt;*.doc;*.text;*.diz\0"
                                    "All Files\0*.*\0\0"; 
    char            Errstr[256]   = "GetOpenFileName returned Error #";
    OPENFILENAME    fileSelect;
    DWORD           Errval;         // Error value
    char            buf[5];         // Error buffer
    char            pFileName[maxFile];

    // Reset return pointers variables to null.
    pFileName[0]    = '\0';
    memset (&fileSelect, 0, sizeof (fileSelect));

    fileSelect.hwndOwner         = StickyRecords[wndIdx].stickyWnd;
    fileSelect.lStructSize       = sizeof(OPENFILENAME);
    fileSelect.lpstrFilter       = (LPSTR)pFileTypes;  
    fileSelect.lpstrCustomFilter = NULL;
    fileSelect.nFilterIndex      = 1;
    fileSelect.lpstrFile         = (LPSTR)pFileName;  
    fileSelect.nMaxFile          = maxFile;
    fileSelect.lpstrFileTitle    = "";           
    fileSelect.nMaxFileTitle     = 0;
    fileSelect.lpstrInitialDir   = ".\\";            
    fileSelect.lpstrTitle        = "Select Text File To Import";
    fileSelect.Flags             = OFN_HIDEREADONLY  | OFN_FILEMUSTEXIST | 
                                   OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR;
    fileSelect.lpstrDefExt       = "*.txt";

    if(GetOpenFileName(&fileSelect) != TRUE)
    {
        Errval = CommDlgExtendedError();

        if(Errval != 0) // 0 value means user selected Cancel
        {
            sprintf(buf,"%ld",Errval);
            strcat(Errstr,buf);
            MessageBox(NULL,Errstr,"- WARNING - Something Weird Ocurred!", MB_OK | MB_ICONSTOP);
        }

        return -1;
    }
    
    return  ImportDragDropFile (pFileName, mode, wndIdx);
}