unit RegFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TfrmRegister = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    grpRegister: TGroupBox;
    lblUserName: TLabel;
    lblChallenge: TLabel;
    lblUnlock: TLabel;
    edtUnlockString: TEdit;
    edtChallenge: TEdit;
    edtUserName: TEdit;
    procedure edtUserNameChange(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmRegister: TfrmRegister;

implementation

uses Slockfrm;

{$R *.DFM}

{*******************************************************************************
* Procedure : edtUserNameChange                                                *
********************************************************************************
* Purpose   : a) Updates the display of the challenge string                   *
*             b) Enables/disables the OK button                                *
********************************************************************************
* Paramters : None                                                             *
********************************************************************************
* Returns   : None                                                             *
*******************************************************************************}
procedure TfrmRegister.edtUserNameChange(Sender: TObject);
begin
     frmMain.Slock1.RegName := edtUserName.Text;
     edtChallenge.Text := frmMain.Slock1.ChallengeString;
     btnOK.Enabled := (Length(edtUserName.Text) > 0) and
                      (Length(edtUnlockString.Text) > 0);
end; {edtUserNameChange}

{*******************************************************************************
* Procedure : btnCancelClick                                                   *
********************************************************************************
* Purpose   : Closes the form                                                  *
********************************************************************************
* Paramters : None                                                             *
********************************************************************************
* Returns   : None                                                             *
*******************************************************************************}
procedure TfrmRegister.btnCancelClick(Sender: TObject);
begin
     Close;
end; {tnCancelClick}

{*******************************************************************************
* Procedure : btnOKClick                                                       *
********************************************************************************
* Purpose   : Closes the form and passes the unlock string back to Slock       *
********************************************************************************
* Paramters : None                                                             *
********************************************************************************
* Returns   : None                                                             *
*******************************************************************************}
procedure TfrmRegister.btnOKClick(Sender: TObject);
begin
     frmMain.Slock1.RegisterNow(edtUnlockString.Text);
     Close;
end; {btnOKClick}


end.
