unit abMisc;

interface

uses classes, abActnLst;

function GetStringItem(Expression: string; Count: integer; Separator: Char): string;
function DeleteStringItem(Expression: string; Count: integer; Separator: Char): string;

type
  //AB
  TabActionComponent = class(TComponent)
  private
    function GetAction: TabAction;
    procedure SetAction(anAction: TabAction);
    function GetText: string;
    procedure SetText(sText: string);

    function GetOnClick: TNotifyEvent;
    procedure SetOnClick(aNotifyEvent: TNotifyEvent);

    function GetHint: string;
    procedure SetHint(aHint: string);
  public
    class function IsActionComponent(aComponent: TComponent): boolean;
    property Action: TabAction read GetAction write SetAction;
    property Text: string read GetText write SetText;
    property OnClick: TNotifyEvent read GetOnClick write SetOnClick;
    property Hint: string read GetHint write SetHint;
  end;

implementation

uses
  Sysutils, menus, controls;

function GetStringItem(Expression: string; Count: integer; Separator: Char): string;
var
  i: integer;
  position: byte;
begin
  Result:= '';
  try
    for i:= 1 to Count  do
    begin
      position:= Pos(Separator, Expression);
      if position <> 0 then
      begin
        Result:= Copy(Expression, 1, Position - 1);
        Expression:= Copy(Expression, Position + 1, length(Expression) - Position);
      end
      else
      begin
        if i = Count then
          Result:= Expression
        else
          Result:= '';
        exit;
      end;
    end;
  finally
    Result:= Trim(Result);
  end;
end;

function DeleteStringItem(Expression: string; Count: integer; Separator: Char): string;
var
  i: integer;
  iSepCount, iSepPos1, iSepPos2: integer;
begin
  iSepCount := 0;
  iSepPos1 := 1;
  iSepPos2 := Length(Expression);
  for i:= 1 to Length(Expression) do
  begin
    if Expression[i] = Separator then
    begin
      inc(iSepCount);

    if iSepCount = Pred(Count) then
      iSepPos1 := i
    else if iSepCount = Count then
    begin
      iSepPos2 := i;
      break;
    end;
    end;
  end;
  if (iSepPos1 = 1) or (iSepPos2 = Length(Expression)) then
    Result := Copy(Expression, 1, Pred(iSepPos1)) + Copy(Expression, Succ(iSepPos2), length(Expression) - Pred(iSepPos2))
  else
    Result := Copy(Expression, 1, Pred(iSepPos1)) + Separator + Copy(Expression, Succ(iSepPos2), length(Expression) - Pred(iSepPos2))
end;


{ TabActionComponent }

//AB
class function TabActionComponent.IsActionComponent(aComponent: TComponent): boolean;
begin
  Result := ((aComponent is TMenuItem) and Assigned(TMenuItem(aComponent).Parent)) or (aComponent is TControl);
end;

function TabActionComponent.GetAction: TabAction;
begin
  if TComponent(Self) is TMenuItem then
    Result := TabAction(TMenuItem(Self).Action)
  else if TComponent(Self) is TControl then
    Result := TabAction(TControl(Self).Action)
  else
    Result := nil;
end;

procedure TabActionComponent.SetAction(anAction: TabAction);
begin
  if TComponent(Self) is TMenuItem then
    TMenuItem(Self).Action := anAction
  else if TComponent(Self) is TControl then
    TControl(Self).Action := anAction;
end;

function TabActionComponent.GetText: string;
begin
  if TComponent(Self) is TMenuItem then
    Result := TMenuItem(Self).Caption
  else if TComponent(Self) is TControl then
    Result := TabControl(Self).Text
  else
    Result := '';
end;

procedure TabActionComponent.SetText(sText: string);
begin
  if TComponent(Self) is TMenuItem then
    TMenuItem(Self).Caption := sText
  else if TComponent(Self) is TControl then
    TabControl(Self).Text := sText;
end;

function TabActionComponent.GetOnClick: TNotifyEvent;
begin
  if TComponent(Self) is TMenuItem then
    Result := TMenuItem(Self).OnClick
  else if TComponent(Self) is TControl then
    Result := TabControl(Self).OnClick
  else
    Result := nil;
end;

procedure TabActionComponent.SetOnClick(aNotifyEvent: TNotifyEvent);
begin
  if TComponent(Self) is TMenuItem then
    TMenuItem(Self).OnClick := aNotifyEvent
  else if TComponent(Self) is TControl then
    TabControl(Self).OnClick := aNotifyEvent;
end;

function TabActionComponent.GetHint: string;
begin
  if TComponent(Self) is TMenuItem then
    Result := TMenuItem(Self).Hint
  else if TComponent(Self) is TControl then
    Result := TabControl(Self).Hint
  else
    Result := '';
end;

procedure TabActionComponent.SetHint(aHint: string);
begin
  if TComponent(Self) is TMenuItem then
    TMenuItem(Self).Hint := aHint
  else if TComponent(Self) is TControl then
    TabControl(Self).Hint := aHint;
end;

end.

