unit RocksKbd;

{  ******
   *
   * Module:    Message
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    Based upon TWindowsKeyboard, the TRocksKeyboard class is a customization
   *    specifically for Rocks.  It defines things such as default key mappings
   *    for the game.
   *
   ****** }

interface
uses Keyboard, InpCodes, WinProcs,WinTypes,SysUtils;

{ Definition of the TRocksKeyboard class. }
type TRocksKeyboard = class(TWindowsKeyboard)
    public
        { Public constructor and destructor. }
        constructor Create;
        destructor Destroy; Override;

        { Method to read and write key mappings. }
        procedure ReadKeyMappings;
        procedure WriteKeyMappings;

        { Method to return default mappings for given inputs. }
        function wGetDefaultMapping(iInputCode: Integer): Word;

    private
        m_szSectionName: String;    { INI section where key mappings are stored. }
end;

implementation

Uses Global;

constructor TRocksKeyboard.Create;
begin
    { Initialize our base class. }
    inherited Create;

    { Define inputs that are used in Rocks. }
    DefineInput(BART_TURN_LEFT);
    DefineInput(BART_TURN_RIGHT);
    DefineInput(BART_THRUST);
    DefineInput(BART_FIRE);
    DefineInput(BART_HYPERSPACE);

    { Stash the name of the INI section where mappings will be stored. }
    m_szSectionName := 'Keys';

    { Get our default key mappings for Rocks. }
    ReadKeyMappings;
end;

destructor TRocksKeyboard.Destroy;
begin
    { Write out our current key mappings. }
    WriteKeyMappings;

    { Perform default cleanup. }
    inherited Destroy;
end;

procedure TRocksKeyboard.ReadKeyMappings;
var
    wKeyCode: Word;
begin
    { Get the 'turn left' key. }
    wKeyCode := g_envEnviron.iGetINIInteger(m_szSectionName, 'BartLeft', wGetDefaultMapping(BART_TURN_LEFT));
    AssociateKey(wKeyCode, BART_TURN_LEFT);

    { Get the 'turn right' key. }
    wKeyCode := g_envEnviron.iGetINIInteger(m_szSectionName, 'BartRight', wGetDefaultMapping(BART_TURN_RIGHT));
    AssociateKey(wKeyCode, BART_TURN_RIGHT);

    { Get the 'thrust' key. }
    wKeyCode := g_envEnviron.iGetINIInteger(m_szSectionName, 'BartThrust', wGetDefaultMapping(BART_THRUST));
    AssociateKey(wKeyCode, BART_THRUST);

    { Get the 'fire' key. }
    wKeyCode := g_envEnviron.iGetINIInteger(m_szSectionName, 'BartFire', wGetDefaultMapping(BART_FIRE));
    AssociateKey(wKeyCode, BART_FIRE);

    { Get the 'hyperspace' key. }
    wKeyCode := g_envEnviron.iGetINIInteger(m_szSectionName, 'BartHyperSpace', wGetDefaultMapping(BART_HYPERSPACE));
    AssociateKey(wKeyCode, BART_HYPERSPACE);
end;

procedure TRocksKeyboard.WriteKeyMappings;
begin
    { Stash all of the key mappings in the INI file. }
    g_envEnviron.SetINIString(m_szSectionName, 'BartLeft', IntToStr(wGetKeyCodeFromInput(BART_TURN_LEFT)));
    g_envEnviron.SetINIString(m_szSectionName, 'BartRight', IntToStr(wGetKeyCodeFromInput(BART_TURN_RIGHT)));
    g_envEnviron.SetINIString(m_szSectionName, 'BartThrust', IntToStr(wGetKeyCodeFromInput(BART_THRUST)));
    g_envEnviron.SetINIString(m_szSectionName, 'BartFire', IntToStr(wGetKeyCodeFromInput(BART_FIRE)));
    g_envEnviron.SetINIString(m_szSectionName, 'BartHyperSpace', IntToStr(wGetKeyCodeFromInput(BART_HYPERSPACE)));
end;

function TRocksKeyboard.wGetDefaultMapping(iInputCode: Integer): Word;
begin
    { Return the default key mapping for the given input. }
    case iInputCode of
        BART_TURN_LEFT:   Result := VK_LEFT;
        BART_TURN_RIGHT:  Result := VK_RIGHT;
        BART_THRUST:      Result := VK_UP;
        BART_FIRE:        Result := VK_SPACE;
        BART_HYPERSPACE:  Result := VK_RETURN;
    else
    end;
end;

end.
