// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxdfp64.cpp 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxDatabase 64-bit file helpers are a collection of classes 
and standalone functions used to support large files on multiple
target platforms. NOTE: None of the data structures and 
functions defined are intended to be used directly. They are
used by the gxDatabase class to call the correct native 
64-bit file API function for each supported platform.
*/
// ----------------------------------------------------------- // 
#if defined (__64_BIT_DATABASE_ENGINE__)

#include "gxdfp64.h"

gxdFPTR64 *gxdFPTR64Create(const char *fname)
// Create a new file and truncate existing files.
// Returns a null value if the file cannot be
// created.
{
  gxdFPTR64 *stream = new gxdFPTR64;
  if(!stream) return 0;
#if defined (__WIN32__) && defined (__MSVC__)
  stream->fptr = _open(fname, _O_BINARY | _O_CREAT | _O_RDWR | _O_TRUNC, 
		       _S_IREAD | _S_IWRITE);
  if(stream->fptr < 0) return 0;
#elif defined (__UNIX__)
  // Non-POSIX standard API interfaces to support large files.
  stream->fptr = fopen64(fname, "w+");
  if(stream->fptr == 0) return 0;
#else
#error You must define a target platform and/or compiler
#endif
  return stream;
}

gxdFPTR64 *gxdFPTR64Open(const char *fname, gxDatabaseAccessMode mode)
// Open an existing file. The "mode" variable determines if the file
// is opened for read only or read/write access. Returns a null value
// if the specified file cannot be opened. NOTE: This version of the
// open functions will only accept: gxDBASE_READONLY and gxDBASE_READWRITE
// access modes.
{
  gxdFPTR64 *stream = new gxdFPTR64;
  if(!stream) return 0;

  if(mode == gxDBASE_READONLY) { // Open for read only access
#if defined (__WIN32__) && defined (__MSVC__)
    stream->fptr = _open(fname, _O_BINARY | _O_RDONLY, _S_IREAD);
    if(stream->fptr < 0) return 0;
#elif defined (__UNIX__)
    // Non-POSIX standard API interfaces to support large files.
    stream->fptr = fopen64(fname, "r");
    if(stream->fptr == 0) return 0;
#else
#error You must define a target platform and/or compiler
#endif
  }
  else { // Open for read/write access
#if defined (__WIN32__) && defined (__MSVC__)
    stream->fptr = _open(fname, _O_BINARY | _O_RDWR, _S_IREAD | _S_IWRITE);
    if(stream->fptr < 0) return 0;
#elif defined (__UNIX__)
    // Non-POSIX standard API interfaces to support large files.
    stream->fptr = fopen64(fname, "r+");
    if(stream->fptr == 0) return 0;
#else
#error You must define a target platform and/or compiler
#endif
  }
  return stream;
}

int gxdFPTR64Close(gxdFPTR64 *stream)
// Close an open file. Returns a non-zero value to
// indicate an error condition or zero if successful.
{
  if(!stream) return 0; // The file stream is not open
#if defined (__WIN32__) && defined (__MSVC__)
  if(_close(stream->fptr) != 0) return 1;
#elif defined (__UNIX__)
  if(fclose(stream->fptr) != 0) return 1;
#else
#error You must define a target platform and/or compiler
#endif
  stream->fptr = 0;
  delete stream;
  return 0;
}

int gxdFPTR64Flush(gxdFPTR64 *stream)
// Flush the any open disk buffers. Returns
// a non-zero value to indicate an error
// condition or zero if successful. 
{
  if(!stream) return 0; // The file stream is not open
#if defined (__WIN32__) && defined (__MSVC__)
  // NOTE: Using unbuffer I/O under MSVC
  return 0;
#elif defined (__UNIX__)
  if(fflush(stream->fptr) != 0)
    return 1;
  else
    return 0;
#else
#error You must define a target platform and/or compiler
#endif
}

int gxdFPTR64Read(gxdFPTR64 *stream, void *buf, __UWORD__ bytes)
// Read a specified number of bytes from the current file position
// into a memory buffer. Returns a non-zero value to indicate an error
// condition or zero if successful.
{
  if(!stream) return 1; // The file stream is not open
  
#if defined (__WIN32__) && defined (__MSVC__)
  if(_read(stream->fptr, (unsigned char *)buf, bytes) != (int)bytes) return 1;
#elif defined (__UNIX__)
  if(fread((unsigned char *)buf, 1, bytes, stream->fptr) != bytes) return 1;
#else
#error You must define a target platform and/or compiler
#endif
  return 0;
}

int gxdFPTR64Write(gxdFPTR64 *stream, const void *buf, __UWORD__ bytes) 
// Write a specific number of bytes from a memory buffer to the
// current file position. Returns a non-zero value to indicate an
// error condition or zero if successful.
{
  if(!stream) return 1; // The file stream is not open
  
#if defined (__WIN32__) && defined (__MSVC__)
  if(_write(stream->fptr, (const unsigned char *)buf, bytes) != (int)bytes)
    return 1;
#elif defined (__UNIX__)
  if(fwrite((const unsigned char *)buf, 1, bytes, stream->fptr) != bytes)
    return 1;
#else
#error You must define a target platform and/or compiler
#endif
  return 0;
}

__LLWORD__ gxdFPTR64Seek(gxdFPTR64 *stream, __LLWORD__ offset,
			 gxDatabaseSeekMode mode)
// Seek to the specified offset starting at the beginning (gxDBASE_SEEK_SET),
// end (gxDBASE_SEEK_END) or current offset (gxDBASE_SEEK_CUR). Returns a 
// negative 1 to indicate an error condition or the current stream position 
// if successful.
{
  if(!stream) return 1; // The file stream is not open

  if(mode == gxDBASE_SEEK_BEG) {
#if defined (__WIN32__) && defined (__MSVC__)
    return _lseeki64(stream->fptr, offset, SEEK_SET);
#elif defined (__UNIX__)
    // Non-POSIX standard API interfaces to support large files.
    return fseeko64(stream->fptr, offset, SEEK_SET);
#else
#error You must define a target platform and/or compiler
#endif
  }
  else if(mode == gxDBASE_SEEK_CUR) {
#if defined (__WIN32__) && defined (__MSVC__)
    return _lseeki64(stream->fptr, offset, SEEK_CUR);
#elif defined (__UNIX__)
    // Non-POSIX standard API interfaces to support large files.
    return fseeko64(stream->fptr, offset, SEEK_CUR);
#else
#error You must define a target platform and/or compiler
#endif
  }
  else if(mode == gxDBASE_SEEK_END) {
#if defined (__WIN32__) && defined (__MSVC__)
    return _lseeki64(stream->fptr, offset, SEEK_END);
#elif defined (__UNIX__)
    // Non-POSIX standard API interfaces to support large files.
    return fseeko64(stream->fptr, offset, SEEK_CUR);
#else
#error You must define a target platform and/or compiler
#endif
  }
  else { // An invalid seek mode was specified
    return (__LLWORD__)-1;
  }
}

__LLWORD__ gxdFPTR64Tell(gxdFPTR64 *stream)
{
  if(!stream) return (__LLWORD__)-1; // The file stream is not open
  
#if defined (__WIN32__) && defined (__MSVC__)
  return _telli64(stream->fptr);
#elif defined (__UNIX__)
  // Non-POSIX standard API interfaces to support large files.
  return ftello64(stream->fptr);
#else
#error You must define a target platform and/or compiler
#endif
}

int gxdFPTR64Exists(const char *fname)
// Returns true if the specified file exists.
{
#if defined (__WIN32__) && defined (__MSVC__)
  struct _stati64 buf;
  return _stati64(fname, &buf) == (__LLWORD__)0;

#elif defined (__WIN32__) && defined (__BCC32__)
  struct stati64 buf;
  return _stati64(fname, &buf) == (__LLWORD__)0;

#elif defined (__UNIX__)
  // Non-POSIX standard API interfaces to support large files.
  struct stat64 buf;
  return stat64(fname, &buf) == (__LLWORD__)0;
#else
#error You must a target platform and/or compiler
#endif
}

__LLWORD__ gxdFPTR64FileSize(const char *fname)
// Returns the length of the specified file or negative 1
// to indicate an error condition.
{
#if defined (__WIN32__) && defined (__MSVC__)
    int fildes = open(fname, _O_BINARY | _O_RDONLY, _S_IREAD);
    if(fildes < 0) return (__LLWORD__)-1;
    return _filelengthi64(fildes);
#elif defined (__WIN32__) && defined (__BCC32__)
    struct stati64 buf;
    if(_stati64(fname, &buf) != (__LLWORD__)0) return (__LLWORD__)-1;
    return buf.st_size;
#elif defined (__UNIX__)
    // Non-POSIX standard API interfaces to support large files.
    struct stat64 buf;
    if(stat64(fname, &buf) != (__LLWORD__)0) return (__LLWORD__)-1;
    return buf.st_size;
#else
#error You must a target platform and/or compiler
#endif
}

#endif // __64_BIT_DATABASE_ENGINE__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
