// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: fstring.h 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/21/1997
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Fixed length string class used by database key types or members 
that must be fixed in length.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_FIXED_STRING_CLASS_HPP__
#define __GX_FIXED_STRING_CLASS_HPP__

#include <iostream.h>
#include <iomanip.h>
#include <strutil.h>
#include <string.h>

// This constant sets the string length for all FString objects.
// The total length for all FString objects is equal to the length
// specified in this constant plus one byte for a null terminator.
const unsigned FStringLength = 255; // Length not including null terminator

// Fixed length string class
class FString 
{ 
public:
  FString() { sptr[0] = 0; }
  FString(const char *s, unsigned bytes = 0) {
    SetString(s, bytes);
  }
  ~FString() { }    

  FString(const FString &s) { Copy(s); }
  FString &operator=(const char *s) { SetString(s); return *this; }
  FString &operator=(const FString &s) {
    if(this != &s) Copy(s); // Prevent self assignment 
    return *this;
  }

public: // Append, Insert, delete, and remove functions
  int SetString(const char *s, unsigned bytes = 0);
  void Clear();
  void Copy(const FString &s);

public: // C String, pointer, and length functions
  unsigned length() { return strlen(sptr); }
  unsigned length() const { return strlen(sptr); }
  char *c_str() { return (char *)sptr; }
  const char *c_str() const { return (const char *)sptr; }
  int is_null() { return sptr[0] == 0; } 
  int is_null() const { return sptr[0] == 0; }
  FString *strdup();
  FString *strdup() const;

public: // Database functions
  size_t SizeOf() { return sizeof(sptr); }

public: // Overloaded operators
  int operator!() { return sptr[0] == 0; } 
  int operator!() const { return sptr[0] == 0; }
  operator const int () const { return sptr[0] != 0; }
  operator int () { return sptr[0] != 0; }
  friend int operator==(const FString &a, const FString &b);
  friend int operator<(const FString &a, const FString &b);
  friend int operator>(const FString &a, const FString &b);
  friend int operator!=(const FString &a, const FString &b);

public: // Class type to ostream type conversions
  friend ostream &operator<<(ostream &os, const FString &s) {
    return os.write(s.sptr, strlen(s.sptr));
  }

  friend istream &operator>>(istream &os, FString &s) {
    os >> setw(FStringLength+1) >> s.sptr;
    return os;
  }
	       
public: // The FString structure can have only one data member
  char sptr[FStringLength+1]; // Fixed string length plus null terminator
};

// General-purpose string routines that need to be ported from UNIX to DOS
int CaseICmp(const FString &s1, const FString &s2);
int CaseICmp(FString &s1, FString &s2);
int CaseICmp(const FString &s1, const char *s);
int CaseICmp(const char *s, const FString &s2);

// Global variable used to toggle FString case comparisons
extern int FStringCaseCompare;

#endif // __GX_FIXED_STRING_CLASS_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
