// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: systime.cpp 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 12/11/1996 
// Date Last Modified: 06/27/2001
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA
  
The SysTime class is used to convert the system time to various
character string and integer formats.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "systime.h"

char *SysTimeUnit::c_str_Hours()
{
  const int MaxStrLen = 25;
  char str[MaxStrLen];
  sprintf(str, "%u", hours);
  int len = strlen(str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, str, len);
  return buf;
}

char *SysTimeUnit::c_str_Minutes()
{
  const int MaxStrLen = 25;
  char str[MaxStrLen];
  sprintf(str, "%u", minutes);
  int len = strlen(str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, str, len);
  return buf;
}

char *SysTimeUnit::c_str_Seconds()
{
  const int MaxStrLen = 25;
  char str[MaxStrLen];
  sprintf(str, "%u", seconds);
  int len = strlen(str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, str, len);
  return buf;
}

char *SysTimeUnit::c_str_Milliseconds()
{
  const int MaxStrLen = 25;
  char str[MaxStrLen];
  sprintf(str, "%u", milliseconds);
  int len = strlen(str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, str, len);
  return buf;
}

SysTime::SysTime()
{
  InitTimeBuffers();
}

void SysTime::InitTimeBuffers()
{
  time(&STime);
  TimeBuffer = localtime(&STime);
}

void SysTime::FormatTime(int Format)
{
  InitTimeBuffers();

  char TimeFormat[81];
  switch(Format)
    {
      case AMPM:             // AM or PM
        strftime(TimeFormat, 80, "%p", TimeBuffer);
	IntTimeFormat = 0;
	break;
	
      case Date:             // System date
        strftime(TimeFormat, 80, "%x", TimeBuffer);
	IntTimeFormat = 0;
	break;
	
      case DayOfTheMonth:    // Day of the month (01..31)
        strftime(TimeFormat, 80, "%d", TimeBuffer);
        IntTimeFormat = atoi(TimeFormat);
	break;
	
      case DayOfTheWeek:     // Display the day of the week (0..6, Sunday=0)
        strftime(TimeFormat, 80, "%w", TimeBuffer);
        IntTimeFormat = atoi(TimeFormat);	
	break;
	
      case Hour:             // Hour (24 hour clock - 00..23)
        strftime(TimeFormat, 80, "%H", TimeBuffer);
        IntTimeFormat = atoi(TimeFormat);	
	break;
	
      case JDay:             // Julian day
        strftime(TimeFormat, 80, "%j", TimeBuffer);
        IntTimeFormat = atoi(TimeFormat);
	break;
	
      case Minutes:          // Minutes (00..59)
        strftime(TimeFormat, 80, "%M", TimeBuffer);
	IntTimeFormat = atoi(TimeFormat);
	break;
	
      case Month:            // Month (01..12)
        strftime(TimeFormat, 80, "%m", TimeBuffer);
	IntTimeFormat = atoi(TimeFormat);
	break;
	
      case FullMonthName:    // Full month name 
        strftime(TimeFormat, 80, "%B", TimeBuffer);
	IntTimeFormat = 0;
	break;
	
      case MonthName:        // Abbreviated month name
        strftime(TimeFormat, 80, "%b", TimeBuffer);
	IntTimeFormat = 0;
	break;
	
      case Seconds:          // Seconds (00..59)
        strftime(TimeFormat, 80, "%S", TimeBuffer);
	IntTimeFormat = atoi(TimeFormat);
	break;

      case SystemTime:       // System time
        strftime(TimeFormat, 80, "%X", TimeBuffer);
	IntTimeFormat = 0;
	break;

      case TimeZoneName:     // Timezone name (null string if no timezone)
        strftime(TimeFormat, 80, "%Z", TimeBuffer);
	IntTimeFormat = 0;
	break;

      case WeekDayName:      // Abbreviated weekday name
        strftime(TimeFormat, 80, "%a", TimeBuffer);
	IntTimeFormat = 0;
	break;
	
      case FullWeekDayName:  // Full weekday name
        strftime(TimeFormat, 80, "%A", TimeBuffer);
	IntTimeFormat = 0;
	break;
	
      case WeekOfYearSF:     // Week of the year (00..52, Sunday first)
        strftime(TimeFormat, 80, "%U", TimeBuffer);
	IntTimeFormat = atoi(TimeFormat);
	break;
	
      case WeekOfYearMF:     // Week of the year (00..52, Monday first)
        strftime(TimeFormat, 80, "%W", TimeBuffer);
	IntTimeFormat = atoi(TimeFormat);
	break;
	
      case Year:             // Year (0000..9999)
	strftime(TimeFormat, 80, "%Y", TimeBuffer);
	IntTimeFormat = atoi(TimeFormat);
	break;

      case YearXX:           // Year (00..99)
        strftime(TimeFormat, 80, "%y", TimeBuffer);
	IntTimeFormat = atoi(TimeFormat);
	break;

      default: {               
	  char *mesg = "Invalid time format";
	  SBuffer = mesg;
	  IntTimeFormat = InvalidTimeFormat;
	  return;
	  break;
	}
    }

  SBuffer = TimeFormat;
  return;
}

char *SysTime::GetSystemDateTime(int full_month_name)
// Function used to copy the current system time and date 
// into a null-terminated string. 
{
  time_t STime;
  struct tm *TimeBuffer;
  char s[255];
  char month[25]; char day[25]; char year[25];
  char hour[25]; char minutes[25]; char seconds[25];
  time(&STime);
  TimeBuffer = localtime(&STime);
  if(full_month_name)
    strftime(month, 25, "%B", TimeBuffer);
  else
    strftime(month, 25, "%b", TimeBuffer);
  strftime(day, 25, "%d", TimeBuffer);
  strftime(year, 25, "%Y", TimeBuffer);
  strftime(hour, 25, "%H", TimeBuffer);
  strftime(minutes, 25, "%M", TimeBuffer);
  strftime(seconds, 25, "%S", TimeBuffer);

  // Weekday Name Month Day, Year HH:MM:SS
  sprintf(s, "%s %s, %s %s:%s:%s", month, day, year, hour, minutes, seconds);

  SBuffer = s;
  return SBuffer.c_str();
}

char *SysTime::GetSystemTime()
// Function used to copy the current system time into a
// null-terminated string. 
{
  time_t STime;
  struct tm *TimeBuffer;
  char s[255];
  char hour[25]; char minutes[25]; char seconds[25];
  time(&STime);
  TimeBuffer = localtime(&STime);
  strftime(hour, 25, "%H", TimeBuffer);
  strftime(minutes, 25, "%M", TimeBuffer);
  strftime(seconds, 25, "%S", TimeBuffer);

  // HH:MM:SS
  sprintf(s, "%s:%s:%s", hour, minutes, seconds);

  SBuffer = s;
  return SBuffer.c_str();
}

char *SysTime::GetSystemDate(int full_month_name)
// Function used to copy the current system date into a 
// null-terminated string. 
{
  time_t STime;
  struct tm *TimeBuffer;
  char s[255];
  char month[25]; char day[25]; char year[25];
  time(&STime);
  TimeBuffer = localtime(&STime);
  if(full_month_name)
    strftime(month, 25, "%B", TimeBuffer);
  else
    strftime(month, 25, "%b", TimeBuffer);
  strftime(day, 25, "%d", TimeBuffer);
  strftime(year, 25, "%Y", TimeBuffer);

  // Weekday Name Month Day, Year 
  sprintf(s, "%s %s, %s", month, day, year);

  SBuffer = s;
  return SBuffer.c_str();
}

int SysTime::DateSpan(char *s, unsigned days, int full_month_name)
// Function used to calculate a date span from a specified day.
// Returns false is an error occurs. This function assumes that
// memory has already been allocated for the "s" pointer.

{
  struct tm when;
  time_t now, result;
  char month[25]; char day[25]; char year[25];
  
  time(&now);
  when = *localtime(&now);

  when.tm_mday = when.tm_mday + days;
  if((result = mktime( &when )) != (time_t)-1 ) {
    if(full_month_name)
      strftime(month, 25, "%B", &when);
    else
      strftime(month, 25, "%b", &when);
    strftime(day, 25, "%d", &when);
    strftime(year, 25, "%Y", &when);
    
    // Weekday Name Month Day, Year 
    sprintf(s, "%s %s, %s", month, day, year);
  }
  else
    return 0;

  return 1; // Return true if no errors occurred
}

int SysTime::IsLeapYear(int year)
// Calculate leap years using the Gregorian leap
// year formula: 365 + 1/4 - 1/100 + 1/400
// Returns true if the specified year is a leap year.
{
  int is_leap_year;
  
  if(year % 4 != 0)
    is_leap_year = 0;
  else if(year % 400 == 0)
    is_leap_year = 1;
  else if(year % 100 == 0)
    // If the year is divisible by 100, it's not a 
    // leap year UNLESS it is also divisible by 400.
    is_leap_year = 0;
  else
    is_leap_year = 1;
    
  return is_leap_year;

}
  
int SysTime::DaysOld(int jday, int year)
// Calculate the number of days that have passed since the
// specified Julian day and four digit year.
{
  int age;
  time_t system_time;
  struct tm *time_now;
  char julian_day_cur[80];
  char julian_year_cur[80];
  int cur_day_value;
  int cur_year_value;
  int diff_year;
  int diff_day;

  time(&system_time);
  time_now = localtime(&system_time);
  strftime(julian_day_cur, 80, "%j", time_now );
  strftime(julian_year_cur, 80, "%Y", time_now );
  cur_day_value = atoi(julian_day_cur);
  cur_year_value = atoi(julian_year_cur);

  diff_day = (cur_day_value - jday);
  diff_year = (cur_year_value - year);

  // Compensate for year change 
  if((diff_year != 0) && (cur_day_value < jday)) {
    diff_day = (systimeYEAR_CONSTANT - jday) + cur_day_value;
    diff_year = (diff_year - 1);
  } 

  age = ((diff_year * systimeYEAR_CONSTANT) + diff_day);
  return(age);
} 

char *SysTime::GetGMTDateTime()
// Function used to make a date string in GMT time
// rather then local time. Returns a null terminated
// date string: Tue, 15 Nov 1994 08:12:31 GMT
{
  time_t STime;
  struct tm *TimeBuffer;
  char s[255];
  char month[25]; char day[25]; char year[25]; char wday_name[25];
  char hour[25]; char minutes[25]; char seconds[25];
  time(&STime);
  TimeBuffer = gmtime(&STime);

  strftime(month, 25, "%b", TimeBuffer);
  strftime(day, 25, "%d", TimeBuffer);
  strftime(year, 25, "%Y", TimeBuffer);
  strftime(hour, 25, "%H", TimeBuffer);
  strftime(minutes, 25, "%M", TimeBuffer);
  strftime(seconds, 25, "%S", TimeBuffer);
  strftime(wday_name, 25, "%a", TimeBuffer);

  // Weekday Name Month Day, Year HH:MM:SS
  //  Tue, 15 Nov 1994 08:12:31 GMT
  sprintf(s, "%s, %s %s %s %s:%s:%s GMT",
	  wday_name, day, month, year, hour, minutes, seconds);

  SBuffer = s;
  return SBuffer.c_str();
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
