// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: dfileb.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The disk file class is a general-purpose base class used handle
file and directory functions.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_DISK_FILE_BASE_HPP__
#define __GX_DISK_FILE_BASE_HPP__

#include <fstream.h>

// --------------------------------------------------------------
// Type definitions
// --------------------------------------------------------------
typedef long df_StreamPos; // Stream position
// --------------------------------------------------------------

// --------------------------------------------------------------
// Constants 
// --------------------------------------------------------------
const unsigned df_MAX_LINE_LENGTH = 1024; // Maximum line length
const unsigned df_MAX_NAME_LENGTH = 255;  // Maximum length of a file name
const unsigned df_MAX_DIR_LENGTH = 1024;  // Maximum length of a directory name
const df_StreamPos df_CurrPosition = -1;  // Indicates current file position

// Maximum number of file error codes defined in the
// gxsFile error codes enumeration. NOTE: This number
// must match the number of error codes in enumeration
// and the df_FILE_ERROR_MESSAGES array.
const unsigned df_MAX_FILE_ERRORS = 19;
// --------------------------------------------------------------

class DiskFileB
{
public: // Enumerations

  enum { // DiskFileB error codes
    df_NO_ERROR = 0,       // No errors reported
    df_INVALID_ERROR_CODE, // Invalid file error code

    // File error exception codes
    df_CLOSE_ERROR,  // Error closing the file
    df_COPY_ERROR,   // Error copying file
    df_CREATE_ERROR, // Could not create the file
    df_EOF_ERROR,    // End of file error
    df_EXIST_ERROR,  // The file does not exist
    df_FLUSH_ERROR,  // Error flushing the disk buffers
    df_MODE_ERROR,   // An invalid access/open mode specified
    df_OPEN_ERROR,   // Could not open the file
    df_READ_ERROR,   // An error occcurred during a read operation
    df_REMOVE_ERROR, // Could remove the specified file
    df_RENAME_ERROR, // Could not rename the specified file
    df_REWIND_ERROR, // Error rewinding the file
    df_SEEK_ERROR,   // An error occurred during a seek operation
    df_WRITE_ERROR,  // An error occurred during a write operation

    // Directory error exception codes
    df_CHDIR_ERROR,  // Could not change directory
    df_MKDIR_ERROR,  // Could not create directory
    df_RMDIR_ERROR   // Could not remove directory
  };

  enum { // DiskFileB access/open mode enumeration
    df_READONLY,   // Open file with read access only
    df_WRITEONLY,  // Open file with write access only
    df_READWRITE,  // Open file with read and write access
    df_CREATE,     // Create the file if it does not exist
    df_NO_CREATE,  // Do not create the file if it does not exist
    df_TRUNCATE,   // Truncate the file  
    df_APPEND,     // Append to the file
    df_SHARE,      // Enable file sharing (DOS and WIN32 only)
    df_EXCLUSIVE   // No file sharing (DOS and WIN32 only)
  };

  enum { // DiskFileB seek modes
    df_SEEK_BEG, // Seek starting from the beginning of the file
    df_SEEK_CUR, // Seek starting from the current location
    df_SEEK_END  // Seek starting from the end of the file
  };

  enum { // DiskFileB I/O operation codes
    df_READ,         // A read was performed
    df_WRITE,        // A write operation was performed
    df_REWIND,       // A rewind operation was performed
    df_NO_OPERATION  // No operation was performed
  };

public:
  DiskFileB();
  DiskFileB(const char *fname, 
	  int mode=DiskFileB::df_READONLY, 
	  int create=DiskFileB::df_NO_CREATE,
	  int truncate=DiskFileB::df_APPEND,
	  int sharing=DiskFileB::df_SHARE);
  virtual ~DiskFileB();

protected: 
  // Elminate the need for reference counting by disallowing
  // coping and assignment. This will ensure that objects can
  // be saftly destroyed because no copies of the object exist.
  DiskFileB(const DiskFileB &ob) { df_Copy(ob); } 
  DiskFileB& operator=(const DiskFileB &ob) { df_Copy(ob); return *this; }
  
public: // Dervied class interface
  virtual int df_Open(const char *fname, 
		      int mode=DiskFileB::df_READONLY, 
		      int create=DiskFileB::df_NO_CREATE, 
		      int truncate=DiskFileB::df_APPEND,
		      int sharing=DiskFileB::df_SHARE,
		      fstream *f=0);
  virtual int df_ReOpen(fstream *f, int mode=DiskFileB::df_READONLY);
  virtual int df_Close();
  virtual int df_Rewind();
  virtual int df_Flush();
  virtual df_StreamPos df_FilePosition(int operation=DiskFileB::df_NO_OPERATION);
  virtual int df_CreateFile(const char *fname);
  virtual int df_GetLine(void *buf, unsigned bytes=df_MAX_LINE_LENGTH);
  virtual int df_Get(char &c);
  virtual int df_Put(const char &c);
  virtual int df_Read(void *buf, unsigned bytes, 
		      df_StreamPos position=df_CurrPosition);
  virtual int df_Write(const void *buf, unsigned bytes, 
		       df_StreamPos position=df_CurrPosition);
  virtual int df_Seek(df_StreamPos position, int seek_mode=df_SEEK_BEG,
		      int operation=df_NO_OPERATION);
  virtual df_StreamPos df_SeekTo(df_StreamPos position,
				 int operation=df_NO_OPERATION);

public: // General purpose file and directory functions
  df_StreamPos df_FileSize(const char *fname);
  int df_Exists(const char *name);
  int df_IsDirectory(const char *dir_name);
  int df_IsFile(const char *fname);
  int df_chdir(const char *dir_name);
  int df_mkdir(const char *dir_name);
  int df_rmdir(const char *dir_name);
  int df_pwd(char *dir, unsigned max_len = df_MAX_DIR_LENGTH);
  void df_MakeDOSPath(char *path);
  int df_HasDriveLetter(const char *dir_name, char &letter);
  void df_MakeUNIXPath(char *path);
  void df_PathSimplify(const char *path, char *new_path, char path_sep = '/'); 
  int df_remove(const char *fname);
  int df_rename(const char *oldname, const char *newname);
  int df_copy(const char *from, const char *to);
  int df_chmod(const char *fname, int pmode);
  int df_GenOutputFileName(const char *current_file, char *out_file, 
			   const char *extension);
  
public: // Error handling functions
  int df_LastError() { return df_last_error; }
  void df_ClearErr() {
    df_fptr->clear(); df_last_error=DiskFileB::df_NO_ERROR;
  }
  char *df_GetFileError(int error_code);
  char *df_GetFileError();
  const char *DiskFileExceptionMessage();
  
public: // File status functions
  int df_LastOperation() { return df_last_operation; }
  int df_EOF() { if(df_fptr->eof() > 0) return 1; return 0; }
  int df_IsOpen() { return df_file_open == 1; }
  int df_ReadOnly() { return df_ready_for_writing != 1; }
  int df_ReadyForReading() { return df_ready_for_reading == 1; }
  int df_ReadyForWriting() { return df_ready_for_writing == 1; }
  int df_IsOK() { return ((df_is_ok == 1) && (df_file_open == 1)); }
  char *df_OpenFileName() { return (char *)df_open_file_name; }
  fstream *df_FileStream() { return df_fptr; }
  df_StreamPos df_FileLength() { return df_file_length; }

public: // Overloaded operators
  int operator!() const { return df_file_open == 0; }
  int operator!() { return df_file_open == 0; }
  operator const int () const { return df_file_open == 1; }
  operator int () { return df_file_open == 1; }

protected: // Internal processing functions
  void df_Copy(const DiskFileB &ob);
  void df_LoadNameBuffer(const char *s);
  void df_ClearNameBuffer();

protected: // fstream objects
  fstream df_iofile; // Default fstream file object
  fstream *df_fptr;  // Pointer to file object used for all I/O operations  

protected: // String members
  char df_open_file_name[df_MAX_NAME_LENGTH]; // Name of the open file 
  
protected: // File status members
  int df_file_exists;       // True if the file exists
  int df_file_open;         // True if the file is open
  int df_is_ok;             // True if the file status is good
  int df_ready_for_reading; // True if the file is ready for reading
  int df_ready_for_writing; // True if the file is ready for writing

protected: // File operation members
  df_StreamPos df_file_length; // File length
  int df_last_error;     // Numerical value representing the last file error
  int df_last_operation; // The last file operation performed
};

#endif // __GX_DISK_FILE_BASE_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
