# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
INCLUDE_PATH = ../../include/
SRC_PATH = ../../src/

# Build dependency rules
# ==============================================================
GXIP32_DEP = $(INCLUDE_PATH)gxip32.h

GXMAC48_DEP = $(INCLUDE_PATH)gxmac48.h

GXSOCKET_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h

GXSPING_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)gxsping.h

GXSUTILS_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)gxsutils.h

PROJECT_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)gxsutils.h $(INCLUDE_PATH)gxsping.h \
	$(INCLUDE_PATH)gxip32.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

gxsocket$(OBJ_EXT):	$(SRC_PATH)gxsocket.cpp $(GXSOCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxsocket.cpp

gxsping$(OBJ_EXT):	$(SRC_PATH)gxsping.cpp $(GXSPING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxsping.cpp

gxsutils$(OBJ_EXT):	$(SRC_PATH)gxsutils.cpp $(GXSUTILS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxsutils.cpp

gxip32$(OBJ_EXT):	$(SRC_PATH)gxip32.cpp $(GXIP32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxip32.cpp

gxmac48$(OBJ_EXT):	$(SRC_PATH)gxmac48.cpp $(GXMAC48_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxmac48.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

# Make the executable
OBJECTS = gxsocket$(OBJ_EXT) gxsping$(OBJ_EXT) gxsutils$(OBJ_EXT) \
	gxip32$(OBJ_EXT) gxmac48$(OBJ_EXT) $(PROJECT)$(OBJ_EXT) 
# ===============================================================
