/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.AboutDialog;
import com.rexbot.game.card.BackgroundPanel;
import com.rexbot.game.card.HelpDialog;
import com.rexbot.game.card.NoticeDialog;
import com.rexbot.game.card.OptionsDialog;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.RegistrationDialog;
import com.rexbot.game.card.SimDisplayPanel;
import com.rexbot.game.card.SimWaitDialog;
import com.rexbot.game.card.SplashWindow;
import com.rexbot.game.ui.UIService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Category;

public class Main
extends JFrame {
    public static Main instance = null;
    public static final String PROGRAM_NAME = "Adaptive Poker v2.0";
    public static final String DEFAULT_BACKGROUND_NAME = "/background.jpg";
    public static final String DEFAULT_BACKGROUND_KEY = "DEFAULT";
    public static final String LOGO_NAME = "/logo.png";
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Main == null ? (class$com$rexbot$game$card$Main = Main.class$("com.rexbot.game.card.Main")) : class$com$rexbot$game$card$Main);
    private SimDisplayPanel simDisplayPanel = new SimDisplayPanel();
    private JMenuItem aboutMenuItem;
    private JMenuItem aiHelpMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JScrollPane gameScrollPane;
    private JMenuItem gameplayMenuItem;
    private JMenu helpMenu;
    private JLabel infoLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JMenuBar menuBar;
    private JMenuItem newGameMenuItem;
    private JMenuItem optionsMenuItem;
    private JMenuItem regMenuItem;
    private JMenuItem runSimMenuItem;
    private JMenuItem stopSimMenuItem;
    static /* synthetic */ Class class$com$rexbot$game$card$Main;

    public Main() {
        URL url = this.getClass().getResource(LOGO_NAME);
        this.setIconImage(new ImageIcon(url).getImage());
        instance = this;
        SplashWindow sd = new SplashWindow(this);
        sd.go();
        BackgroundPanel bgp = new BackgroundPanel();
        this.setContentPane(bgp);
        this.initComponents();
        this.gameScrollPane.getViewport().setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.simDisplayPanel.setVisible(false);
        this.getContentPane().add((Component)this.simDisplayPanel, gridBagConstraints);
        this.setSize(1024, 768);
        this.center();
        this.setTitle(PROGRAM_NAME);
        bgp.loadMainBackground();
        sd.stop();
    }

    public SimDisplayPanel getSimDisplayPanel() {
        return this.simDisplayPanel;
    }

    public void setInfoText(String text, long displayTime) {
        this.infoLabel.setText(text);
    }

    public JLabel getInfoLabel() {
        return this.infoLabel;
    }

    public URL getBackgroundURL() {
        URL url = null;
        try {
            if (Opts.getInstance().getBackground().equals(DEFAULT_BACKGROUND_KEY)) {
                cat.debug("background is default");
                url = this.getClass().getResource(DEFAULT_BACKGROUND_NAME);
            } else {
                cat.debug("background is NOT default: " + Opts.getInstance().getBackground());
                url = new URL("file://" + Opts.getInstance().getBackground());
            }
        }
        catch (MalformedURLException mue) {
            cat.error(mue, mue);
            new NoticeDialog("Error getting background image: " + Opts.getInstance().getBackground() + "  Error is:" + mue, 5000L).show();
        }
        return url;
    }

    public void setBackground() {
    }

    public JScrollPane getGameScrollPane() {
        return this.gameScrollPane;
    }

    public void center() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        Dimension size = this.getSize();
        this.setLocation((screenWidth - size.width) / 2, (screenHeight - size.height) / 2);
    }

    public void enableSim() {
        this.runSimMenuItem.setEnabled(true);
    }

    public void enableNewGame() {
        this.newGameMenuItem.setEnabled(true);
    }

    public void stopSim() {
        UIService.getInstance().fire("StopSim", null);
        this.stopSimMenuItem.setEnabled(false);
        this.runSimMenuItem.setEnabled(true);
        this.newGameMenuItem.setEnabled(true);
    }

    private void initComponents() {
        this.gameScrollPane = new JScrollPane();
        this.infoLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newGameMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.runSimMenuItem = new JMenuItem();
        this.stopSimMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.optionsMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.gameplayMenuItem = new JMenuItem();
        this.aiHelpMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.regMenuItem = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setCursor(new Cursor(0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Main.this.exitForm(evt);
            }
        });
        this.gameScrollPane.setBackground(new Color(255, 0, 0));
        this.gameScrollPane.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.gameScrollPane, gridBagConstraints);
        this.infoLabel.setFont(new Font("SansSerif", 0, 12));
        this.infoLabel.setText("Welcome to Adaptive Poker...");
        this.infoLabel.setBorder(new BevelBorder(1));
        this.infoLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.infoLabel, gridBagConstraints);
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.fileMenu.setFont(new Font("SansSerif", 0, 12));
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.fileMenuActionPerformed(evt);
            }
        });
        this.newGameMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.newGameMenuItem.setMnemonic('n');
        this.newGameMenuItem.setText("New Game");
        this.newGameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.newGameMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newGameMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.runSimMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.runSimMenuItem.setText("Run Simulation");
        this.runSimMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.runSimMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.runSimMenuItem);
        this.stopSimMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.stopSimMenuItem.setText("Stop Simulation");
        this.stopSimMenuItem.setEnabled(false);
        this.stopSimMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.stopSimMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.stopSimMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.optionsMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.optionsMenuItem.setText("Options...");
        this.optionsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.optionsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.optionsMenuItem);
        this.fileMenu.add(this.jSeparator3);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exitMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.helpMenu.setFont(new Font("SansSerif", 0, 12));
        this.gameplayMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.gameplayMenuItem.setText("Game Play");
        this.gameplayMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.gameplayMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.gameplayMenuItem);
        this.aiHelpMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.aiHelpMenuItem.setText("AI Tuning");
        this.aiHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.aiHelpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aiHelpMenuItem);
        this.helpMenu.add(this.jSeparator4);
        this.regMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.regMenuItem.setText("Registration");
        this.regMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.regMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.regMenuItem);
        this.helpMenu.add(this.jSeparator5);
        this.aboutMenuItem.setFont(new Font("SansSerif", 0, 12));
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void regMenuItemActionPerformed(ActionEvent evt) {
        new RegistrationDialog((Frame)this, true).show();
    }

    private void aiHelpMenuItemActionPerformed(ActionEvent evt) {
        try {
            new HelpDialog((Frame)this, true, (class$com$rexbot$game$card$Main == null ? (class$com$rexbot$game$card$Main = Main.class$("com.rexbot.game.card.Main")) : class$com$rexbot$game$card$Main).getResource("/AI_Howto.html")).show();
        }
        catch (IOException ioe) {
            cat.error(ioe, ioe);
            new NoticeDialog("Error displaying help: " + ioe, 5000L).show();
        }
    }

    private void gameplayMenuItemActionPerformed(ActionEvent evt) {
        try {
            new HelpDialog((Frame)this, true, (class$com$rexbot$game$card$Main == null ? (class$com$rexbot$game$card$Main = Main.class$("com.rexbot.game.card.Main")) : class$com$rexbot$game$card$Main).getResource("/Gameplay_Howto.html")).show();
        }
        catch (IOException ioe) {
            cat.error(ioe, ioe);
            new NoticeDialog("Error displaying help: " + ioe, 5000L).show();
        }
    }

    private void optionsMenuItemActionPerformed(ActionEvent evt) {
        new OptionsDialog((Frame)this, true).show();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true).show();
    }

    private void newGameMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (!Opts.getInstance().isRegistered()) {
                new HelpDialog((Frame)this, true, (class$com$rexbot$game$card$Main == null ? (class$com$rexbot$game$card$Main = Main.class$("com.rexbot.game.card.Main")) : class$com$rexbot$game$card$Main).getResource("/Nag.html")).show();
            }
        }
        catch (IOException ioe) {
            cat.error(ioe, ioe);
            new NoticeDialog("Error displaying registration dialog: " + ioe, 5000L).show();
        }
        UIService.getInstance().fire("NewGame", this);
        this.runSimMenuItem.setEnabled(false);
        this.newGameMenuItem.setEnabled(false);
    }

    private void stopSimMenuItemActionPerformed(ActionEvent evt) {
        UIService.getInstance().fire("StopSim", null);
        this.stopSimMenuItem.setEnabled(false);
        this.runSimMenuItem.setEnabled(true);
        this.newGameMenuItem.setEnabled(true);
    }

    private void runSimMenuItemActionPerformed(ActionEvent evt) {
        UIService.getInstance().fire("RunSim", this);
        this.stopSimMenuItem.setEnabled(true);
        this.runSimMenuItem.setEnabled(false);
        this.newGameMenuItem.setEnabled(false);
        new SimWaitDialog((Frame)this, true).show();
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        UIService.getInstance().fire("Exit", null);
    }

    private void exitForm(WindowEvent evt) {
        UIService.getInstance().fire("Exit", null);
    }

    public static void main(String[] args) throws Exception {
        cat.info("Starting Game");
        Main main = new Main();
        main.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

