<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Create New Purchase Order</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[

function setTab(focusItem) {
    focusItem.focus();
}

function loadPrint(PO,PONum) {
  items = PONum*1 + 1;
  var features = "scrollbars=yes,resizable=yes,menubar=yes";
  var newlink = "/msi/servlet/MSIServlet?disValue=1294&REPORT=MSIClasses.reports.POReport&FORWARDPARAMS=1&PONUMBER=" + PO; 
  
  var newLayer = open(newlink,"PO",features);
  
  newLayer.focus();
}

function loadPrintNew(PO,PONum, FrameURL) {
  items = PONum*1 + 1;
  var features = "scrollbars=yes,resizable=yes,menubar=yes";
  var newlink = "/msi/servlet/MSIServlet?disValue=792&print" + PONum +"=yes&po" + PONum + "=" + PO + "&TOTALITEMS=" + items; 
  /* var newLayer = open(newlink,"PO",features); */
  var fullURL = FrameURL.value + "/debug/new/XSLDir/IE5/ENGLISH/ReportFrameNew.xsl";
  alert(fullURL);
  var printFrame= open(FrameURL, "ReportFrame", features);
  
  //printFrame.focus();
}

function deleteConfirm() {
      var result = confirm("Are you sure you want to DELETE the selected purchase orders?");
		
		if(result)
		{	
			FORM1.DELETE.value='true';
			FORM1.submit();
			return true;
		}	
      else
		{
			return false;
		}
}

]]>
</xsl:comment>
</SCRIPT>

<BODY onLoad="setTab(BIGFORM.SUPPLIER)">


<CENTER><H1>Work Order for <xsl:value-of select="MSI/displayOrders/CUSTOMER_NAME"/> on 
<xsl:value-of select="MSI/displayOrders/ORDER_DATE"/></H1></CENTER><P></P>

<P></P>

<FORM NAME="BIGFORM" METHOD="POST">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>



<INPUT TYPE="HIDDEN" NAME="recipient" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="subject" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="redirect" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="786"></INPUT>



<INPUT TYPE="HIDDEN" NAME="customer">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/CUSTOMER_NAME"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN" NAME="customerID">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/CUSTOMER_ID"/></xsl:attribute>
</INPUT>


<INPUT TYPE="HIDDEN" NAME="Date">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/ORDER_DATE"/></xsl:attribute>
</INPUT>




<TABLE CELLPADDING="2" WIDTH="100%">
<TR><TD WIDTH="30%" VALIGN="TOP">Select Supplier</TD><TD WIDTH="30%" VALIGN="TOP"><SELECT NAME="SUPPLIER">

<xsl:for-each select="MSI/displayOrders/SUPPLIERLIST/SupplierTable">
<xsl:sort select="supplier_name" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE">
	<xsl:value-of select="supplier_id"/>~<xsl:value-of select="c"/>~<xsl:value-of select="supplier_name"/>
	</xsl:attribute>
	      <xsl:value-of select="supplier_name"/>
</OPTION>
</xsl:for-each>
</SELECT></TD>
<TD>Total Orders</TD><TD>$<xsl:value-of select="format-number(sum(MSI/displayOrders/POINFO/POInfoTable/i11), '###,##0.00')"/></TD>
</TR>

<INPUT TYPE="HIDDEN" NAME="OURPO">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/NEXT_PO"/></xsl:attribute>
</INPUT>

<TR><TD WIDTH="30%" VALIGN="TOP">Enter PO Number</TD><TD WIDTH="30%" VALIGN="TOP">
<INPUT NAME="PO" SIZE="10">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/NEXT_PO"/></xsl:attribute>
</INPUT></TD>
<TD>Total Commission</TD><TD>$<xsl:value-of select ="format-number(sum(MSI/displayOrders/POINFO/POInfoTable/i15) * MSI/displayOrders/POINFO/POInfoTable/c2, '###,##0.00')"/></TD>
</TR>

<TR><TD WIDTH="30%" VALIGN="TOP">Ship Date</TD><TD WIDTH="30%" VALIGN="TOP">
<INPUT NAME="SHIPDATE" SIZE="10" VALUE="ASAP" MAXLENGTH="20"></INPUT></TD>
<TD>Total Commission (pre)</TD><TD>$<xsl:value-of select ="format-number(sum(MSI/displayOrders/POINFO/POInfoTable/i15), '###,##0.00')"/></TD>
</TR>

<TR><TD WIDTH="30%" VALIGN="TOP">Cancel Date</TD><TD WIDTH="30%" VALIGN="TOP">
<INPUT NAME="CANCELDATE" SIZE="10" VALUE="" MAXLENGTH="20"></INPUT></TD>
</TR>

<TR><TD WIDTH="30%" VALIGN="TOP">Terms</TD><TD WIDTH="30%" VALIGN="TOP">
<INPUT NAME="TERMS" SIZE="10" VALUE="" MAXLENGTH="50"></INPUT></TD>
</TR>

<TR><TD WIDTH="30%" VALIGN="TOP">Instructions</TD><TD WIDTH="30%" VALIGN="TOP">
<INPUT NAME="INSTRUCTIONS" SIZE="20" VALUE="" MAXLENGTH="50"></INPUT></TD>
</TR>

<TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" VALUE="Create New PO"></INPUT></TD>


</TR></TABLE></FORM><P></P>



<FORM METHOD="POST" NAME="FORM1">
<INPUT TYPE="HIDDEN" NAME="frameURL"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/></xsl:attribute></INPUT>
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<xsl:choose>
<xsl:when test="MSI/displayOrders/POINFO/POInfoTable[.!='']">
    <xsl:choose>
    <xsl:when test="MSI/disableSend[.!='1']">
    <INPUT TYPE="SUBMIT" NAME="SEND" VALUE="Send PO's"></INPUT>
    </xsl:when></xsl:choose>
<INPUT TYPE="BUTTON" NAME="DELETEBUTTON" VALUE="Delete PO's" onClick="deleteConfirm()"></INPUT>
<INPUT TYPE="HIDDEN" NAME="DELETE" VALUE="FALSE"></INPUT>
<TABLE CELLSPACING="2">
	
		<TR>
			<TH> </TH>
			<TH> </TH>
			<TH>PO Number</TH>
			<TH>Supplier</TH>
			<TH>Status</TH>
			<TH>Commission</TH>
			<TH>Order Value</TH>
			<TH></TH>

		</TR>
		<xsl:for-each select="MSI/displayOrders/POINFO/POInfoTable">
        <xsl:sort select="i0" data-type="text" order="ascending"/>
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			

				<TD><INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i0"/></xsl:attribute>
				     </INPUT></TD>
				<TD><INPUT TYPE="SUBMIT" VALUE="Edit PO">
					<xsl:attribute name="NAME">edit<xsl:value-of select="c1"/></xsl:attribute>
				</INPUT></TD>
				
				<TD>
				<xsl:choose>
				<xsl:when test="i13[.!='']">
					<xsl:value-of select="i13"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="i0"/>
				</xsl:otherwise>
				</xsl:choose>
				</TD>
	
				<TD><xsl:value-of select="i10"/></TD>
				<TD>Entered</TD>
				<TD ALIGN="RIGHT">$<xsl:value-of select="format-number(i15 * c2, '###,##0.00')"/></TD>
				<TD ALIGN="RIGHT">$<xsl:value-of select="format-number(i11, '###,##0.00')"/></TD>
				
				<TD><BUTTON VALUE="" NAME="PrintButton">
					<!--xsl:attribute name="onClick">loadPrintNew("<xsl:value-of select="i0"/>","<xsl:value-of select="c1"/>", frameURl); -->
					<xsl:attribute name="onClick">loadPrint("<xsl:value-of select="i0"/>","<xsl:value-of select="c1"/>");					 
					</xsl:attribute>
					Print PO
				</BUTTON></TD>

				
				<INPUT TYPE="hidden">
					<xsl:attribute name="NAME">po<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i0"/></xsl:attribute>
				</INPUT>

				<INPUT TYPE="hidden">
					<xsl:attribute name="NAME">con<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="c"/></xsl:attribute>
				</INPUT>

	
			</TR>
		</xsl:for-each>


<INPUT type="hidden" name="disValue" value="792"></INPUT>
<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/POINFO/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="COMPANYID"><xsl:attribute name="VALUE"><xsl:value-of select="CACHEINFO/SUPPLIERID"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="COMPANYNAME"><xsl:attribute name="VALUE"><xsl:value-of select="CACHEINFO/SUPPLIERNAME"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="CUSTOMERID"><xsl:attribute name="VALUE"><xsl:value-of select="CACHEINFO/CUSTOMERID"/></xsl:attribute></INPUT>
<INPUT TYPE="HIDDEN" NAME="DATE"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/ORDER_DATE"/></xsl:attribute></INPUT>
<INPUT TYPE="HIDDEN" NAME="customer"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/displayOrders/CUSTOMER_ID"/>~<xsl:value-of select="MSI/displayOrders/CUSTOMER_NAME"/></xsl:attribute></INPUT>


</TABLE>

</xsl:when>
</xsl:choose>


</FORM>


</BODY></HTML>
</xsl:template>


</xsl:stylesheet>
