<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">

<HTML>

<HEAD>
	<TITLE>Reports Query</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function doClose()
{
    window.parent.frames['REPORT'].close();
    window.close();
    window.parent.close();
}

function doPrint()
{
    window.parent.REPORT.focus();
    window.parent.REPORT.print();
}


function doQuery()
{
	 window.parent.REPORT.focus();
    submit();
}


function doEmail()
{
    /*var fullurl = url.value + disValue + "&Month=" + month.options[month.selectedIndex].value + "&Year=" + year.value + "&MonthName=" + month.options[month.selectedIndex].text;*/
    /*window.parent.doEmail();
    var test = "disValue: " + window.parent.REPORT.FORM1.disValue.value;*/
    var dis = window.parent.REPORT.FORM1.disValue.value;
    var dis = window.parent.FORM1.disValue.value;
}    


function doSearch()
{
    var customer = "CUSTOMER=" + QUERY.CUSTOMER.value;
	 var rep = "REP=" + QUERY.REP.value;
	 var supplier = "SUPPLIER=" + QUERY.SUPPLIER.value;
	 var area = "AREA=" + QUERY.AREA.value;
	 var begindate = "BEGINDATE=" + QUERY.BEGINDATE.value;
	 var enddate = "ENDDATE=" + QUERY.ENDDATE.value;
	 var reportinstance = "REPORTINSTANCE=" + QUERY.REPORTINSTANCE.value;
	 var disvalue = "disValue=" + QUERY.disValue.value;	 

	 var url = "/msi/servlet/MSIServlet" + "?" + 
					disvalue + "&" + 
					reportinstance + "&" + 
					enddate + "&" + 
					begindate + "&" + 
					area + "&" + 
					supplier + "&" + 
					rep + "&" + 
					customer; 
						 
	 window.parent.REPORT.open(url,"REPORT");
}    


]]>
</xsl:comment>
</SCRIPT>



<BODY>

<FORM NAME="QUERY">

<TABLE>
<TR>
	 <xsl:choose>
	 <xsl:when test="MSI/REPLIST/REP[.!='']">
	<TH>Select Rep</TH>
	 </xsl:when>
	 </xsl:choose>			
	
	
	<xsl:choose>
	<xsl:when test="MSI/SUPLIST/SUP[.!='']">
	<TH>Select Supplier</TH>
	 </xsl:when>
	 </xsl:choose>			
	
	
	 <xsl:choose>
	 <xsl:when test="MSI/CUSTLIST/CUST[.!='']">
  	<TH>Select Customer</TH>
	 </xsl:when>
	 </xsl:choose>			

</TR>

<TR>

<xsl:choose>
<xsl:when test="MSI/REPLIST/REP[.!='']">

<TD> 
<SELECT NAME="REP">

<OPTION VALUE="all">
Search All Reps 
</OPTION>

<xsl:for-each select="MSI/REPLIST/REP">
<xsl:sort select="FIRSTNAME" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="USERID"/></xsl:attribute><xsl:value-of select="FIRSTNAME"/><xsl:text> </xsl:text><xsl:value-of select="LASTNAME"/>
</OPTION>
</xsl:for-each>
</SELECT>


</TD>
</xsl:when>
<xsl:otherwise>
<INPUT TYPE="HIDDEN" NAME="REP" VALUE="NONE"/>
</xsl:otherwise>
</xsl:choose>			



<xsl:choose>
<xsl:when test="MSI/SUPPLIERLIST/SupplierTable[.!='']">

<TD> 
<SELECT NAME="SUPPLIER">

<OPTION VALUE="all">
Search All Suppliers 
</OPTION>

<xsl:for-each select="MSI/SUPPLIERLIST/SupplierTable">
<xsl:sort select="supplier_name" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="c"/>~<xsl:value-of select="supplier_id"/>~<xsl:value-of select="supplier_name"/></xsl:attribute><xsl:value-of select="supplier_name"/>
</OPTION>
</xsl:for-each>
</SELECT>
</TD>

</xsl:when>

<xsl:otherwise>
<INPUT TYPE="HIDDEN" NAME="SUPPLIER" VALUE="NONE"/>
</xsl:otherwise>
</xsl:choose>			


<xsl:choose>
<xsl:when test="MSI/CUSTOMERLIST/CompanyTable[.!='']">

<TD> 
<SELECT NAME="CUSTOMER">

<OPTION VALUE="all">
Search All Customers 
</OPTION>

<xsl:for-each select="MSI/CUSTOMERLIST/CompanyTable">
<xsl:sort select="company_name" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="company_name"/></xsl:attribute><xsl:value-of select="company_name"/>
</OPTION>
</xsl:for-each>
</SELECT>
</TD>

</xsl:when>
<xsl:otherwise>
<INPUT TYPE="HIDDEN" NAME="CUSTOMER" VALUE="NONE"/>
</xsl:otherwise>
</xsl:choose>			



</TR>

<TR>
	
    
	<xsl:choose>
	<xsl:when test="MSI/BEGINDATE[.!='']">
        <TH>Select Begin Date</TH>
	</xsl:when>
	</xsl:choose>			
	
	<xsl:choose>
	<xsl:when test="MSI/ENDDATE[.!='']">
        <TH>Select End Date</TH>
	</xsl:when>
	</xsl:choose>			
	

	<xsl:choose>
	<xsl:when test="MSI/AREALIST/AREA[.!='']">
		<TH>Select Area</TH>
	</xsl:when>
	</xsl:choose>			

</TR>

<TR>
	
    <xsl:choose>
	<xsl:when test="MSI/BEGINDATE[.!='']">
        <TD ALIGN="CENTER">
    	<INPUT NAME="BEGINDATE" SIZE="10">
    		<xsl:attribute name="VALUE"><xsl:value-of select="MSI/BEGINDATE"/></xsl:attribute>    
    	</INPUT>
    	</TD>	
    </xsl:when>
    <xsl:otherwise>
    <INPUT TYPE="HIDDEN" NAME="BEGINDATE" VALUE=""/>
    </xsl:otherwise>
    </xsl:choose>			
   
 
    
    <xsl:choose>
	<xsl:when test="MSI/ENDDATE[.!='']">
    	<TD ALIGN="CENTER">
    	<INPUT NAME="ENDDATE" SIZE="10">
    		<xsl:attribute name="VALUE"><xsl:value-of select="MSI/ENDDATE"/></xsl:attribute>    
    	</INPUT>
    	</TD>	
    </xsl:when>
    <xsl:otherwise>
    <INPUT TYPE="HIDDEN" NAME="ENDDATE" VALUE=""/>
    </xsl:otherwise>
    </xsl:choose>			
 
<xsl:choose>
<xsl:when test="MSI/AREALIST/AREA[.!='']">

	<TD> 
	<SELECT NAME="AREA">
	
	<OPTION VALUE="all">
	Search All Areas 
	</OPTION>
	
	<xsl:for-each select="MSI/AREALIST/AREA">
	<xsl:sort select="AREANAME" data-type="text" order="ascending"/>
	
	<OPTION> 
		<xsl:attribute name="VALUE"><xsl:value-of select="AREAID"/></xsl:attribute><xsl:value-of select="AREANAME"/>
	</OPTION>
	</xsl:for-each>
	</SELECT>
	</TD>
</xsl:when>
<xsl:otherwise>
<INPUT TYPE="HIDDEN" NAME="AREA" VALUE="NONE"/>
</xsl:otherwise>

</xsl:choose>


</TR>


<TR>
<TD>
<BUTTON NAME="DOQUERY" onClick="doSearch();">Run Report</BUTTON>
</TD>

<TD>
<BUTTON onClick="doPrint();">Print</BUTTON>
</TD>

</TR>

</TABLE>


<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="1295" ></INPUT>
<INPUT TYPE="HIDDEN" NAME="REPORTINSTANCE">
  	<xsl:attribute name="VALUE"><xsl:value-of select="MSI/REPORTINSTANCE"/></xsl:attribute>    
 </INPUT>

</FORM>


</BODY>

</HTML>
</xsl:template></xsl:stylesheet>
