/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.catalina.Container;
import org.apache.tomcat.catalina.Manager;
import org.apache.tomcat.catalina.Session;
import org.apache.tomcat.session.StandardSession;
import org.apache.tomcat.util.SessionUtil;

public abstract class ManagerBase
implements Manager {
    protected Container container;
    protected boolean distributable;
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected Vector recycled = new Vector();
    protected Hashtable sessions = new Hashtable();

    void add(StandardSession session) {
        this.sessions.put(session.getId(), session);
    }

    public Session createSession() {
        StandardSession session = null;
        Vector vector = this.recycled;
        synchronized (vector) {
            int size = this.recycled.size();
            if (size > 0) {
                session = (StandardSession)this.recycled.elementAt(size - 1);
                this.recycled.removeElementAt(size - 1);
            }
        }
        if (session == null) {
            session = new StandardSession(this);
        }
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        session.setId(SessionUtil.generateSessionId());
        return session;
    }

    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return (Session)this.sessions.get(id);
    }

    public Session[] findSessions() {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Vector<String> keys = new Vector<String>();
            Enumeration ids = this.sessions.keys();
            while (ids.hasMoreElements()) {
                String id = (String)ids.nextElement();
                keys.addElement(id);
            }
            Session[] results = new Session[keys.size()];
            int i = 0;
            while (i < results.length) {
                String key = (String)keys.elementAt(i);
                results[i] = (Session)this.sessions.get(key);
                ++i;
            }
            Session[] sessionArray = results;
            Object var3_8 = null;
            return sessionArray;
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public String getInfo() {
        return info;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    void recycle(StandardSession session) {
        this.recycled.addElement(session);
    }

    void remove(StandardSession session) {
        this.sessions.remove(session.getId());
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }
}

