/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      :                                                           */
/* Description  : headers for some commonly used PC Picture File Formats    */
/*                and function prototypes for related library functions     */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */
#ifndef _PIXHDR_H_

#define _PIXHDR_H_

/* microsoft compatible bsaved memory image format structure*/
typedef struct{
    char signature;
    unsigned int loadsegment;
    unsigned int loadoffset;
    unsigned int loadlength;
}BSVHEADER;

/* pcx file format header structure */
/* 128 byte header... note: pack structure on byte boundaries */
typedef struct{
    unsigned char zsoft;
    unsigned char version;
    unsigned char codetype;
    unsigned char pixbits;
    unsigned int  xmin,ymin;
    unsigned int  xmax,ymax;
    unsigned int  hres,vres;
    unsigned char egapalette[3][16];
    unsigned char reserved;
    unsigned char no_planes;
    unsigned int  bytes_per_line;
    unsigned int  pal_type;
    unsigned char unused[58];
}PCXHEADER;


/* Windows Bitmap Header structures */
typedef struct
{
    unsigned char    rgbBlue;
    unsigned char    rgbGreen;
    unsigned char    rgbRed;
    unsigned char    rgbReserved;
} RGBQUAD;

typedef struct
{
    unsigned long   biSize;
    unsigned long   biWidth;
    unsigned long   biHeight;
    unsigned        biPlanes;
    unsigned        biBitCount;
    unsigned long   biCompression;
    unsigned long   biSizeImage;
    unsigned long   biXPelsPerMeter;
    unsigned long   biYPelsPerMeter;
    unsigned long   biClrUsed;
    unsigned long   biClrImportant;
} BITMAPINFOHEADER;

/* constants for the biCompression field */
#define BI_RGB      0L
#define BI_RLE8     1L
#define BI_RLE4     2L

typedef struct
{
    BITMAPINFOHEADER bmiHeader;
    RGBQUAD          bmiColors[256];
} BITMAPINFO;


typedef struct
{
    char            bfType[2];
    unsigned long   bfSize;
    unsigned        bfReserved1;
    unsigned        bfReserved2;
    unsigned long   bfOffBits;
} BITMAPFILEHEADER;


/* function prototypes go here */

#ifndef _CHKBMP_C_
int checkbmpheader(BITMAPINFO *, BITMAPFILEHEADER *, unsigned, unsigned char);

#endif

#endif /* last line in file */
