#include <windows.h>
#include <stdio.h>

#define SHOW( X )	OutputDebugString(X ##"\r")


// Typedefine the call to 'MessageBoxA'
typedef int	(*MESSAGEBOX)(HWND,LPCTSTR,LPCTSTR,UINT);

MESSAGEBOX	pfnMessageBox = NULL;
HMODULE		hUser	= NULL;

main()
{
	HMODULE	hMod;
	CHAR	ch;


	// ----------------------------------------------------
	// Attempt to load 'user32.dll'
	// ----------------------------------------------------
	hUser = LoadLibrary("user32.dll");
	if(!hUser)
	{
		SHOW("Failed to load user32.dll");
		return FALSE;
	}


	// ----------------------------------------------------
	// Attempt to load 'thedll.dll' which replaces MessageBoxA
	// ----------------------------------------------------
	hMod = LoadLibrary("thedll.dll");
	if(hMod)
	{
		// ----------------------------------------------------
		// Get 'MessageBoxA' Function
		// ----------------------------------------------------
		pfnMessageBox=(MESSAGEBOX)GetProcAddress(hUser, "MessageBoxA");
		if(!pfnMessageBox)
		{
			SHOW("Failed in call to GetProcAddress");
			return FALSE;
		}

		// ----------------------------------------------------
		// Now Demonstrate the intercepted 'MessageBoxA' API
		// The caption will be changed
		// ----------------------------------------------------
		(pfnMessageBox)(NULL,"Calling from the application","Messagebox Caption",MB_OK);
		FreeLibrary(hMod);
	}	
	else
	{
		puts("TheExe - Failed to load the test dll");
	}

	FreeLibrary(hUser);
	return TRUE;
}
