/*
 * Class for an owner-draw button.  From the "Borland C++ 4.0 Object
 * Oreinted Programming" book.
 */

#include <owl\gdiobject.h>
#include <owl\control.h>
#include "button.h"

od_button::od_button(TWindow *parent, int id, char* normal, char* pressed, char* focused)
	: TControl(parent, id)
{
	bm_normal = new TBitmap(*GetModule(), normal);
	bm_pressed = new TBitmap(*GetModule(), pressed);
	bm_focused = new TBitmap(*GetModule(), focused);
}

od_button::~od_button()
{
	delete bm_normal;
	delete bm_pressed;
	delete bm_focused;
}

void
od_button::ODADrawEntire(DRAWITEMSTRUCT far& info)
{
	draw_normal(info);
}

void
od_button::ODASelect(DRAWITEMSTRUCT far& info)
{
	if (info.itemState & ODS_SELECTED)
		draw_pressed(info);
	else
		draw_focused(info);
}

void
od_button::ODAFocus(DRAWITEMSTRUCT far& info)
{
	if (info.itemState & ODS_FOCUS)
		draw_focused(info);
	else
		draw_normal(info);
}

void
od_button::draw_normal(DRAWITEMSTRUCT far& info)
{
	draw_button(info, bm_normal);
}

void
od_button::draw_pressed(DRAWITEMSTRUCT far& info)
{
	draw_button(info, bm_pressed);
}

void
od_button::draw_focused(DRAWITEMSTRUCT far& info)
{
	draw_button(info, bm_focused);
}

void
od_button::draw_button(DRAWITEMSTRUCT far& info, TBitmap* bm)
{
	int x = info.rcItem.left;
	int y = info.rcItem.top;
	int width = info.rcItem.right - info.rcItem.left;
	int height = info.rcItem.bottom - info.rcItem.top;

	TDC dc(info.hDC);
	TMemoryDC memDC(dc);
	memDC.SelectObject(*bm);
	dc.StretchBlt(x, y, width, height, memDC, 0, 0, bm->Width(), bm->Height());
}

