#include <stdio.h>
#include <stdlib.h>
#include <io.h>

/* makewpg - combine encapsulated postscript file and tif preview file.
	Args are postscript file name, tif file name, output file name.

	Written by Robert W. Babcock.  Last revison 10/12/93.

	Funding for this work was provided by various NASA and Smithsonian grants.
	It is not subject to copyright.

	The format for the header of a WPG file consisting of a postscript file and
	a TIF preview image was discovered by examining examples produced by GLE.
	There are several fields which I don't know the meaning of, but they seem
	to be constant.
 */

void usage(void);

int main(int argc, char **argv)
	{
	FILE *fp_ps, *fp_tif, *fp_output;
	long header[7] = {0xc6d3d0c5UL, 0x1e, 0, 0, 0, 0, 0x1414};
	long i, length;
	int handle, tc;

	if(4 != argc)
		usage();

	if(NULL == (fp_ps = fopen(argv[1], "rb")))
		{
		fprintf(stderr, "Error, can't open postscript file %s\n", argv[1]);
		exit(1);
		}
	if(NULL == (fp_tif = fopen(argv[2], "rb")))
		{
		fprintf(stderr, "Error, can't open tif file %s\n", argv[2]);
		exit(1);
		}
	if(NULL == (fp_output = fopen(argv[3], "wb")))
		{
		fprintf(stderr, "Error, can't open output file %s\n", argv[3]);
		exit(1);
		}
	handle = fileno(fp_ps);
	length = filelength(handle);
	header[2] = length;
	header[5] = length + 30;
	fwrite(header, 28, 1, fp_output);
	fputc(0xff, fp_output);
	fputc(0xff, fp_output);
	for(i=0; i<length; i++)
		{
		tc = fgetc(fp_ps);
		if(-1 == fputc(tc, fp_output))
			{
			fprintf(stderr, "Error writing postscript section of output file\n");
			exit(1);
			}
		}
	fclose(fp_ps);
	handle = fileno(fp_tif);
	length = filelength(handle);
	for(i=0; i<length; i++)
		{
		tc = fgetc(fp_tif);
		if(-1 == fputc(tc, fp_output))
			{
			fprintf(stderr, "Error writing tif section of output file\n");
			exit(1);
			}
		}
	return(0);
	}

void usage(void)
	{
	fprintf(stderr, "usage: makewpg  EPS_file  TIF_file  WPG_file\n");
	exit(1);
	}
