/*
 *   This file is a part of uuhydra, a replacment for Waffle's uucico
 *
 *   Copyright (C) 1993  Erik Bos (erik@trashcan.hacktic.nl)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define	S_RXCHARS	0x0100		/* Characters in input buffer */
#define	S_RXOVERRUN	0x0200		/* Receive buffer overrun */
#define	S_TXCHARS	0x2000		/* Transmit buffer not full */
#define	S_TXEMPTY	0x4000		/* Transmit buffer is empty */
#define	S_CARRIER	0x0080		/* Carrier detect is high */

#define	B300		0x0040		/*    300 baud */
#define	B600		0x0060		/*    600 baud */
#define	B1200		0x0080		/*   1200 baud */
#define	B2400		0x00a0		/*   2400 baud */
#define	B4800		0x00c0		/*   4800 baud */
#define	B9600		0x00e0		/*   9600 baud */
#define	B19200		0x0000		/*  19200 baud */
#define	B38400		0x0020		/*  38400 baud */

#define	PNONE		0x0000		/* No parity */
#define	PSPACE		0x0010		/* Space/mark parity */
#define	PODD		0x0008		/* Odd parity */
#define	PEVEN		0x0018		/* Even parity */

#define	S1		0x0000		/* 1 stop bit */
#define	S2		0x0004		/* 2 stop bits */

#define	D6		0x0001		/* 6 data bits */
#define	D7		0x0002		/* 7 data bits */
#define	D8		0x0003		/* 8 data bits */

#define	DTR_READY	0x0001
#define	DTR_NOT_READY	0x0000

/* Flow Control flags */

#define	FC_XONXOFF	0x0001		/* Enables local Xon/Xoff */
#define	FC_CTSRTS	0x0002		/* Enables local CTS/RTS */
#define	FC_REMOTE	0x0008		/* Enables remove Xon/Xoff */

#define	carrier(p)	(AsyncGetPortStatus(p)&S_CARRIER)

extern int  		AsyncInitPort(int);
extern void 		AsyncDeInitPort(int);
extern void 		AsyncSetDTR(int,char);
extern unsigned int	AsyncSetBaudRate(int, unsigned char);
extern unsigned int	AsyncGetPortStatus(int);
extern void 		AsyncTxFlush(int);
extern void 		AsyncRxPurge(int);
extern void		AsyncTxPurge(int);
extern void		AsyncSetFlowCtl(int, unsigned char);
extern int 		AsyncKbPeek(void);
extern unsigned int	AsyncGetKbChar(void);
extern void		AsyncSetBreak(int,char);
extern int		AsyncTxChar(int,unsigned char);
extern unsigned char 	AsyncRxChar(int);
extern void 		AsyncTxBlock(int,char,unsigned int);
