/*===========================================================================
SOLAR slrreply :: Module ..\slrreply\news.c
Original Author : Kevin Houle <kjhoule@iowegia.des-moines.ia.us>

This source code has been placed into the public domain.
===========================================================================*/

/* Header files */
#include <stdio.h>
#include <process.h>
#include <string.h>
#include <time.h>
#include <dir.h>
#include <stdlib.h>
#include "news.h"

/*
 * Function: feed_news()
 * Purpose : Feed message to news program.
 * Return  : 0 on success, non-zero on error.
*/

int feed_news()
{
  char full_path[MAXPATH];

  strcpy(full_path,temp_path);
  strcat(full_path,"\\");
  strcat(full_path,REPLY_TMP);

  if (verbose == YES)
    RPrintf("Calling: %s %s\n",news_program,full_path);

  if (diskswap == YES)
  {
    if (verbose == YES)
      RPrintf("Initializing swap to %s\n",swap_path);
    init_SPAWNO(swap_path,SWAP_DISK);
  }

  return(spawnlp(P_WAIT,news_program,news_program,full_path,NULL));
}

