/*===========================================================================
SOLAR v0.95.3 slrcmd :: Module ..\slrcmd\slrcmd.h
Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>

This source code module has been placed in the public domain.
===========================================================================*/

/* Common Includes */

#include "..\common\version.h"
#include "..\common\yesno.h"
#include "..\common\soup.h"
#include "..\common\exitcode.h"

/* Static Data Definitions */

#define COMMANDS_NAME      "COMMANDS"
#define ONCE                        2

/* External Global Data */

extern int  verbose;
extern char _slrerr[80];
extern char user_path[MAXPATH];                   /* From config.c  */
extern char temp_path[MAXPATH];                   /* From config.c  */
extern char config_path[MAXPATH];                 /* From config.c  */
extern char log_path[MAXPATH];                    /* From config.c  */
extern char swap_path[MAXPATH];                   /* From config.c  */
extern char newsgroups_path[MAXPATH];             /* From config.c  */
extern int  diskswap;                             /* From config.c  */
extern int  news_type;                            /* From config.c  */
extern long news_area_bytes;                      /* From config.c  */
extern long news_area_messages;                   /* From config.c  */
extern long news_total_bytes;                     /* From config.c  */
extern long news_total_messages;                  /* From config.c  */

extern char area_name[80];                        /* From newsrc.c  */
extern char keyword;                              /* From newsrc.c  */
extern long index_high;                           /* From newsrc.c  */
extern long msg_high;                             /* From newsrc.c  */
extern int  send_list;                            /* From config.c  */
extern int  send_mail;                            /* From config.c  */
extern int  delete_mail;                          /* From config.c  */
extern int  news_index;                           /* From config.c  */
extern int  mail_type;                            /* From config.c  */
extern char compress[10];                         /* From config.c  */
extern char protocol[10];                         /* From config.c  */
extern char uucpname[15];                         /* From config.c  */
extern char default_keyword;                      /* From config.c  */
extern char logbuf[128];                          /* From config.c  */

/* Local Global Data */

char speed[6];

/* External Global Functions */

extern int  load_static(char username[10]);       /* From config.c  */
extern int  load_config();                        /* From config.c  */
extern int  user_defaults();                      /* From config.c  */
extern int  read_doors();                         /* From doors.c   */
extern int  subscribe(char *area);                /* From newsrc.c  */
extern int  unsubscribe(char *area);              /* From newsrc.c  */
extern int  set_send_list(char *token);           /* From options.c */
extern int  set_send_mail(char *token);           /* From options.c */
extern int  set_delete_mail(char *token);         /* From options.c */
extern int  set_news_index(char *token);          /* From options.c */
extern int  set_mail_type(char *token);           /* From options.c */

/* External Common Functions */

extern int  getopt(int argc, char *argv[], const char *optionS);
extern char *extract_parm(char string[128], char delimiter);
extern int  compress_packet();
extern int  logit(const char *facility);          /* From logit.c   */

/* Local Global Functions */

FILE *open_commands_file();
void usage();
