	TITLE	seterr
;-------------------------------------------------------------------------------
; SETERR.ASM  version 1.1
; by Duane Paulson 03/17/91.
;
; MASM 5.1
;
; PURPOSE: Batch file enhancer.
;
; OUTPUT: DOS errorlevel set to a value between 0 - 255 inclusive.
; INPUT: Command line parameter 0 - 255 inclusive.
;-------------------------------------------------------------------------------

	DOSSEG
	.MODEL	SMALL

;-------------------------------------------------------------------------------
; Macro Definitions:
;-------------------------------------------------------------------------------

	IF1					; Expand on pass 1 only.
Mul_10	MACRO	factor			; Multiplies byte value by 10.
	MOV	AL,factor		;; Load into AL
	SHL	AL,1			;; AL = Factor * 2 (binary shift left
					;;          1 bit is same as mult * 2)
	MOV	BL,AL			;; Save copy in BL
	SHL	AL,1			;; AL = Factor * 4
	SHL	AL,1			;; AL = Factor * 8
	ADD	AL,BL			;; AL = Factor * 10
	ENDM

OutStr	MACRO	str,lstr
	MOV 	AX,4000h		;; Output string to device.
	MOV 	BX,1			;; Specify STDOUT.
	MOV 	CL,lstr			;; Length of string.
	XOR	CH,CH			;; Turn off high byte.
	MOV 	DX,OFFSET str		;; Point to address of string.
	INT 	21h			;; Call DOS
	ENDM

OutChar	MACRO	char
	MOV	AX,200h			;; Display character to STDOUT.
	MOV	DL,char			;; Character to display.
	INT	21h			;; Call DOS.
	ENDM

	ENDIF

;-------------------------------------------------------------------------------
; Stack Declaration:
;-------------------------------------------------------------------------------

	.STACK	100h

;-------------------------------------------------------------------------------
; Data Segment:
;-------------------------------------------------------------------------------

	.DATA

CMD_TAIL	DB 128 DUP(?)		; Command line arguments go here.
VAL_ARGS	DB 0			; Will show length after non-numerals
					;  are stripped.

CHAR1		DB '0'			; three valid characters for processing.
CHAR2		DB '0'
CHAR3		DB '0'

ERR_LEV		DB ?			; Errorlevel to be set.

ErrorMsg	DB 10,"Syntax: 'SETERR n' where range of 'n' is 0 to 255 inclusive.",13,10,10,"	DOS Errorlevel was not set. (Errorlevel = 0)",13,10

LErrorMsg	DB $ - ErrorMsg

SuccessMsg	DB 10,"The DOS Errorlevel has been set to "
LSuccessMsg	DB $ - SuccessMsg

Windup		DB ".",13,10
LWindup		DB $ - Windup

;-------------------------------------------------------------------------------
; Code Segment:
;-------------------------------------------------------------------------------

	.CODE
	EVEN

Start:
;-------------------------------------------------------------------------------
; Initialize the registers.
;-------------------------------------------------------------------------------

	MOV	AX,@DATA      		; Addr of work areas
	MOV	DS,AX	      		; Set data segment reg

;-------------------------------------------------------------------------------
; Set memory location of command tail and find out how many characters
;  it contains. Set loop counter.
;-------------------------------------------------------------------------------

	MOV	CL,BYTE PTR ES:[80H]  	; Length of command tail
	XOR	CH,CH	      		; Clear hi-byte
	DEC	CL			; Decrement for Carriage Return
	CMP	CL,0	      		; Any parmeter string?
	JGE	@F			; if found, jump forward.
	JMP	Quit	      		;  else far jump to Quit.
@@:					; Forward jump re-entry.

;-------------------------------------------------------------------------------
; Point to buffer to receive command characters, and set up for
;  memory load and store routine.
;-------------------------------------------------------------------------------

	MOV	DI,OFFSET CMD_TAIL	; Buffer to receive argument
	MOV	SI,82H       		; Offset to command parm string
	PUSH	DS	      		; Swap DS/ES
	PUSH	ES
	POP	DS
	POP	ES
	
;-------------------------------------------------------------------------------
; Read command tail a byte at a time.
; Determine whether or not character is a numeral.
; If it is, store it in a buffer area, and increment
;  the count of valid arguments.
;-------------------------------------------------------------------------------

Get:	LODSB				; Byte from param string to AL
	CMP	AL,'0'			; Check if below 0 char.
	JB	@F			; If yes, jump forward.
	CMP	AL,'9'			; Check if above 9 char.
	JA	@F			; If yes, jump forward.

	STOSB				; Store a character in the range
					; 0-9 to CMD_TAIL.

	INC ES:VAL_ARGS			; Increment to show that a valid
					; argument was found.

@@:	LOOP	Get
	
			
	PUSH	DS	; Restore DS/ES for normal processing.
	PUSH	ES
	POP	DS
	POP	ES

;-------------------------------------------------------------------------------
; Now that we have only numerals in CMD_TAIL, we can start to process them.
;-------------------------------------------------------------------------------


	CMP	VAL_ARGS,4		; Less than 4 numerals on cmnd line?
	JL	@F			; If yes, jump forward.
	JMP	Quit			; Obviously more than 255 then. Long jmp
@@:					; Forward re-entry.

;-------------------------------------------------------------------------------
; Find out if there are 1, 2, or 3 valid characters, and assign individaul
; variables accordingly.
;-------------------------------------------------------------------------------

	CMP	VAL_ARGS,3		; Compare VAL_ARGS to 3
	JB	@F			; If less than 3, jump forward.

	MOV	AL,BYTE PTR CMD_TAIL[0] ; Get byte from buffer location.
	MOV	CHAR1,AL		; Assign first character to CHAR1
	MOV	AL,BYTE PTR CMD_TAIL[1]
	MOV	CHAR2,AL		; Second character goes to CHAR2
	MOV 	AL,BYTE PTR CMD_TAIL[2]
	MOV	CHAR3,AL		; Third character goes to CHAR3
	JMP	SHORT	Convert		; Jump to next routine.
@@:
	CMP	VAL_ARGS,2		; Are there only two characters?
	JB	@F			; If no, jump forward.

	MOV	CHAR1,'0'		; Assign place holder to CHAR1
	MOV	AL,BYTE PTR CMD_TAIL[0]
	MOV	CHAR2,AL		; First character goes to CHAR2
	MOV	AL,BYTE PTR CMD_TAIL[1]
	MOV	CHAR3,AL		; Second character goes to CHAR3
	JMP	SHORT	Convert
@@:
					; Only one character found.
	MOV	CHAR1,'0'		; Assign place holders to CHAR1
	MOV	CHAR2,'0'		;  and CHAR2.
	MOV	AL,BYTE PTR CMD_TAIL[0]	; Character goes to CHAR3.
	MOV	CHAR3,AL

;-------------------------------------------------------------------------------
; Convert the three characters into a number.
;-------------------------------------------------------------------------------

Convert:
	MOV	AL,CHAR1		; First char is in the hundreds place.
	SUB	AL,48			; Convert from ASCII to number.
	Mul_10	AL			; Multiply by 10
	Mul_10	AL			; Multiply by 100 (10 * 10)
	JC	Quit			; Trap 300 and above.
	MOV	ERR_LEV,AL		; Else store the result.

	MOV	AL,CHAR2		; Tens place.
	SUB	AL,48			; ASCII to number.
	Mul_10	AL			; Multiply by 10.
	ADD	ERR_LEV,AL		; Else add it.
	JC	Quit			; Trap 260 - 299.

	MOV	AL,CHAR3		; Ones place.
	SUB	AL,48			; Make it a number.
	ADD	ERR_LEV,AL		; Add it.
	JC	Quit			; Trap 256-259.

;-------------------------------------------------------------------------------
; Display the 'successful set' message.
;-------------------------------------------------------------------------------

	Outstr	SuccessMsg,LSuccessMsg

	CMP	VAL_ARGS,3
	JB	@F
	OutChar	CHAR1

@@:	CMP	VAL_ARGS,2
	JB	@F
	OutChar	CHAR2

@@:	OutChar	CHAR3

	OutStr	Windup,LWindup

;-------------------------------------------------------------------------------
; Exit routine.
;-------------------------------------------------------------------------------

Whoa:

	MOV 	AH,4Ch			; Exit with return code (errorlevel)
	MOV	AL,ERR_LEV
	INT 	21h			; Call DOS and exit.

;-------------------------------------------------------------------------------
; Error routine for bad parameters or no parameters.
; Displays proper syntax and exits.
;-------------------------------------------------------------------------------

Quit:
	OutStr	ErrorMsg,LErrorMsg
	JMP	Whoa			; Bail out.

	END 	Start
