//
//       This program will generate a three dimensional maze on a VGA display.
//  A different random number seed will produce a different maze.
//
//       Written by James L. Dean
//                  406 40th Street
//                  New Orleans, LA 70124-1532
//
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <iostream.h>
#include "oracle.h"
#include "cell.h"
#include "titillat.h"
#include "sqrmaze.h"
#include "plot3d.h"
#include "vga3d.h"

#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif

// maze constants
#define PIXELS_PER_ROOM 30
#define RESOLUTION       4  // larger values takes more time (and virtual
                            // memory) but produce a better image

static int    external_to_plot(double,double);
static double f(double,double);
       int    main(void);
static int    red(double,double);

extern unsigned _stklen=0x8000;
       maze     *maze_ptr;

int main()
    {
      static   int    fatal_error;
      static   int    num_columns;
      static   int    num_rows;
      static   double light_x;
      static   double light_y;
      static   double light_z;
      static   int    response;
      static   double rotation;
      static   char   seed [9];
               time_t start_time;
               time_t stop_time;
      static   double tilt;
      static   vga3d  *vga3d_ptr;

      fatal_error=FALSE;
      clrscr();
      cout << "                                 Maze Generator"
       << '\n' << '\n' << '\n' << '\n';
      cout << "     After the maze is displayed, press \"S\" to see the "
       << "solution or another" << '\n';
      cout << "key to exit.  If the solution is displayed, press any key "
       << "to exit." << '\n';
      cout << "\n     Random number seed? ";
      cin.get(&seed[0],9,'\n');
      time(&start_time);
      stop_time=start_time;
      vga3d_ptr=new vga3d();
      num_columns=(vga3d_ptr->num_x_pixels())/PIXELS_PER_ROOM;
      num_rows=(int) (((2.0/sqrt(3.0))
       *(vga3d_ptr->aspect_ratio())
       *((double) (vga3d_ptr->num_y_pixels())))
       /((double) PIXELS_PER_ROOM));
      maze_ptr=new maze(num_rows,num_columns,RESOLUTION,&seed[0]);
      if (maze_ptr->constructed())
        {
          rotation=(double) 0.0;
          tilt=(double) 30.0;
          light_x=(double) 1.5;
          light_y=(double) -1.0;
          light_z=(double) 2.6;
          if (vga3d_ptr->prepare_plot(f,maze_ptr->x_min(),maze_ptr->x_max(),
           maze_ptr->y_min(),maze_ptr->y_max(),external_to_plot,red,
           maze_ptr->num_x_divisions(),maze_ptr->num_y_divisions(),
           rotation,tilt,light_x,light_y,light_z))
            {
              if (vga3d_ptr->plot("",FALSE,FALSE,1.0))
                {
                  time(&stop_time);
                  fflush(stdin);
                  response=getch();
                  fflush(stdin);
                  if ((response == (int) 's')
                  ||  (response == (int) 'S'))
                    {
                      if (vga3d_ptr->plot("",TRUE,FALSE,1.0))
                        {
                          fflush(stdin);
                          response=getch();
                          fflush(stdin);
                        }
                    }
                }
            }
        }
      delete maze_ptr;
      delete vga3d_ptr;
      cout << "     It took " << stop_time-start_time  
       << " seconds to generate and display the maze." << '\n';
      return(fatal_error);
    }

static int external_to_plot(
  double x,
  double y)
    {
       return maze_ptr->external_to_maze(x,y);
    }

static int red(
  double x,
  double y)
    {
       return maze_ptr->part_of_solution(x,y);
    }

static double f(
  double x,
  double y)
    {
       return maze_ptr->f(x,y);
    }
