#ifndef SQRMAZE_H
#define SQRMAZE_H

//      Each instance of this class is a maze having square rooms.

//      This class uses the classes "cell" (room of a maze), "oracle"
// (random number generator), and "titillat" (amuse user).

class maze
  {
    private:
      oracle     *column_selector;
//      Random number generator to select column to start constructing maze.

      struct
        {
           int row_num;
           int column_num;
        }        current;
//      Current location in maze.

      int        memory_allocated;
//      The two dimensional array of rooms has been allocated.

      int        num_columns;
//      Number of columns in maze.

      int        num_rows;
//      Number of rows in maze.

      oracle     *order_selector;
//      Random number generator to select the order walls are to considered.

      cell       **room;
//      Two dimensional array of rooms composing the maze.

      oracle     *row_selector;
//      Random number generator to select row to start constructing maze.

      titillator *titillator_ptr;
//      Keep the user amused while the maze is constructed.

      struct
        {
           int row_num;
           int column_num;
        }        first;
//      Location of the starting room.

      int        wall_thickness;
//      Thickness of wall.

    public:

      int    constructed(void) {return memory_allocated;}
//      Return TRUE if and only if the maze is successfully constructed.

      int    external_to_maze(double x,double y);
//      Return TRUE if and only if a point (x,y) is external to the maze.

      double f(double x,double y);
//      Return 6.0*wall_thickness if a point (x,y) is on a wall, 0.0 otherwise.

             maze(int row_count,int column_count,int thickness_of_wall,
              char *seed);
//      Contruct a maze having "row_count" rows and "column_count" columns of
// rooms.  The walls should be "thickness_of_wall" (bricks) thick.  A different
// (8 character of less) "seed" generally yields a different maze.

             ~maze(void);

      int    maze_okay(void);
//      TRUE if and only if solving the maze is difficult enough.

      int    num_x_divisions(void)
              {return 3*wall_thickness*num_rows+wall_thickness+2;}
//      Recommended number of x divisions for plotting f(x,y).

      int    num_y_divisions(void)
              {return 3*wall_thickness*num_columns+wall_thickness+2;}
//      Recommended number of y divisions for plotting f(x,y).

      int    part_of_solution(double x,double y);
//      Return TRUE if and only if a point (x,y) is on a wall outlining the
// solution to the maze.

      double x_max(void)
              {return double(3*wall_thickness*num_rows+wall_thickness);}
//      Recommended maximum value of x for plotting f(x,y).

      double x_min(void) {return(-1.0);}
//      Recommended minimum value of x for plotting f(x,y).

      double y_max(void)
              {return double(3*wall_thickness*num_columns+wall_thickness);}
//      Recommended maximum value of y for plotting f(x,y).

      double y_min(void) {return(-1.0);}
//      Recommended minimum value of y for plotting f(x,y).
  };

#endif
