Program ShowGrab;

{$X+,R-,S-,I- }

uses Dos, VGABios, TpKey;

{$IFDEF STUB }
  {$M 4096, 0, 0 }
{$ELSE }
  {$M 4096, 153600, 200000 }
{$ENDIF }

Const
  Title        = 'SHOWGRAB.  Displays a file produced by VGAGRAB.  '+
                 'Written by Wilbert van Leijen';
  Usage        : String[26] = 'usage is showgrab filename';
  GrabSign     : String[8] = 'VGAGrab!';

Type
  ErrorType    = (NoError, NoParam, NoVGAAdapter, NotGrabfile, FileNotOpen,
                  ReadError);
Var
  Infile       : File;
  Infilename   : PathStr;
  ConfigRec    : Record
                   Signature   : Array[0..7] of Char;
                   PictureMode : Byte;
                 end;
  Bitplane     : Array[0..3] of Pointer;
  BitplaneSize : Word;
  Mode13DAC    : Array[0..255] of RGBType;
  Mode10DAC    : Record
                   RegisterTable   : Array[0..15] of Byte;
                   RGBTable        : Array[0..15] of RGBType;
                 end;

{  FILE FORMAT Ŀ
                                                                      
    All video modes, at offset 0                                      
    ---------------                                                   
    Header = Record                                                   
               Signature : Array[0..7] of Char;                       
               VideoMode : Byte;                                      
             end;                                                     
                                                                      
    Video mode specific information, at offset 8                      
    -------------------------------                                   
    Mode 0Dh:                                                         
    Bitmap = Record                                                   
               Bitplanes : Array[0..3, 1..8000] of Byte;              
               Registers : Array[0..15] of Byte;                      
               DACValues : Array[0..15] of Record                     
                             Red, Green, Blue : Byte;                 
                           end;                                       
             end;                                                     
    Mode 0Eh:                                                         
    Bitmap = Record                                                   
               Bitplanes : Array[0..3, 1..16000] of Byte;             
               Registers : Array[0..15] of Byte;                      
               DACValues : Array[0..15] of Record                     
                             Red, Green, Blue : Byte;                 
                           end;                                       
             end;                                                     
    Mode 10h:                                                         
    Bitmap = Record                                                   
               Bitplanes : Array[0..3, 1..28000] of Byte;             
               Registers : Array[0..15] of Byte;                      
               DACValues : Array[0..15] of Record                     
                             Red, Green, Blue : Byte;                 
                           end;                                       
             end;                                                     
    Mode 12h:                                                         
    Bitmap = Record                                                   
               Bitplanes : Array[0..3, 1..28000] of Byte;             
               Registers : Array[0..15] of Byte;                      
               DACValues : Array[0..15] of Record                     
                             Red, Green, Blue : Byte;                 
                           end;                                       
             end;                                                     
    Mode 13h:                                                         
    Bitmap = Record                                                   
               Bitplane  : Array[1..320, 1..200] of Byte;             
               DACValues : Array[0..255] of Record                    
                             Red, Green, Blue : Byte;                 
                           end;                                       
             end;                                                     
   }

Procedure CrtWrite(s : String); External;
Procedure CrtWriteLn(s : String); External;
{$L CRTWRITE.OBJ }

Procedure Error(fault : ErrorType);
                             {          1         2         3      }
Const                        { 12345678901234567890123456789012345 }
  mNotVGA      : String[30] = 'program requires a VGA adapter';
  mNotGrabfile : String[16] = 'invalid filetype';
  mFilenotOpen : String[20] = ' could not open file';
  mReadError   : String[19] = ' error reading file';
  StrErrorOfs  : Array[ErrorType] of Word = (
                   0, Ofs(Usage), Ofs(mNotVGA), Ofs(mNotGrabfile),
                   Ofs(mFileNotOpen), Ofs(mReadError));
Begin
  CrtWrite(#13'error: ');
  Case fault of
    FileNotOpen, NotGrabfile, ReadError : CrtWrite(Infilename);
  end;
  CrtWriteLn(String(Ptr(DSeg, StrErrorOfs[fault])^));
  Halt(Ord(fault));
end;  { Error }

Procedure Openfile;

Begin
  Infilename := ParamStr(1);
  Assign(Infile, Infilename);
  Reset(Infile, 1);
  If IOResult > 0 Then
    Error(FileNotOpen);
  BlockRead(Infile, ConfigRec, SizeOf(ConfigRec));
  If ConfigRec.Signature <> GrabSign Then
    Error(NotGrabfile);
end;  { Openfile }

Procedure WaitForKey; Assembler;

ASM
        MOV    AX, 0C07h
        INT    21h
end;  { WaitForKey }

Procedure Readfile;

Var
  i            : Integer;

Begin
  Case ConfigRec.PictureMode of
    $0D : BitplaneSize := 8000;
    $0E : BitplaneSize := 16000;
    $10 : BitplaneSize := 28000;
    $12 : BitplaneSize := 38400;
    $13 : BitplaneSize := 320*200;
  end;
  If ConfigRec.PictureMode = $13 Then
    Begin
      GetMem(Bitplane[0], BitplaneSize);
      BlockRead(Infile, Bitplane[0]^, BitplaneSize);
      If IOResult > 0 Then
        Error(ReadError);
      BlockRead(Infile, Mode13DAC, SizeOf(Mode13DAC));
    end
  Else
    Begin
      For i := 0 to 3 Do
        Begin
          GetMem(Bitplane[i], BitplaneSize);
          BlockRead(Infile, Bitplane[i]^, BitplaneSize);
          If IOResult > 0 Then
            Error(ReadError);
        end;
      BlockRead(Infile, Mode10DAC, SizeOf(Mode10DAC));
    end;
  If IOResult > 0 Then
    Error(ReadError);
end;  { Readfile }

{ Select a bitplane.  Needed for 16-colour modes }

Procedure SwitchBitplane(plane : Byte); Assembler;

ASM
        MOV   DX, 3C4h
        MOV   AL, 2
        OUT   DX, AL
        INC   DX
        MOV   AL, plane
        OUT   DX, AL
end;  { SwitchBitplane }

{ Update the DAC table of mode 13h }

Procedure SetMode13DAC; Assembler;

ASM
        XOR   BX, BX
        PUSH  DS
        POP   ES
        MOV   DX, Offset [Mode13DAC]
        MOV   CX, 256
        MOV   AX, 1012h
        INT   10h
end;  { SetMode13DAC }

Procedure DisplayPicture;

Var
  i            : Integer;

Begin
  If ConfigRec.PictureMode = $13 Then
    Begin
      SetMode13DAC;
      Move(Bitplane[0]^, Ptr($A000, $0000)^, BitplaneSize);
    end
  Else
    Begin
      For i := 0 to 15 Do
        With Mode10DAC Do
          Begin
            SetRegister(i, RegisterTable[i]);
            SetRGBValue(RegisterTable[i], RGBTable[i]);
          end;
      For i := 0 to 3 Do
        Begin
          SwitchBitplane(1 shl i);
          Move(Bitplane[i]^, Ptr($A000, $0000)^, BitplaneSize);
        end;
    end;
end;  { DisplayPicture }

Begin
  CrtWriteLn(Title);
  If ParamCount = 0 Then
    Error(NoParam);
  If VGAStatus = NotVGA Then
    Error(NoVGAAdapter);
  Openfile;
  Readfile;
  Close(Infile);
  SetVideoMode(ConfigRec.PictureMode);
  DisplayPicture;
  WaitForKey;
  SetVideoMode(LastMode);
end.  { ShowGrab }