/*--------------------------------------------------------------------------*
 *                                                                          *
 *  RESIZE:     Adjust the size of a file to be equal to the number of      *
 *              characters found before Control-Z.                          *
 *                                                                          *
 *--------------------------------------------------------------------------*
 *                                                                          *
 *  NOTES:      Compiled using MSC 6.0                                      *
 *                                                                          *
 *                  CL /AT resize.c                                         *
 *                                                                          *
 *--------------------------------------------------------------------------*/

#include <dos.h>
#include <io.h>
#include <stdio.h>


static char         buffer[32000];

void            main(int argc, char **argv)
{
    int             i, fh, c, errors;
    long            fs, rl, sl, ol;
    unsigned        fd, ft;
    char          **fn, *p;
    FILE           *fp;


    if (argc < 2)
    {
        printf("RESIZE V1.00 - Resize file to retain data before Control-Z.\n"
               "Copyright 1991, Gee Wiz Software.  All rights reserved.\n\n"
               "Usage: resize file-1 [file-2 ... file-n]\n\n");
        exit(0);
    }

    for (errors = 0, i = 1, fn = argv + 1, fp = NULL; i < argc; i++, fn++)
    {
        if (fp != NULL)
        {
            clearerr(fp);
            fclose(fp);
        }

        if ((fp = fopen(*fn, "r+b")) == NULL)
        {
            errors++;
            printf("* OPEN failed on file %s.\n", *fn);
            continue;
        }

        fh = fileno(fp);

        if ((ol = filelength(fh)) == -1)
        {
            errors++;
            printf("* INFO failed on file %s.\n", *fn);
            continue;
        }

        for (fs = 0;;)
        {
            rl = fread(buffer, 1, sizeof(buffer), fp);

            for (sl = 0, p = buffer; sl < rl && *p != 0x1a; sl++, p++);

            fs += sl;

            if (sizeof(buffer) > rl)
            {
                if (feof(fp))
                    break;

                if (ferror(fp))
                {
                    fs = -1;
                    errors++;
                    printf("* READ failed on file %s.\n", *fn);
                    break;
                }
            }
        }


        if (fs != -1)
        {
            do
            {
                if (fs >= ol)
                {
                    printf("- File %s left intact at %ld bytes.\n", *fn, ol);
                    break;
                }

                _dos_getftime(fh, &fd, &ft);

                if (chsize(fh, fs) == -1)
                {
                    errors++;
                    printf("* SIZE failed on file %s.\n", *fn);
                    break;
                }

                _dos_setftime(fh, fd, ft);

                printf("+ File %s resized to %ld bytes.\n", *fn, fs);

            }   while(0);
        }
    }


    if (fp != NULL)
    {
        clearerr(fp);
        fclose(fp);
    }

    if (errors)
        printf("%d %s occurred.\n", errors, (errors == 1) ? "error" : "errors");

    exit(errors);
}
