#include "trt.h"

#define GET_DRIVER_ID            1
/*     2 to 4 & 6 reserved because used by driver rel80   */
#define GET_DRIVER_INSTANCE      5

#define GET_DRIVER_DIR           7
#define GET_DRIVER_INFO          8


#define GET_DRIVER_LINK         10
#define SET_DRIVER_LINK         11
#define OPEN_READER_SESSION     12
#define CLOSE_READER_SESSION    13
#define COM_INIT                14
#define SET_INTERRUPT           15
#define IS_BOUND                16
#define IS_OPEN                 17
#define GET_COM_PARAM           18


#define GET_SECURITY_BITS       20
#define START_WATCH_DOG         21
#define SET_BOOT_PORT           22
#define GET_PTR_TO_BCSEQ4_FLAG  23
#define COMPARE_SERIAL_NUMBER   24
#define GET_BOOT_INFO           25
#define GET_PTR_TO_RUN_FLAG     26


#define VSCD_OK               0
#define VSCD_INCOMPATIBLE     0x74

#define S1200       0
#define S2400       1
#define S4800       2
#define S9600       3
#define S19200      4

#define EDGE_CONTROL    0x84
#define NO_SPEED_CHANGE 0x00
#define DFC_INACTIVE    0x80

#define NO_PARITY   0
#define ODD_PARITY  1
#define EVEN_PARITY 2

#define STOP_BIT_1  0
#define STOP_BIT_2  1

#define DATA_BIT_5  0
#define DATA_BIT_6  1
#define DATA_BIT_7  2
#define DATA_BIT_8  3


#pragma pack (1)

typedef struct
{
  BYTE  cmde;
} GENERAL_IOCTL;

typedef struct
{
   BYTE cmde;
   unsigned int  driver_ker;
   unsigned int  vscd_compatibility;
} GET_DRIVER_KER;

typedef struct
{
     BYTE cmde;
     unsigned long strat;
     unsigned long inter;
     unsigned int port;
     unsigned int add;
     unsigned int speed;
     unsigned int dfc;
} DRIVER_LINK;

typedef struct
{
     BYTE cmde;
     BYTE dir[140];
} DRIVER_DIR;

typedef struct
{
  unsigned int port;
  unsigned int add;
  unsigned long strat;
  unsigned long inter;
} LINK_TABLE;

typedef struct
{
     BYTE cmde;
     unsigned int port;
     unsigned int add;
} RDR_OPEN;

typedef struct
{
     BYTE cmde;
     unsigned int port;
     unsigned int add;
} RDR_CLOSE;

typedef struct
{
     BYTE cmde;
     unsigned int port;
     unsigned int add;
} RDR_BIND;

typedef struct
{
     BYTE cmde;
     unsigned int port;
     unsigned int add;
     BYTE open_flag;
     BYTE connex;
     BYTE vm;
} IS_OPENED;

typedef struct
{
     BYTE cmde;
     unsigned int port;
     unsigned int irq;
} SET_IRQ;

typedef struct
{
     BYTE cmde;
     unsigned int port;
     unsigned int add;
     BYTE speed;
     BYTE parity;
     BYTE stop_bits;
     BYTE data_bits;
} RDR_COM_INIT;

typedef struct
{
    BYTE cmde;
    BYTE boot_port;
}   BOOT_PORT;

typedef struct
{
    BYTE cmde;
    BYTE far *ptr_flag;
}   GET_SEQ4_FLAG_PTR;

typedef struct
{
    BYTE cmde;
    BYTE far *run_flag;
}   GET_RUN_FLAG_PTR;

typedef struct
{
    BYTE cmde;
    BYTE serial[10];
}   CMP_SERIAL_NB;

typedef struct
{
    BYTE cmde;
    BYTE reader_type;
    BYTE operator_card_eject;
    BYTE bport;
    BYTE baddh;
    BYTE baddl;
}   BOOT_INFO;


#pragma pack()

