{$M 16384,0,655360}

(* This is a test program for the TSUNTM.TPU unit *)

uses Dos,
     TSUNTH,  (* to have access to keyboad type *)
     TSUNTM;

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTG unit test by Prof. Timo Salmi');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;

(* Test of the timed inkey function *)
procedure TEST1;
var key : char;
    timeout : boolean;
begin
  repeat
    key := INKEYFN (3.0, timeout);
    if not timeout then write (key)
      else begin writeln; writeln ('Timeout',#7); end;
  until key = #27;
end;  (* test1 *)

(* Detect special keys, and normal keyboard scancodes. Note that depending
   on the keyboard some of the tests below can be mutually exclusive.
   CTLFN excludes detecting RTCTRLFN, LFCTRLFN, and SYSRQFN. ALTFN excludes
   FLATLFN. *)
procedure TEST2;
var ch : char;
begin
  writeln ('Esc to exit');
  repeat
    if LFSHFTFN then write ('LfShift ');
    if RTSHFTFN then write ('RtShift ');
    {}
    if ISENHAFN then
       begin
         if LFCTRLFN then write ('LfCtrl ');
         if RTCTRLFN then write ('RtCtrl ');
       end
     else
       if CTRLFN then write ('Ctrl ');
    {}
    if ISENHAFN then
       if LFALTFN  then write ('LfAlt ')
         else                               (* Notice the else else trick *)
      else
         if ALTFN    then write ('Alt ');
    {}
    if RTALTFN  then write ('RtAlt ');
    if SYSRQFN  then write ('SysRq ');
    if KEYPREFN then
      begin
        ch := READKEFN;
        case ch of
          #0  : begin
                  write (byte(ch), ' ');    (* ord(ch) is ok, too *)
                  ch := READKEFN;           (* byte(ch) is an just an *)
                  write (byte(ch), ' ');    (* example of typecasting *)
                end;
          #27 : exit;
          else write (byte(ch), ' ');
        end; {case}
      end; {if}
  until false;
end;  (* test2 *)

(* Test for the shift keys *)
procedure TEST3;
var ch : char;
    changed : boolean;
begin
  writeln ('Esc to exit');
  changed := true;
  repeat
    if LFSHFTFN then
      if changed then
        begin
          write ('LfShiftDown ');
          changed := false;
        end
      else
    else
      changed := true;
    {}
    if KEYPREFN then
      begin
        ch := READKEFN;
        case ch of
          #27 : exit;
        end; {case}
      end; {if}
  until false;
end;  (* test3 *)

(* Test reading enhanced keyboard keys. Notice the trick to get the
   low and the high parts of a Turbo Pascal word *)
procedure TEST4;
var scancode : word;
    key      : array [1..2] of byte absolute scancode;
begin
  repeat
    scancode := RDENKEFN;
    {}
    {... show the first part of the scancode ...}
    write (key[1], ' ');
    {}
    {... enhanced keys have also a second part in the scancode ...}
    case key[1] of
      0, 224 : write (key[2], ' ');
    end;
  until (key[1] = 27)                 (* escape with esc *)
         or (scancode = 0);           (* not an enhanced keyboard *)
end;  (* test4 *)

(* Display the ascii value and the scancode of the key pressed *)
procedure TEST5;
var scanCode : byte;
    charCode : byte;
    s        : string;
begin
  writeln ('Press Esc to end this folly');
  writeln;
  repeat
    GETSCAN (scanCode, charCode);
    case charCode of
      0..31, 129..255 : begin
                          Str(charCode, s);
                          s := 'asc(' + s + ')';
                        end;
      else s := chr(charCode)
    end; {case}
    writeln (s, ' scancode = ', scancode:3);
  until scancode = 1;
end;  (* test5 *)

(* Display the ascii value and the scancode of the key pressed for
   the enhanced keyboard with GETESCAN. To test the presence of an
   enhanced keyboard use ISENHAFN from the TSUNTH unit *)
procedure TEST6;
var scanCode : byte;
    charCode : byte;
    s        : string;
begin
  writeln ('Press Esc to end this folly');
  writeln;
  repeat
    GETESCAN (scanCode, charCode);
    case charCode of
      0..31, 129..255 : begin
                          Str(charCode, s);
                          s := 'asc(' + s + ')';
                        end;
      else s := chr(charCode)
    end; {case}
    writeln (s, ' scancode = ', scancode:3);
  until scancode = 1;
end;  (* test6 *)

(* Main program
   If you just want a particular test, comment the others away, just as
   I have done.
   If you want pauses, put readln where appropriate *)
begin
  LOGO;
  TEST1;
  TEST2;
  TEST3;
  TEST4;
  TEST5;
  TEST6;
  {}
  write ('Press <-'' '); readln;
end.  (* tsuntm.tst *)
