{*****************************************************************************}
{*  This program displays all the characters of the hershey font.            *}
{*                                                                           *}
{*  This code is donated to the Public domain.                               *}
{*                                                                           *}
{*  Dov Grobgeld                                                             *}
{*  Department of Chemical Physics                                           *}
{*  The Weizmann Institute of Science                                        *}
{*  Israel                                                                   *}
{*  Email: dov@menora.weizmann.ac.il                                         *}
{*                                                                           *}
{*  8/9/1991                                                                 *}
{*****************************************************************************}
uses graph, dos, tphersh;

var
  gd, gm, i,j,k : integer;
  s : string[10];
  mem: longint;

begin
  mem:= MaxAvail;
  HersheyLoadGlyphs;
  writeln('Font load size: ', mem - MaxAvail);
  write('Press Enter to continue...'); readln; 

  gd:= detect;
  initgraph(gd, gm, getenv('bgidir')); { Set the environment variable bgi dir }
                                       { to the directory where the bgi files reside }

  for i:= 1 to 20 do begin
    for j:= 1 to 10 do begin
      HersheySetGlyphSize(6,6);
      str((i-1)*200 + (j-1)*20: 4, s);
      HersheyOutTextXY(1,j*35,s);
      HersheySetGlyphSize(20,20);
      for k:= 1 to 20 do begin
        HersheyMove(20+k*25,j*35);
        HersheyDisplayGlyph((i-1)*200+(j-1)*20+k);
      end;
    end;
    readln; { Wait until keypressed }
    ClearViewPort;
  end;
        
  closegraph;
end.

