(******************************************************************************
*                                  quickSrt                                   *
* perform a generic quick sort in memory, using a generic quicksort object    *
******************************************************************************)
unit quickSrt;


{$R-,S-}

interface

type
   arrayOfPointersPtr = ^ arrayOfPointers;
   arrayOfPointers = array [1..1] of pointer;

   quickSortPtr = ^ quickSort;
   quickSort = object
      numberOfElements  : longInt;
      ptrArray          : arrayOfPointersPtr;
      blokSize          : word;

      constructor init  (  noe           : longint;
                           pa            : arrayOfPointersPtr;
                           bs            : word
                        );
      function compare(a, b : pointer) : byte ; virtual;  { 0 if a = b,
                                                            1 if a > b,
                                                            2 if a < b }
      procedure doYourJob;
      procedure recursiveSort(left, right : longInt);

   end; { quickSort object definition }

implementation

(******************************************************************************
*                               quickSort.init                                *
******************************************************************************)
constructor quickSort.init;
begin
  numberOfElements := noe;
  ptrArray         := pa; { pointer to an array of pointers to the data }
  blokSize         := bs;
end; {quickSort.init}

(******************************************************************************
*                              quickSort.compare                              *
******************************************************************************)
function quickSort.compare;
begin
   { descendent will override ... }
end; {quickSort.compare}

(******************************************************************************
*                           quickSort.recursiveSort                           *
* here is the main body of the alogorithm. we use the middle record as the    *
* pivot                                                                       *
******************************************************************************)
procedure quickSort.recursiveSort;
var
  i,j,x: longInt;
  y,p  : Pointer;
  mid  : pointer; { here is the data we are interested in copied to .. }
begin
  i := left; 
  j := right; 
  getMem(mid, blokSize);
  x := (left + right) div 2;
  move(ptrArray^[x]^, mid^, blokSize); { we will compare to mid^ }
  repeat
  {$R-}
    while (compare(mid, ptrArray^[i]) = 1) do { when p[x] > p[i] }
      inc(i);
    while (compare(ptrArray^[j], mid) = 1) do { when p[j] > p[x] }
      dec(j);
    if (i <= j) then begin
      y := ptrArray^[i]; 
      ptrArray^[i] := ptrArray^[j]; 
      ptrArray^[j] := y;
      inc(i);
      dec(j);
    end; { do the swap }
  until (i > j);
  freemem(mid, blokSize);
  if ((j - left) < (right - i)) then begin { left partition is smaller then right }
   if (left < j) then
      recursiveSort(left, j);
   if (i < right) then
      recursiveSort(i, right);
  end else begin { right partition is smaller }
   if (i < right) then
      recursiveSort(i, right);
   if (left < j) then 
      recursiveSort(left, j);
  end; 
end; {quickSort.recursiveSort}

(******************************************************************************
*                             quickSort.doYourJob                             *
******************************************************************************)
procedure quickSort.doYourJob;
begin
   recursiveSort( 1, numberOfElements);
end; {quickSort.doYourJob}

(******************************************************************************
*                                    MAIN                                     *
******************************************************************************)
end.

