Program QNRDemo;

Uses
   DBF4,
   Pick,
   SAYGET4,
   Browse4,
   VidPop,
   QNR,
   Crt;

Var
   Done         : Boolean;
   SampleQuery,
   FileName     : String;

Procedure Beep;

Begin
   Sound(700);
   Delay(30);
   NoSound
End;

PROCEDURE ClearScreen ( C : Char );

VAR
   S : STRING;
   I : INTEGER;

BEGIN
   S := '';
   FOR I := 1 TO Lo(WindMax) + 1 DO
      S := S + C;
   GotoXY(1, 1);
   FOR I := 1 TO Hi(WindMax) + 1 DO
      Write(S)
END;

Procedure DisplayResults;

Begin
   Set_BrowseWindow_To(25, 2, 79, 19, DoubleTopSingleSide + Shadow + Explode,
      'Query Result');

   { Initialize the query marker }

   InitializeQuery;
   If ParseQuery
      Then
         Begin
            SET_FILTER_TO(@ProcessQuery);
            GoTop;
            If Not dEof
               Then
                  Browse('PLAIN')
               Else
                  Begin
                     PushWindow(25, 2, 65, 2);
                     AT(25, 2, 'The query returned no valid records!');
                     Beep;
                     Repeat
                     Until KeyPressed;
                     PopWindow
                  End;
            SET_FILTER_TO(Nil)
         End
End;

Begin
   Done := FALSE;
   
   While (Not Done) Do
      Begin
         ClearScreen('');
         Set_PickWindow_To(2, 2, 17, 19, 
            DoubleTopSingleSide + Shadow + Explode, 'Databases');
         Filename := PickFile('*.DBF');
         Done := (FileName = '');
         If (Not Done)
            Then
               Begin
                  Use(FileName, NIL, 0);
                  If (RecCount > 0)
                     Then
                        Begin
                           SampleQuery := '';
                           GetQuery(SampleQuery);
                           QueryString := SampleQuery;
                           DisplayResults
                        End
                     Else
                        Begin
                           PushWindow(25, 2, 65, 2);
                           AT(25, 2, 'The file selected has no records!');
                           Beep;
                           Repeat
                           Until KeyPressed;
                           PopWindow
                        End;
                  Use('', NIL, 0)
               End
      End
End.
