{$N+}

program sqwave;

{ >>>>>>>> If you are using Turbo Pascal 6.0, change to math6387 :- }
uses
  dos, crt, graph, math7387;

{ Program to demonstrate the speed of the MATH387 sine function.
  Calculates a series of odd harmonics to plot square waves, using
  the formula:
               y = sin x  +  1/3 sin 3x  +  1/5 sin 5x  +  ...
     order:        1             3              5          ...
  The program requests the order of the calculation: 1 produces a pure
  sine wave, while values above about 101 produce a near square wave.
  A value of 601 or more is suggested to provide long enough run times
  for meaningful time measurements on fast machines.

  Written by Chris Williams, 12 May 1995. }

var
  xp, x1, x2, miny, maxy, minx, maxx, xscale, yscale : single;
  i, graph_driver, graph_mode, error_code, max_x, max_y,
    yoffset, order : integer;
  ch : char;
  timestart, num_calc : longint;
  time_borland, time_math387 : real;

function now : longint;
{ Returns the time of call in 100th of a second }
var
  hour, min, sec, sec100th : word;
  lhour, lmin, lsec, lsec100th : longint;
begin
  gettime (hour, min, sec, sec100th);
  lhour := hour;
  lmin := min;
  lsec := sec;
  lsec100th := sec100th;
  now := lsec100th + lsec*100 + lmin*6000 + lhour*360000;
end;  { of now }

procedure reset_timer;
{ Resets start of time interval for use with "timer" }
begin
  timestart := now
end;  { of reset_timer }

function timer : real;
{ Outputs seconds elapsed since "reset_timer" was called }
begin
  timer := (now - timestart) / 100.0
end;  { of timer }

function y_borland (order : integer; x : single) : single;
{ Odd harmonic calculation using Borland library "sin" }
var
  i : integer;
  t : single;
begin
  t := 0.0;
  i := 1;
  while i <= order do
  begin
    t := t + (1.0 / i) * sin (x * i);
    inc (i, 2)
  end;
  y_borland := t
end;

function y_math387 (order : integer; x : single) : single;
{ Odd harmonic calculation using MATH387 inline "s_sin" }
var
  i : integer;
  t : single;
begin
  t := 0.0;
  i := 1;
  while i <= order do
  begin
    t := t + (1.0 / i) * s_sin (x * i);
    inc (i, 2)
  end;
  y_math387 := t
end;

begin  { of main program }
  if not test387 then
    error387;
  repeat
    clrscr;
    writeln;
    writeln ('            SQWAVE version 1.0 (c) Chris Williams, 1995');
    writeln;
    writeln ('This program demonstrates the speed of the MATH7387 unit by plotting');
    writeln ('a square wave graph calculated from adding odd harmonics.');
    writeln;
    repeat
      writeln ('Enter an odd value for the order of the calculations');
      write ('(in the range 1 to 32765, suggest about 601) : ');
      readln (order)
    until order >= 1;
    repeat
      writeln;
      write ('Enter the maximum X value (suggest about 25) : ');
      readln (x2);
    until (x2 > 0.0) and (x2 < 10000.0);
    writeln;
    writeln (' >>>> The first (top) graph is drawn using the Borland library "sin"');
    writeln;
    writeln (' >>>> The second (bottom) graph is drawn using MATH7387 "s_sin"');
    writeln;
    writeln ('Press any key to draw graphs (Q to quit) ...');
    ch := readkey;
    if ch = #0 then
      ch := readkey;
    if ch in ['q', 'Q'] then
      halt;
    { Set graph limits }
    x1 := 0.0;
    maxy := 1.0;
    miny := -1.0;
    graph_driver := detect;
    initgraph (graph_driver, graph_mode, '');
    error_code := graphresult;
    if error_code <> grok then
    begin
      writeln ('**** Error selecting graphics : "',
               grapherrormsg (error_code), '"');
      writeln ('     Program aborted ...');
      ch := readkey;
      halt (1)
    end;
    max_x := getmaxx;
    max_y := getmaxy div 2;
    yscale := max_y / (maxy - miny);
    xscale := (x2 - x1) / max_x;
    rectangle (0, 0, max_x, max_y);
    moveto (0, max_y - round ((y_borland (order, x1) - miny) * yscale));
    reset_timer;
    for i := 0 to max_x do
    begin
      xp := i * xscale + x1;
      lineto (i, max_y - round ((y_borland (order, xp) - miny) * yscale));
    end;
    time_borland := timer;
    yoffset := max_y;
    max_x := getmaxx;
    max_y := getmaxy div 2;
    yscale := max_y / (maxy - miny);
    xscale := (x2 - x1) / max_x;
    rectangle (0, yoffset, max_x, max_y + yoffset);
    moveto (0, yoffset + max_y - round ((y_math387 (order, x1) - miny) * yscale));
    reset_timer;
    for i := 0 to max_x do
    begin
      xp := i * xscale + x1;
      lineto (i, yoffset + max_y - round ((y_math387 (order, xp) - miny) * yscale));
    end;
    time_math387 := timer;
    ch := readkey;
    if ch = #0 then
      ch := readkey;
    closegraph;
    num_calc := longint (max_x + 1) * ((order + 1) div 2);
    writeln ('Timings for ', num_calc, ' sine calculations are:');
    writeln ('  Borland library "sin" : ', time_borland : 8 : 2, ' seconds.');
    writeln ('  MATH387 "s_sin"       : ', time_math387 : 8 : 2, ' seconds.');
    writeln;
    writeln ('Press any key to continue (Q to quit) ...');
    ch := readkey;
    if ch = #0 then
      ch := readkey;
    if ch in ['q', 'Q'] then
      halt
  until false
end.
