{ OPOLIB.PAS : Argument option handling object libraryy

  title   : OPOLIB
  version : 1.0
  date    : Dec 14,1995
  author  : J R Ferguson
  language: Borland Pascal v7.0 with Objects
  usage   : Unit
  remarks : Object Oriented version of OptLib
}

{$V-  Var-string checking off}
{$B-  Short-circuit boolean expression generation }
{$R+  Range check on}

Unit OpoLib;

INTERFACE
uses DefLib, OptLib, RngLib, Objects;

type
  P_Opo_Options = ^T_Opo_Options;


  T_Opo_Options = Object(TObject)
  { Embedding of OptLib routines in object format }
    OptLst      : OptLstPtr;
    Constructor Init;
    Destructor  Done; virtual;
    procedure   DefSw(V_Idn: char); virtual;
    procedure   DefNm(V_Idn: char;
                      V_Required: boolean; V_Min,V_Max,V_Dfl: integer);
                      virtual;
    procedure   DefRg(V_Idn: char;
                      V_LRequired: boolean; V_LMin,V_LMax,V_LDfl: integer;
                      V_RRequired: boolean; V_RMin,V_RMax,V_RDfl: integer);
                      virtual;
    procedure   DefCh(V_Idn: char; V_Dfl: char); virtual;
    procedure   DefSt(V_Idn: char); virtual;
    function    Parse(V_Arg: StpTyp; var V_OK: boolean): boolean; virtual;
    function    Scanned(V_Idn: char): boolean; virtual;
    function    ValSw(V_Idn: char): boolean; virtual;
    function    ValNm(V_Idn: char; V_Index: integer): integer; virtual;
    function    ValRg(V_Idn: char): RngTyp; virtual;
    function    RgInside(V_Idn: char; V_Value: integer): boolean; virtual;
    function    ValCh(V_Idn: char): char; virtual;
    function    ValSt(V_Idn: char): StpTyp; virtual;
  end;


IMPLEMENTATION


{
--- T_Opo_Options methods ---
}

Constructor T_Opo_Options.Init;
begin Inherited Init; OptInit(OptLst); end;

Destructor  T_Opo_Options.Done;
begin OptDone(OptLst); Inherited Done; end;

procedure   T_Opo_Options.DefSw(V_Idn: char);
begin OptDefSw(OptLst,V_Idn); end;

procedure   T_Opo_Options.DefNm(V_Idn: char;
              V_Required: boolean; V_Min,V_Max,V_Dfl: integer);
begin OptDefNm(OptLst,V_Idn,V_Required,V_Min,V_Max,V_Dfl); end;

procedure   T_Opo_Options.DefRg(V_Idn: char;
              V_LRequired: boolean; V_LMin,V_LMax,V_LDfl: integer;
              V_RRequired: boolean; V_RMin,V_RMax,V_RDfl: integer);
begin
  OptDefRg(OptLst,V_Idn,V_LRequired,V_LMin,V_LMax,V_LDfl,
                        V_RRequired,V_RMin,V_RMax,V_RDfl);
end;

procedure   T_Opo_Options.DefCh(V_Idn: char; V_Dfl: char);
begin OptDefCh(OptLst,V_Idn,V_Dfl); end;

procedure   T_Opo_Options.DefSt(V_Idn: char);
begin OptDefSt(OptLst,V_Idn); end;

function    T_Opo_Options.Parse(V_Arg: StpTyp; var V_OK: boolean): boolean;
begin Parse:= OptParse(OptLst,V_Arg,V_OK); end;

function    T_Opo_Options.Scanned(V_Idn: char): boolean;
begin Scanned:= OptScanned(OptLst,V_Idn); end;

function    T_Opo_Options.ValSw(V_Idn: char): boolean;
begin ValSw:= OptValSw(OptLst,V_Idn); end;

function    T_Opo_Options.ValNm(V_Idn: char; V_Index: integer): integer;
begin ValNm:= OptValNm(OptLst,V_Idn,V_Index); end;

function    T_Opo_Options.ValRg(V_Idn: char): RngTyp;
begin ValRg:= OptValRg(OptLst,V_Idn); end;

function    T_Opo_Options.RgInside(V_Idn: char; V_Value: integer): boolean;
begin RgInside:= OptRgInside(OptLst,V_Idn,V_Value); end;

function    T_Opo_Options.ValCh(V_Idn: char): char;
begin ValCh:= OptValCh(OptLst,V_Idn); end;

function    T_Opo_Options.ValSt(V_Idn: char): StpTyp;
begin ValSt:= OptValSt(OptLst,V_Idn); end;


END.
