{ EVLLIB.PAS : real expression evaluation

  Title   : EVLLIB
  Version : 4.0
  Date    : Nov 10,1996
  Language: Borland Turbo Pascal 4.0 through 7.0 (all targets)
  Author  : J R Ferguson
  Usage   : unit
  Remarks : Read EVLLIB.DOC for more information
}

UNIT EvlLib;

INTERFACE
uses DefLib;

function eval(expr: StpTyp; x: real; var error: boolean): real;


IMPLEMENTATION
{[  Uses ConLib;  ]}


const
  EvlFLen = 6;  { max. length function identifier }
  EvlMaxS = 20; { max. depth expression stack }

type
  EvlSym  = (IllSym, PlsSym, MinSym, MulSym, DivSym, Lparen, Rparen,
             SinIdn, CosIdn, TanIdn, CotIdn, AtnIdn, AbsIdn, ExpIdn,
             LogIdn, SqtIdn, SqrIdn, Number, VarIdn, EndSym);
  EvlFstr = string[EvlFLen];
  EvlFstI = 0..EvlFLen;
  EvlFtbI = SinIdn..SqrIdn;
  EvlStkI = 0..EvlMaxS;

var
  EvlFidn : set of EvlSym;
  EvlFtab : array[EvlFtbI] of EvlFstr;
  EvlSPtr : EvlStkI;
  EvlStck : array[EvlStkI] of real;


{[
const TEST   = true;
      DBGOUT = '';
var   DbgAct : boolean;
      Dbg    : text;

procedure DbgInit;
begin
  if TEST then DbgAct:= YesNo('Debug') else DbgAct:= false;
  if DbgAct then begin Assign(Dbg,DBGOUT); rewrite(Dbg); end;
end;

procedure DbgTrc(msg: StpTyp);
begin if DbgAct then begin writeln(Dbg); write(Dbg,'/',msg,'/ ') end end;
 ]}

{-- EvalInit --}

procedure EvalInit;
begin
  EvlFidn         := [SinIdn .. SqrIdn];
  EvlFtab[SinIdn] := 'sin';
  EvlFtab[CosIdn] := 'cos';
  EvlFtab[TanIdn] := 'tan';
  EvlFtab[CotIdn] := 'cot';
  EvlFtab[AtnIdn] := 'arctan';
  EvlFtab[AbsIdn] := 'abs';
  EvlFtab[ExpIdn] := 'exp';
  EvlFtab[LogIdn] := 'ln';
  EvlFtab[SqtIdn] := 'sqrt';
  EvlFtab[SqrIdn] := 'sqr';
end;

function eval(expr: StpTyp; x: real; var error: boolean): real;
const NULL  : char = #0;
var   i     : StpInd;
      l     : StpInd absolute expr;
      c     : char;
      sym   : EvlSym;
      tmp,
      value : real;

{[
  procedure DbgLn;  begin if DbgAct then writeln(Dbg) end;
  procedure DbgVal; begin if DbgAct then write(Dbg,' val=',value:8) end;
  procedure DbgChr; begin if DbgAct then write(Dbg,' c="',c:1,'" i=',i) end;
  procedure DbgStk; begin if DbgAct then write(Dbg,' sp=',EvlSPtr); end;

  procedure DbgSym;
  begin if DbgAct then begin
    write(Dbg,'sym=');
    case sym of
      IllSym: write(Dbg,'IllSym'); PlsSym: write(Dbg,'PlsSym');
      MinSym: write(Dbg,'MinSym'); MulSym: write(Dbg,'MulSym');
      DivSym: write(Dbg,'DivSym'); Lparen: write(Dbg,'Lparen');
      Rparen: write(Dbg,'Rparen'); SinIdn: write(Dbg,'SinIdn');
      CosIdn: write(Dbg,'CosIdn'); TanIdn: write(Dbg,'TanIdn');
      CotIdn: write(Dbg,'CotIdn'); AtnIdn: write(Dbg,'AtnIdn');
      AbsIdn: write(Dbg,'AbsIdn'); ExpIdn: write(Dbg,'ExpIdn');
      LogIdn: write(Dbg,'LogIdn'); SqtIdn: write(Dbg,'SqtIdn');
      SqrIdn: write(Dbg,'SqrIdn'); Number: write(Dbg,'Number');
      VarIdn: write(Dbg,'VarIdn'); EndSym: write(Dbg,'EndSym');
    end;
  end end;

  procedure DbgAll;
  begin DbgSym; DbgChr; DbgStk; DbgVal end;
 ]}

  procedure ErrMsg(msg: StpTyp);
  begin if not error then begin
  {$I-}
    writeln; writeln(expr);
    writeln('^':i);
    writeln('EVAL: ',msg);
  {$I+} if IOResult <> 0 then {ignore, just reset IOResult flag};
{[  DbgAll; DbgLn;  ]}
    error:= true;
  end end;

  procedure ndLparen;
  begin
{[  DbgTrc('ndLparen');  ]}
    if sym <> Lparen then ErrMsg('missing "("');
  end;

  procedure ndRparen;
  begin
{[  DbgTrc('ndRparen');  ]}
    if sym <> Rparen then ErrMsg('missing ")"');
  end;

  procedure GetChr;
  begin
{[  DbgTrc('GetChr');  ]}
    if i=l then c:= NULL else begin i:= succ(i); c:= expr[i] end;
    if c in ['A'..'Z'] then c:= chr(ord(c)+32);
{[  DbgChr; ]}
  end;

  procedure compare(t: EvlFtbI; var NoMatch: boolean);
  var c0   : char;
      i0   : StpInd;
      f,fl : EvlFstI;
  begin
{[  DbgTrc('compare');  ]}
    c0:= c; i0:= i; f:= 1; fl:= Length(EvlFtab[t]);
    while (c = EvlFtab[t][f]) and (f<fl) do begin f:= succ(f); GetChr end;
    NoMatch:= c <> EvlFtab[t][f];
    if NoMatch then begin i:= i0; c:= c0 end;
  end;

  procedure ndFidn;
  var NoMatch : boolean;
  begin
{[  DbgTrc('ndFidn');  ]}
    sym:= SinIdn;
    compare(sym,NoMatch);
    while NoMatch and (sym<SqrIdn) do begin
      sym:= succ(sym);
      compare(sym,NoMatch)
    end;
    if NoMatch then sym:= IllSym;
  end;

  procedure ChSgn;                      forward;
  function  TenPower(n: integer): real; forward;
  procedure push;                       forward;
  procedure pop;                        forward;

  function DigVal(c: char): integer;
  begin DigVal:= ord(c)-48; {[  DbgVal;  ]} end;

  procedure exponent;
  begin
    tmp:= value; pop; value:= value * TenPower(trunc(tmp));
{[  DbgTrc('exponent'); DbgVal;  ]}
  end;

  procedure UnsInt;
  begin
    value:= 0.0;
    while c in ['0'..'9'] do begin
      value:= 10.0*value + DigVal(c); GetChr;
    end;
{[  DbgTrc('UnsInt'); DbgVal;  ]}
  end;

  procedure FracPrt;
  var w : real;
  begin
    w:= 1.0;
    while c in ['0'..'9'] do begin
      w:= w/10; value:= value + w*DigVal(c); GetChr;
    end;
{[  DbgTrc('FracPrt'); DbgVal;  ]}
  end;

  procedure FpNum;
  begin
    UnsInt; if c='.' then begin GetChr; FracPrt end;
{[  DbgTrc('FpNum'); DbgVal;  ]}
  end;

  procedure ExpPrt;
  begin
    if c='-' then begin GetChr; UnsInt; ChSgn end
    else begin if c='+' then GetChr; UnsInt end;
    exponent;
{[  DbgTrc('ExpPrt'); DbgVal;  ]}
  end;

  procedure UnsNum;
    begin
      FpNum;
      if c='e' then begin push; GetChr; ExpPrt end;
{[    DbgTrc('UnsNum'); DbgVal;  ]}
    end;

  procedure GetSym;
  begin if not error then begin
{[  DbgTrc('GetSym');  ]}
    while c=' ' do GetChr;
    if c in ['0'..'9','.'] then begin UnsNum; sym:= Number end
    else if c= NULL then sym:= EndSym
    else begin
      case c of
        '+' : sym:= PlsSym;
        '-' : sym:= MinSym;
        '*' : sym:= MulSym;
        '/' : sym:= DivSym;
        '(' : sym:= Lparen;
        ')' : sym:= Rparen;
        'x' : sym:= VarIdn;
        else ndFidn;
      end;
{[    DbgAll;  ]}
      GetChr;
    end
  end end;

  procedure push;
  begin
{[  DbgTrc('push'); DbgVal;  ]}
    EvlStck[EvlSPtr]:= value;
    if EvlSPtr=EvlMaxS then ErrMsg('stack full')
    else EvlSPtr:= succ(EvlSPtr);
  end;

  procedure pop;
  begin
{[  DbgTrc('pop');  ]}
    if EvlSPtr = 0 then ErrMsg('stack empty')
    else begin
      EvlSPtr:= pred(EvlSPtr); value:= EvlStck[EvlSPtr];
{[    DbgVal;  ]}
    end;
  end;

  function TenPower{(n: integer): real}; { 10 ** n }
  var i: integer; m, p: real;
  begin
    i:= abs(n); m:= 10.0; p:= 1.0;
    while i>0 do begin
      while not odd(i) do begin i:= i div 2; m:= sqr(m) end;
      i:= pred(i); p:= m*p;
    end;
    if n>0 then TenPower:= p else TenPower:= 1.0/p;
  end;

  procedure ChSgn;
  begin
    value:= -value;
{[  DbgTrc('ChSgn'); DbgVal;  ]}
  end;

  procedure add;
  begin
    tmp:= value; pop; value:= value+tmp;
{[  DbgTrc('add'); DbgVal;  ]}
  end;

  procedure subtract;
  begin
    ChSgn; add;
{[  DbgTrc('subtract'); DbgVal;  ]}
  end;

  procedure mult;
  begin
    tmp:= value; pop; value:= value*tmp;
{[  DbgTrc('mult'); DbgVal;  ]}
  end;

  procedure divide;
  begin
    tmp:= value; pop; value:= value/tmp;
{[  DbgTrc('divide'); DbgVal;  ]}
  end;

  procedure factor;   forward;
  procedure term;     forward;
  procedure argument; forward;

  procedure expression;
  begin
{[  DbgTrc('expression');  ]}
    term;
    while sym in [PlsSym,MinSym] do
      if sym = PlsSym
      then begin push; GetSym; term; add end
      else begin push; GetSym; term; subtract end;
  end;

  procedure term;
  begin
{[  DbgTrc('term');  ]}
    factor;
    while sym in [MulSym, DivSym] do
      if sym =MulSym
      then begin push; GetSym; factor; mult end
      else begin push; GetSym; factor; divide end;
  end; {term}

  procedure UnsFac;
  begin
{[  DbgTrc('UnsFac');  ]}
    if sym = VarIdn then value:= x
    else if sym = Number   then {nothing}
    else if sym in EvlFidn then begin
      case sym of
        SinIdn: begin argument;  value:= sin(value)            end;
        CosIdn: begin argument;  value:= cos(value)            end;
        TanIdn: begin argument;  value:= sin(value)/cos(value) end;
        CotIdn: begin argument;  value:= cos(value)/sin(value) end;
        AtnIdn: begin argument;  value:= arctan(value)         end;
        AbsIdn: begin argument;  value:= abs(value)            end;
        ExpIdn: begin argument;  value:= exp(value)            end;
        LogIdn: begin argument;  value:= ln(value)             end;
        SqtIdn: begin argument;  value:= sqrt(value)           end;
        SqrIdn: begin argument;  value:= sqr(value)            end;
      end;
    end
    else if sym = Lparen then begin GetSym; expression; ndRparen end
    else if sym = EndSym then ErrMsg('syntax error')
    else ErrMsg('illegal character');
    GetSym;
  end; {UnsFac}

  procedure factor;
  begin
{[  DbgTrc('factor');  ]}
    if sym in [PlsSym,MinSym] then begin
      if sym = PlsSym then begin GetSym; UnsFac end
      else begin GetSym; UnsFac; ChSgn end;
    end
    else UnsFac;
  end;

  procedure argument;
  begin
{[  DbgTrc('argument');  ]}
    GetSym; ndLparen; GetSym; expression; ndRparen;
  end;


begin {function eval}
  EvlSPtr:= 0; i:= 0; c:= ' '; error:= false;
  GetSym; expression;
  eval:= value;
{[ DbgLn; DbgAll; DbgLn;  ]}
  if sym <> EndSym then ErrMsg('syntax error');
end;


BEGIN {initialization }

{[ DbgInit; ]}
  EvalInit;

END.
