{ CHRLIB.PAS  Character function library

  Title   : CHRLIB
  Version : 3.3
  Language: Turbo Pascal 4.0+ (all targets), Borland Delphi 1.0
  Date    : Nov 08,1996
  Author  : J.R. Ferguson
  Usage   : Unit
}

UNIT ChrLib;

INTERFACE

function IsAlnum(c: char): boolean;
{ Test if c is alphanumeric ('A'..'Z', 'a'..'z', '0'..'9'). }

function IsAlpha(c: char): boolean;
{ Test if c is alphabetic ('A'..'Z', 'a'..'z'). }

function IsAscii(c: char): boolean;
{ Test if c is an ASCII character (ordinal value 0..127). }

function IsCntrl(c: char): boolean;
{ Test if c is a control-character (ordinal value 0..31 or 127). }

function IsDigit(c: char): boolean;
{ Test if c is a digit ('0'..'9'). }

function IsGraph(c: char): boolean;
{ Test if c is a graphic (visible) character (ordinal value 33..126). }

function IsLower(c: char): boolean;
{ Test if c is a lower case letter ('a'..'z'). }

function IsPrint(c: char): boolean;
{ Test if c is a printable character (ordinal value 32..126). }

function IsPunct(c: char): boolean;
{ Test if c is a punctuation character. This is true for all printable
  characters that are not alphanumeric. }

function IsSpace(c: char): boolean;
{ Test if c is a 'white space' character (space, horizontal tab, 
  vertical tab, carriage return, line feed and form feed). Ordinal 
  values 9..12 and 32. }

function IsUpper(c: char): boolean;
{ Test if c is an upper case letter ('A'..'Z'). }

function IsBDigit(c: char): boolean;
{ Test if c is a binary digit ('0' or '1'). }

function IsQDigit(c: char): boolean;
{ Test if c is an octal digit ('0'..'7'). }

function IsXDigit(c: char): boolean;
{ Test if c is a hexadecimal digit ('0'..'9', 'A'..'F', 'a'..'f'). }

function ToAscii(c: char): char;
{ Get the ASCII equivalent for character c. If the character code in use
  is ASCII already, only the parity bit is reset, so the function result 
  will have an ordinal value in the range 0..127. }

function ToLower(c: char): char;
{ Get the lower case converted value of character c. }

function ToUpper(c: char): char;
{ Get the upper case converted value of character c. }

function Order(c1,c2: char): integer;
{ Compare the ordinal values of characters c1 and c2. The result will be 
  negative if c1<c2, zero if c1=c2 and positive if c1>c2. }

function UppOrder(c1,c2: char): integer;
{ Compare the ordinal values of characters c1 and c2 after both characters 
  have been translated to upper case. The result will be negative if c1<c2, 
  zero if c1=c2 and positive if c1>c2. }

function LexOrder(c1,c2: char): integer;
{ Compare the characters c1 and c2 using a 'lexicographic' order, defined
  as follows:
    first group: control characters
    next group : punctuation characters
    next group : digits
    last group : letters (upper and lower case considered equal)
  Within each group the order is based on the ordinal value.
  The result will be negative if c1<c2, zero if c1=c2 and positive if 
  c1>c2. }


IMPLEMENTATION

const
 Cundef =' '; Ccntrl ='0'; Cpunct ='1'; Cdigit ='2'; Clower ='3'; Cupper ='4';
 Dundef =' '; Dspace ='0'; Dgraph ='1'; Dqdigit='2'; Dxdigit='3';

 ATTR : record case boolean of
           false: (AA,AB,AC,AD,BA,BB,BC,BD: array[ $00.. $3F] of char);
           true : (A          ,B          : array[#000..#255] of char);
         end
      =   {0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF}
 {0-3}(AA:'0000000000000000000000000000000011111111111111112222222222111111';
 {4-7} AB:'1444444444444444444444444441111113333333333333333333333333311110';
 {8-B} AC:'                                                                ';
 {C-F} AD:'                                                                ';
          {0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF}
 {0-3} BA:'         00000                  01111111111111112222222233111111';
 {4-7} BB:'133333311111111111111111111111111333333111111111111111111111111 ';
 {8-B} BC:'                                                                ';
 {C-F} BD:'                                                                ');
          {0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF}

function IsAlpha (c: char): boolean; begin IsAlpha :=ATTR.A[c] > Cdigit  end;
function IsDigit (c: char): boolean; begin IsDigit :=ATTR.A[c] = Cdigit  end;
function IsAlnum (c: char): boolean; begin IsAlnum :=ATTR.A[c] > Cpunct  end;
function IsAscii (c: char): boolean; begin IsAscii :=ATTR.A[c] > Cundef  end;
function IsCntrl (c: char): boolean; begin IsCntrl :=ATTR.A[c] = Ccntrl  end;
function IsPrint (c: char): boolean; begin IsPrint :=ATTR.A[c] > Ccntrl  end;
function IsGraph (c: char): boolean; begin IsGraph :=ATTR.B[c] > Dspace  end;
function IsLower (c: char): boolean; begin IsLower :=ATTR.A[c] = Clower  end;
function IsUpper (c: char): boolean; begin IsUpper :=ATTR.A[c] = Cupper  end;
function IsPunct (c: char): boolean; begin IsPunct :=ATTR.A[c] = Cpunct  end;
function IsSpace (c: char): boolean; begin IsSpace :=ATTR.B[c] = Dspace  end;
function IsBDigit(c: char): boolean; begin IsBDigit:=(c='0') or (c='1')  end;
function IsQDigit(c: char): boolean; begin IsQDigit:=ATTR.B[c] = Dqdigit end;
function IsXDigit(c: char): boolean; begin IsXDigit:=ATTR.B[c] > Dgraph  end;

function ToLower(c: char): char;
  var b: byte absolute c;
  begin if ATTR.A[c] = Cupper then ToLower:= chr(b+32) else ToLower:= c end;

function ToUpper(c: char): char;
  begin ToUpper:= UpCase(c) end;       

function ToAscii(c: char): char;
  var b: byte absolute c;
  begin ToAscii:= chr(b and $7F) end;

function Order(c1,c2: char): integer;
  var b1: byte absolute c1; b2: byte absolute c2;
  begin order:= b1-b2 end;

function UppOrder(c1,c2: char): integer;
  begin UppOrder:= Order(UpCase(c1),UpCase(c2)) end;

function LexOrder(c1,c2: char): integer;
  var b1: byte absolute c1; b2: byte absolute c2;
  function LexOrd(n: integer): integer;
    var cc: record lsh,msh: char end  absolute n;
    begin
      with cc do begin lsh:= UpCase(chr(n and $7F)); msh:= ATTR.A[lsh] end;
      Lexord:= n;
    end;
  begin LexOrder:= LexOrd(b1) - LexOrd(b2) end;

END.
