{ BPWLIB.PAS - Borland Pascal Object Windows enhancement library

  title   : BPWLIB
  version : 1.3
  date    : Apr 12,1994
  author  : J R Ferguson
  language: Borland Pascal v7.0 with Objects + Object Windows
  usage   : Unit
}

UNIT BPWLIB;



INTERFACE
Uses Objects, ODialogs, OWindows, WinProcs, WinTypes, Strings;

{$I OBJTYPE.INC}

const
  C_ScrollWindowClass = 'BPWScrollWindow';

type
  P_ScrnFont    = ^T_ScrnFont;
  P_ScrollWindow= ^T_ScrollWindow;
  P_ListWindow  = ^T_ListWindow;

  T_ScrnFont    = Object(TObject)
    LogFont     : TLogFont;
    CharWidth   : integer;
    CharHeight  : integer;
    Context     : HDC;
    OldFont     : HFont;
    OldTxColor  : TColorRef;
    OldBkColor  : TColorRef;
    Selected    : boolean;
    Constructor   Init;
    Destructor    Done; virtual;
    Constructor   Load(var V_Stream: TStream);
    procedure     Store(var V_Stream: TStream);
    procedure     Select(V_Context: HDC);    virtual;
    procedure     UnSelect;                  virtual;
    procedure     Highlight;                 virtual;
    procedure     Normal;                    virtual;
    function      Width: integer;            virtual;
    function      Height: integer;           virtual;
  end;

  T_ScrollWindow= Object(TWindow)
  { Automatically handles horizontal and vertical scrolling of text lines.
    This object can not be used as is. You must derive an object that at
    least redefines the GetText method, and optionally ProcessItem and
    others. Derived objects should NOT use a Scroller. }
    ScrnFont    : P_ScrnFont; { screen font }
    TopRow      : integer;    { first visible row }
    CurRow      : integer;    { current row }
    MaxRow      : integer;    { last row }
    LftCol      : integer;    { leftmost visible column }
    Constructor Init(var V_Parent: PWindowsObject; V_Title: PChar);
    Destructor  Done; virtual;
    Constructor Load(var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    function    GetClassName: PChar; virtual;
                { Returns the Default class name: 'BPWScrollWindow' }
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
                { Executes TWindow's GetWindowClass, then sets the class
                  style cs_DblClks. }
    function    GetText     (V_Row: integer): String;  virtual;
                { Dummy routine returning an empty string.
                  Overwrite this function to return a line to be displayed
                  at the given absolute V_Row offset. }
    procedure   ProcessItem (V_Row: integer); virtual;
                { Dummy routine here.
                  Overwrite to define any action to be performed when the
                  current line is selected by pressing ENTER or double
                  clicking it with the mouse. }
    procedure   ReDraw; virtual;
                { Invalidates the window, so Paint will be called. }
    procedure   Paint(V_DC: HDC; var V_PaintInfo: TPaintStruct); virtual;
    procedure   SetTopRow   (V_Row: integer); virtual;
    procedure   SetCurRow   (V_Row: integer); virtual;
    procedure   SetMaxRow   (V_Row: integer); virtual;
    procedure   SetLftCol   (V_Col: integer); virtual;
  private
    MaxCol      : integer;    { max line width of current page }
    RowsPerPage : integer;    { number of rows in current window }
    ColsPerPage : integer;    { number of columns in current window }
    LButtonDown : boolean;    { Left mouse button is down }
    procedure   AdjustTopRow   ; virtual;
    procedure   SetScrollParms ; virtual;
    procedure   WMHScroll      (var V_Msg: TMessage);
                virtual wm_First + wm_HScroll;
    procedure   WMVScroll      (var V_Msg: TMessage);
                virtual wm_First + wm_VScroll;
    procedure   WMKeyDown      (var V_Msg: TMessage);
                virtual wm_First + wm_KeyDown;
    procedure   WMLButtonDown  (var V_Msg: TMessage);
                virtual wm_First + wm_LButtonDown;
    procedure   WMLButtonUp    (var V_Msg: TMessage);
                virtual wm_First + wm_LButtonUp;
    procedure   WMMouseMove    (var V_Msg: TMessage);
                virtual wm_First + wm_MouseMove;
    procedure   WMLButtonDblClk(var V_Msg: TMessage); virtual
                wm_First + wm_LButtonDblClk;
    function    YtoRow(V_Y: integer; var V_Row: integer):boolean; virtual;
  end;

  T_ListWindow = Object(T_ScrollWindow)
  { A derivate of T_ScrollWindow that handles a list display of a
    collection (of strings). }
    List        : PCollection; { considered to contain PString entries. }
    Constructor Init(var V_Parent: PWindowsObject; V_Title: PChar;
                     V_List: PCollection);
    Destructor  Done; virtual;
                { Disposes of the List before it disposes of itself. }
    Constructor Load(var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    function    GetText(V_Row: integer): String;  virtual;
                { As defined here, GetText assumes that List^.At(V_Row)
                  points to the string to be displayed.
                  Override this method if this is not the case. }
    procedure   NewList(V_List: PCollection); virtual;
                { Disposes of the current list, if any, and sets a new
                  one. }
  end;

{.hlptx skip 20}
const

  R_ScrnFont   : TStreamRec = (
    ObjType : OT_BPWLIB_ScrnFont;
    VmtLink : Ofs(TypeOf(T_ScrnFont)^);
    Load    : @T_ScrnFont.Load;
    Store   : @T_ScrnFont.Store);

  R_ScrollWindow : TStreamRec = (
    ObjType : OT_BPWLIB_ScrollWindow;
    VmtLink : Ofs(TypeOf(T_ScrollWindow)^);
    Load    : @T_ScrollWindow.Load;
    Store   : @T_ScrollWindow.Store);

  R_ListWindow   : TStreamRec = (
    ObjType : OT_BPWLIB_ListWindow;
    VmtLink : Ofs(TypeOf(T_ListWindow)^);
    Load    : @T_ListWindow.Load;
    Store   : @T_ListWindow.Store);

procedure RegisterBPWLIB;
{ Register all object types defined in this unit for stream I/O. }

function  BPWStreamMsg(var V_Stream: TStream): String;
{ Formats a message based on V_Stream's Status and ErrorInfo values. }


IMPLEMENTATION


{ --- General --- }

procedure RegisterBPWLIB;
begin
  RegisterType(R_ScrnFont);
  RegisterType(R_ScrollWindow);
  RegisterType(R_ListWindow);
end;

function BPWStreamMsg(var V_Stream: TStream): String;
var StatStr,StatMsg,InfoStr: String;
begin with V_Stream do begin
  Str(Status,StatStr); Str(ErrorInfo,InfoStr);
  case Status of
    stOk         : StatMsg:= 'No error';
    stError      : StatMsg:= 'Access error';
    stInitError  : StatMsg:= 'Cannot initialize stream';
    stReadError  : StatMsg:= 'Read beyond end of stream';
    stWriteError : StatMsg:= 'Cannot expand stream';
    stGetError   : StatMsg:= 'Get of unregistered object type';
    stPutError   : StatMsg:= 'Put of unregistered object type';
    else           StatMsg:= 'Unknown status code';
  end;
  BPWStreamMsg:= StatStr+'('+InfoStr+') '+StatMsg;
end; end;


{ --- T_ScrnFont --- }

Constructor   T_ScrnFont.Init;
begin
  Inherited Init;
  with LogFont do begin
    lfHeight         := 10;
    lfWidth          := 0;
    lfEscapement     := 0;
    lfOrientation    := 0;
    lfWeight         := fw_DontCare;
    lfItalic         := 0;
    lfUnderline      := 0;
    lfStrikeOut      := 0;
    lfCharSet        := ANSI_CharSet;
    lfOutPrecision   := Out_Default_Precis;
    lfClipPrecision  := Clip_Default_Precis;
    lfQuality        := Default_Quality;
    lfPitchAndFamily := Fixed_Pitch or ff_DontCare;
    StrCopy(@lfFaceName,'Courier');
  end;
  CharWidth := 1;
  CharHeight:= 1;
  Selected  := false;
end;

Destructor    T_ScrnFont.Done;
begin
  UnSelect;
  Inherited Done;
end;

Constructor   T_ScrnFont.Load(var V_Stream: TStream);
begin with V_Stream do begin
  Read(LogFont   ,SizeOf(LogFont));
  Read(CharWidth ,SizeOf(CharWidth));
  Read(CharHeight,SizeOf(CharHeight));
  Read(Selected  ,SizeOf(Selected));
end; end;

procedure     T_ScrnFont.Store(var V_Stream: TStream);
begin with V_Stream do begin
  Write(LogFont   ,SizeOf(LogFont));
  Write(CharWidth ,SizeOf(CharWidth));
  Write(CharHeight,SizeOf(CharHeight));
  Write(Selected  ,SizeOf(Selected));
end; end;

procedure     T_ScrnFont.Select(V_Context: HDC);
var Extent: LongInt;
begin
  UnSelect;
  Context   := V_Context;
  OldFont   := SelectObject(Context, CreateFontIndirect(LogFont));
  OldTxColor:= GetTextColor(Context);
  OldBkColor:= GetBkColor(Context);
  Extent    := GetTextExtent(Context,'0',1);
  CharWidth := LoWord(Extent);
  CharHeight:= HiWord(Extent);
  Selected  := true;
end;

procedure     T_ScrnFont.UnSelect;
begin if Selected then begin
  DeleteObject(SelectObject(Context, OldFont));
  Selected  := false;
end end;

procedure     T_ScrnFont.HighLight;
begin if Selected then begin
  SetTextColor(Context,OldBkColor);
  SetBkColor  (Context,OldTxColor);
end end;

procedure     T_ScrnFont.Normal;
begin if Selected then begin
  SetTextColor(Context,OldTxColor);
  SetBkColor  (Context,OldBkColor);
end; end;

function      T_ScrnFont.Height: integer; begin Height:= CharHeight; end;
function      T_ScrnFont.Width : integer; begin Width := CharWidth ; end;


{ --- T_ScrollWindow --- }

Constructor T_ScrollWindow.Init(var V_Parent: PWindowsObject; V_Title: PChar);
begin
  Inherited Init(V_Parent, V_Title);
  Attr.Style:= Attr.Style or ws_VScroll or ws_HScroll;
  New(ScrnFont,Init);
  TopRow:= 0; CurRow:= 0; MaxRow:= -1; LftCol:= 0;
  MaxCol:= -1; RowsPerPage:= 0; ColsPerPage:= 0;
  LButtonDown:= false;
  SetScrollParms;
end;

Destructor  T_ScrollWindow.Done;
begin
  Dispose(ScrnFont,Done);
  if LButtonDown then ReleaseCapture;
  Inherited Done;
end;

Constructor T_ScrollWindow.Load(var V_Stream: TStream);
begin
  Inherited Load(V_Stream);
  ScrnFont:= P_ScrnFont(V_Stream.Get);
  V_Stream.Read(TopRow,SizeOf(TopRow));
  V_Stream.Read(CurRow,SizeOf(CurRow));
  V_Stream.Read(MaxRow,SizeOf(MaxRow));
  V_Stream.Read(LftCol,SizeOf(LftCol));
  MaxCol:= -1; RowsPerPage:= 0; ColsPerPage:= 0;
  LButtonDown:= false;
  SetScrollParms;
end;

procedure   T_ScrollWindow.Store(var V_Stream: TStream);
begin
  Inherited Store(V_Stream);
  V_Stream.Put(ScrnFont);
  V_Stream.Write(TopRow,SizeOf(TopRow));
  V_Stream.Write(CurRow,SizeOf(CurRow));
  V_Stream.Write(MaxRow,SizeOf(MaxRow));
  V_Stream.Write(LftCol,SizeOf(LftCol));
end;

function    T_ScrollWindow.GetClassName: PChar;
begin GetClassName:= C_ScrollWindowClass; end;

procedure   T_ScrollWindow.GetWindowClass(var V_Class: TWndClass);
begin
  Inherited GetWindowClass(V_Class);
  V_Class.Style:= V_Class.Style or cs_DblClks;
end;

function    T_ScrollWindow.GetText     (V_Row: integer): String;
begin end;

procedure   T_ScrollWindow.ProcessItem (V_Row: integer);
begin end;

procedure   T_ScrollWindow.ReDraw;
begin InvalidateRect(HWindow,nil,false); end;

procedure   T_ScrollWindow.Paint(V_DC: HDC; var V_PaintInfo: TPaintStruct);
var R: TRect; row,EndRow,i,w: integer; line: String; lineZ: array[0..255] of char;
begin
  MaxCol:= -1;
  if MaxRow >= 0 then begin
    ScrnFont^.Select(V_DC);
    GetClientRect(HWindow,R);
    RowsPerPage:= ((R.Bottom+1) div ScrnFont^.Height)-1;
    ColsPerPage:= ((R.Right +1) div ScrnFont^.Width )-1;
    AdjustTopRow;
    for row:= TopRow to TopRow + RowsPerPage do begin
      if (row < 0) or (row > MaxRow) then begin line:= ''; w:= 0; end
      else begin line:= GetText(row); w:= Length(line); end;
      if w > MaxCol then MaxCol:= w;
      line:= Copy(line,LftCol+1,ColsPerPage+1);
      for i:= Length(line) to ColsPerPage+1 do line:= line + ' ';
      if row=CurRow then ScrnFont^.HighLight;
      TextOut(V_DC, 0, (row-TopRow)*ScrnFont^.Height, StrPCopy(lineZ,line), Length(line));
      if row=CurRow then ScrnFont^.Normal;
    end;
    ScrnFont^.Unselect;
  end;
  {PM} if MaxCol > -1 then MaxCol:= 255;
  SetScrollParms;
end;

procedure   T_ScrollWindow.SetTopRow   (V_Row: integer);
begin
  if V_Row  >  MaxRow then V_Row:= MaxRow;
  if V_Row  <  0      then V_Row:= 0;
  if TopRow <> V_Row  then TopRow:= V_Row;
  if CurRow <> V_Row  then CurRow:= V_Row;
  ReDraw;
end;

procedure   T_ScrollWindow.SetCurRow   (V_Row: integer);
begin
  if V_Row >  MaxRow then V_Row:= MaxRow;
  if V_Row <  0      then V_Row:= 0;
  if V_Row <> CurRow then begin CurRow:= V_Row; ReDraw; end;
end;

procedure   T_ScrollWindow.SetMaxRow   (V_Row: integer);
begin
  if V_Row < -1 then V_Row:= -1;
  if V_Row <> MaxRow then begin
    MaxRow:= V_Row;
    if CurRow > MaxRow then CurRow:= MaxRow;
    ReDraw;
  end;
end;

procedure   T_ScrollWindow.SetLftCol   (V_Col: integer);
begin
  if V_Col < 0 then V_Col:= 0
  else if V_Col > MaxCol - ColsPerPage then V_Col:= MaxCol - ColsPerPage;
  if V_Col <> LftCol then begin LftCol:= V_Col; ReDraw; end;
end;

{private}

procedure   T_ScrollWindow.AdjustTopRow;
begin
  if      MaxRow < 1                    then TopRow:= 0
  else if TopRow > CurRow               then TopRow:= CurRow
  else if TopRow < CurRow - RowsPerPage then TopRow:= CurRow - RowsPerPage;
  if TopRow < 0 then TopRow:= 0;
end;

procedure   T_ScrollWindow.SetScrollParms;
var min0,max0,max1: integer;
begin
  {HScrollBar:}
  if (MaxRow < 0) or (MaxCol - ColsPerPage < 2) then begin LftCol:= 0; max1:= 0; end
  else begin
    if GetScrollPos(HWindow,sb_Horz)<>LftCol then SetScrollPos(HWindow,sb_Horz,LftCol,true);
    max1:= MaxCol - (ColsPerPage+1);
  end;
  GetScrollRange(HWindow,sb_Horz,min0,max0);
  if (min0<>0) or (max0<>max1) then SetScrollRange(HWindow,sb_Horz,0,max1,true);
  {VScrollBar:}
  if MaxRow < 1 then max1:= 0 else begin
    max1:= MaxRow;
    if GetScrollPos(HWindow,sb_Vert)<>CurRow then SetScrollPos(HWindow,sb_Vert,CurRow,true);
  end;
  GetScrollRange(HWindow,sb_Vert,min0,max0);
  if (min0<>0) or (max0<>max1) then SetScrollRange(HWindow,sb_Vert,0,max1,true);
end;

procedure   T_ScrollWindow.WMHScroll(var V_Msg: TMessage);
var ok: boolean;
begin
  ok:= true;
  case V_Msg.WParam of
    sb_Top          : SetLftCol(0);
    sb_Bottom       : SetLftCol(MaxCol-ColsPerPage);
    sb_LineDown     : SetLftCol(LftCol+1);
    sb_LineUp       : SetLftCol(LftCol-1);
    sb_PageDown     : SetLftCol(LftCol+ColsPerPage);
    sb_PageUp       : SetLftCol(LftCol-ColsPerPage);
    sb_ThumbPosition: SetLftCol(integer(V_Msg.LParamLo));
    else ok:= false;
  end;
  if ok then V_Msg.Result:= 0;
end;

procedure   T_ScrollWindow.WMVScroll(var V_Msg: TMessage);
var ok: boolean;
begin
  ok:= true;
  case V_Msg.WParam of
    sb_Top          : SetCurRow(0);
    sb_Bottom       : SetCurRow(MaxRow);
    sb_LineDown     : SetCurRow(CurRow+1);
    sb_LineUp       : SetCurRow(CurRow-1);
    sb_PageDown     : SetCurRow(CurRow+RowsPerPage);
    sb_PageUp       : SetCurRow(CurRow-RowsPerPage);
    sb_ThumbPosition: SetCurRow(integer(V_Msg.LParamLo));
    else ok:= false;
  end;
  if ok then V_Msg.Result:= 0;
end;

procedure   T_ScrollWindow.WMKeyDown(var V_Msg: TMessage);
var ok: boolean;
  function CtrlKeyDown: boolean;
  begin CtrlKeyDown:= (GetKeyState(vk_Control) and $8000) <> 0; end;
begin {T_ScrollWindow.WMKeyDown}
  ok:= true;
  if CtrlKeyDown then case V_Msg.WParam of
    vk_Prior  : SetCurRow(0);
    vk_Next   : SetCurRow(MaxRow);
    vk_Left   : SetLftCol(LftCol-ColsPerPage);
    vk_Right  : SetLftCol(LftCol+ColsPerPage);
    vk_Home   : SetCurRow(TopRow);
    vk_End    : SetCurRow(TopRow+RowsPerPage);
    else ok:= false;
  end
  else case V_Msg.WParam of
    vk_Up     : SetCurRow(CurRow-1);
    vk_Down   : SetCurRow(CurRow+1);
    vk_Prior  : SetCurRow(CurRow-RowsPerPage);
    vk_Next   : SetCurRow(CurRow+RowsPerPage);
    vk_Left   : SetLftCol(LftCol-1);
    vk_Right  : SetLftCol(LftCol+1);
    vk_Home   : SetLftCol(0);
    vk_End    : SetLftCol(MaxCol-ColsPerPage);
    vk_Return : ProcessItem(CurRow);
    else ok:= false;
  end;
  if ok then V_Msg.Result:= 0;
end;

procedure   T_ScrollWindow.WMLButtonDown(var V_Msg: TMessage);
var row: integer;
begin if YtoRow(integer(V_Msg.LParamHi),row) then begin
  if not LButtonDown then begin SetCapture(HWindow); LButtonDown:= true; end;
  SetCurRow(row); V_Msg.Result:= 0;
end; end;

procedure   T_ScrollWindow.WMLButtonUp    (var V_Msg: TMessage);
begin if LButtonDown then begin
  ReleaseCapture; LButtonDown:= false; V_Msg.Result:= 0;
end; end;

procedure   T_ScrollWindow.WMMouseMove    (var V_Msg: TMessage);
var row: integer;
begin if LButtonDown and YtoRow(integer(V_Msg.LParamHi),row) then begin
  SetCurRow(row); V_Msg.Result:= 0;
end; end;

procedure   T_ScrollWindow.WMLButtonDblClk(var V_Msg: TMessage);
var row: integer;
begin if YtoRow (integer(V_Msg.LParamHi),row) then begin
  SetCurRow(row); ProcessItem(row); V_Msg.Result:= 0;
end; end;

function    T_ScrollWindow.YtoRow(V_Y: integer; var V_Row: integer): boolean;
var r: integer;
begin
  if MaxRow<0 then YToRow:= false
  else begin
    r:= V_Y div ScrnFont^.Height;
    if r<0 then r:= 0 else if r>RowsPerPage then r:= RowsPerPage;
    if TopRow+r > MaxRow then V_Row:= MaxRow else V_Row:= TopRow+r;
    YtoRow:= true;
  end;
end;


{ --- T_ListWindow --- }

Constructor T_ListWindow.Init(var V_Parent:PWindowsObject;V_Title:PChar;V_List:PCollection);
begin
  Inherited Init(V_Parent,V_Title);
  List:= nil; NewList(V_List);
end;

Destructor  T_ListWindow.Done;
begin
  NewList(nil);
  Inherited Done;
end;

Constructor T_ListWindow.Load(var V_Stream: TStream);
var InpList: PCollection;
begin
  Inherited Load(V_Stream);
  InpList:= PCollection(V_Stream.Get); List:= nil; NewList(InpList);
end;

procedure   T_ListWindow.Store(var V_Stream: TStream);
begin
  Inherited Store(V_Stream);
  V_Stream.Put(List);
end;

function    T_ListWindow.GetText(V_Row: integer): String;
begin
  if (V_Row < 0) or (V_Row >= List^.Count) then GetText:= ''
  else GetText:= PString(List^.At(V_Row))^
end;

procedure   T_ListWindow.NewList(V_List: PCollection);
begin
  if List <> nil then Dispose(List,Done);
  List:= V_List;
  if List=nil then SetMaxRow(-1) else SetMaxRow(List^.Count-1);
  TopRow:= 0; CurRow:= 0; LftCol:= 0;
  MaxCol:= -1; RowsPerPage:= 0; ColsPerPage:= 0;
  SetScrollParms;
end;

END.
