{ KEYGEN.PAS : Generate keycode declarations from keymap data

  Title   : KEYGEN
  Version : 2.3
  Date    : Jan 27,1997
  Author  : J R Ferguson
  Language: Turbo Pascal v5.0+
  Usage   : Refer procedure Help
  Remarks : Typical use : KEYGEN <KEYMAP.DAT >KEYDEF.PAS
                     or : KEYGEN <KEYMAP.DAT >KEYDEF.C   /C
                     or : KEYGEN <KEYMAP.DAT >KEYDEF.ASM /A
}

{$V-}
{$R+}

program KEYGEN;


uses DefLib, CvtLib, ArgLib, StpLib, ChrLib;

type
  LangTyp   = (Lang_A,Lang_C,Lang_P);

const
  { Option defaults: }
  DFLLANG   = Lang_P;

  MAXFNAME  = 79;
  IOBUFSIZ  = 16*1024;

  { Error codes and messages: }
  ERROK     = 0;
  ERRARG    = 1;
  ERRINP    = 2;
  ERROUT    = 3;

  ERRMSG    : array[ERRINP..ERROUT] of StpTyp =
 ('File not found : ',
  'Can''t open output : '
 );

 MAXCOL     = 1;


type
  TableTyp  = array[byte] of byte;

var
  InpFname,
  OutFname  : StpTyp;
  InpFvar,
  OutFvar   : Text;
  InpBuf,
  OutBuf    : array[1..IOBUFSIZ] of char;
  InpOpen,
  OutOpen   : boolean;
  ErrCod    : integer;
  OptLang   : LangTyp;
  Table     : TableTyp;
  Col       : integer;

{
--- Command line parsing routines ---
}


procedure Help;
begin
  writeln('KEYGEN v2.3');
  writeln('usage : KEYGEN <infile >outfile [option]');
  writeln('option: /A: generate Assembler format');
  writeln('        /C: generate C language format');
  writeln('        /P: generate Pascal format (default)');
  writeln('');
  writeln('infile line format : cc ssss xxxxxxxxxxxxx');
  writeln('                cc = keycode  (hex, 2 digits)');
  writeln('              ssss = scancode (hex, 4 digits)');
  writeln('   xxxxxxxxxxxxxxx = key name (max 12 chars)');
  writeln('');
  writeln('typical use : KEYGEN <KEYMAP.DAT >KEYDEF.PAS');
  writeln('         or : KEYGEN <KEYMAP.DAT >KEYDEF.C   /C');
  writeln('         or : KEYGEN <KEYMAP.DAT >KEYDEF.ASM /A');
end;


procedure ReadOpt(arg: StpTyp);
begin
  StpDel(arg,1,1);
  while (ErrCod=ERROK) and not StpEmpty(arg) do case ToUpper(StpcGet(arg)) of
    'A' : OptLang := Lang_A;
    'C' : OptLang := Lang_C;
    'P' : OptLang := Lang_P;
    else ErrCod:= ERRARG;
  end;
end;


procedure ReadArgs;
var i   : ArgInd;
    arg : StpTyp;
begin
  StpCreate(InpFname); StpCreate(OutFname); { Standard input/output }
  GetArgs;
  i:= 0;
  while (i < ArgC) and (ErrCod = ERROK) do begin
    Inc(i); StpCpy(arg,ArgV[i]); StpUpp(arg);
    case StpcRet(arg,1) of
      '/' : ReadOpt(arg);
      '<' : StpSub(InpFname,arg,2,MAXFNAME);
      '>' : StpSub(OutFname,arg,2,MAXFNAME);
      else  ErrCod:= ERRARG;
    end;
  end;
end;


{
--- I/O routines ---
}


procedure OpenInp;
begin
  StpNCpy(InpFname,InpFname,MAXFNAME);
  {$I-} Assign(InpFvar,InpFname); SetTextBuf(InpFvar,InpBuf); reset(InpFvar);
  {$I+} if IOresult <> 0 then ErrCod:= ERRINP else InpOpen:= true;
end;


procedure OpenOut;
begin
  StpNCpy(OutFname,OutFname,MAXFNAME);
  {$I-} Assign(OutFvar,OutFname); SetTextBuf(OutFvar,OutBuf); rewrite(OutFvar);
  {$I+} if IOresult <> 0 then ErrCod:= ERROUT else OutOpen:= true;
end;


{
--- Main line ---
}


procedure ProcessLine;
var
  Line,
  KeyStr,
  ScanStr  : StpTyp;
  KeyCode  : byte;
  ScanCode : integer;
begin
  case OptLang of
    Lang_C: {nothing};
    Lang_P:  writeln(OutFvar,'const');
  end;
  while not eof(InpFvar) do begin
    ReadLn(InpFvar,Line);
    StpGtw(KeyStr ,Line); KeyCode  := AtoIB(KeyStr,16);
    StpGtw(ScanStr,Line); ScanCode := AtoIB(ScanStr,16);
    StpRAS(Line);
    if (Line <> '') and (StpcRet(Line,1) <> '''') then case OptLang of
      Lang_A: begin
        Writeln(OutFvar,'Key', Line, '= 0':13-StpLen(Line), KeyStr, 'h');
      end;
      Lang_C: begin
        StpUpp(Line);
        Writeln(OutFvar,'#define KEY_', line, '\x':12-StpLen(Line), KeyStr);
      end;
      Lang_P: begin
        StpFill(line,' ',9);
        Write(OutFvar,' Key', Line, '=$', KeyStr, ';');
        col:= col + 1;
        if col=MAXCOL then begin writeln(OutFvar); col:= 0; end;
      end;
    end;
    if lo(ScanCode) = 0 then Table[hi(ScanCode)] := KeyCode;
  end;
end;

procedure ProcessTable;
var i,row,col,maxcol: byte; s,bolstr,prfstr,sepstr,eolstr,endstr: string[4];
begin
  writeln(OutFvar); writeln(OutFvar);
  case OptLang of
    Lang_A: begin
              writeln(OutFvar,'KeyTable:');
              bolstr:= #9'db'#9; prfstr:= '0'; sepstr:= 'h,'; eolstr:= 'h';
              endstr:= 'h'; maxcol:= 8;
            end;
    Lang_C: begin
              writeln(OutFvar,'static const char _Con_KeyTable[256] = {');
              bolstr:= '  '; prfstr:= '0x'; sepstr:= ','; eolstr:= ',';
              endstr:= '};'; maxcol:= 8;
            end;
    Lang_P: begin
              writeln(OutFvar,'const KeyTable : array[byte] of byte = (');
              bolstr:= '  '; prfstr:= '$'; sepstr:= ','; eolstr:= ',';
              endstr:= ');'; maxcol:= 16;
            end;
  end;
  row:= 1; col:= 1;
  for i:= $00 to $FF do begin
    ItoABL(Table[i], s, 16, 2);
    if col = 1 then write(OutFvar,bolstr);
    write(OutFvar,prfstr,s);
    if      i   = $FF    then writeln(OutFvar,endstr)
    else if col < maxcol then write(OutFvar,sepstr)
    else begin writeln(OutFvar,eolstr); inc(row); col:= 0; end;
    inc(col);
  end;
end;

procedure InitTable;
var i: byte;
begin
  for i:= 0 to 255 do Table[i] := $00;
end;

procedure MainInit;
begin
  InitTable; Col:= 0;
  OptLang:= DFLLANG;
  ErrCod := ERROK; InpOpen:= false; OutOpen:= false;
  ReadArgs;
  if ErrCod = ERROK then begin
    OpenInp;
    if ErrCod = ERROK then OpenOut;
  end;
end;

procedure MainExit;
begin
  if ErrCod = ERROK then ProcessTable;
  if InpOpen then Close(InpFvar);
  if OutOpen then Close(OutFvar);
  if ErrCod <> ERROK then begin
    if ErrCod=ERRARG then Help
    else begin
      write(ERRMSG[ErrCod]);
      if      ErrCod = ERRINP then write(InpFname)
      else if ErrCod = ERROUT then write(OutFname);
      writeln;
    end;
  end;
end;


begin { Main program }
  MainInit;
  if ErrCod = ERROK then ProcessLine;
  MainExit;
end.
