{ SLLTST.PAS - Test SllLib Unit

  Title    : SLLTST
  Version  : 2.1
  Date     : Nov 14,1996
  Author   : J R Ferguson
  Language : Borland Pascal v7.0 (all targets)
  Usage    : Test program
}

PROGRAM SllTst;

Uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  SllLib, DefLib, ConLib, ChrLib;

const
  MaxItem  = 10;

type
  P_TestItem = ^T_TestItem;
  P_List     = ^T_List;
  P_Stack    = ^T_Stack;
  P_OrdList  = ^T_OrdList;

  T_TestItem = record
    key: char;
    nr : integer;
    seq: integer;
  end;

  T_List     = Object(T_Sll_List)
    procedure  FreeItem(V_Item: Pointer); virtual;
  end;

  T_Stack    = Object(T_Sll_Stack)
    procedure  FreeItem(V_Item: Pointer); virtual;
  end;

  T_OrdList  = Object(T_Sll_OrdList)
    procedure  FreeItem(V_Item: Pointer); virtual;
  end;

var
  Before, After: array[1..MaxItem] of T_TestItem;
  List         : P_Sll_List;

procedure T_List.FreeItem(V_Item: Pointer);
begin dispose(P_TestItem(V_Item)); end;

procedure T_Stack.FreeItem(V_Item: Pointer);
begin dispose(P_TestItem(V_Item)); end;

procedure T_OrdList.FreeItem(V_Item: Pointer);
begin dispose(P_TestItem(V_Item)); end;

function Compare(V_Item1,V_Item2: Pointer): integer; far;
begin
  Compare:= ord(P_TestItem(V_Item1)^.key) - ord(P_TestItem(V_Item2)^.key);
end;

procedure TestInit;
var i: 1..MaxItem;
begin
  Randomize;
  for i:= 1 to MaxItem do begin
    with Before[i] do begin
      nr:= i; seq:= 0; key:= chr(ord('a') + Random(26));
    end;
    with After[i] do begin nr:= 0; seq:= 0; key:= ' '; end;
  end;
end;

procedure TestDisplay;
var i: 1..MaxItem;
begin
  writeln; writeln;
  writeln('INSERTED     RETRIEVED');
  writeln('key nr seq   key nr seq');
  writeln('--- -- ---   --- -- ---');
  for i:= 1 to MaxItem do begin
   writeln(Before[i].key:2,Before[i].nr:4,Before[i].seq:4,'   ',
           After [i].key:2,After [i].nr:4,After [i].seq:4);
  end;
  writeln('--- -- ---   --- -- ---');
end;

var Count: integer;
procedure Number(V_Item: Pointer); far;
begin
  Inc(Count); P_TestItem(V_Item)^.seq:= count;
end;

procedure TestList(V_List: P_Sll_List);
var i: 1..MaxItem; item: P_TestItem;
begin {TestList}
  TestInit;
  for i:= 1 to MaxItem do begin
    new(item); item^:= Before[i];
    List^.Insert(item);
  end;
  Count:= 0; List^.ForEach(Number);
  for i:= 1 to MaxItem do After[i]:= P_TestItem(List^.Retrieve)^;
  TestDisplay; Writeln('Empty = ',List^.Empty); Writeln; WaitCR;
end;


procedure xList;
begin
  List:= New(P_List,Init);
  TestList(List);
  Dispose(List,Done);
end;

procedure xStack;
begin
  List:= New(P_Stack,Init);
  TestList(List);
  Dispose(List,Done);
end;

procedure xOrdList;
begin
  List:= New(P_OrdList,Init(Compare));
  TestList(List);
  Dispose(List,Done);
end;

{$I SLLTSTM.PAS}

BEGIN
  slltstm;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit'); writeln;
{$ENDIF}
END.
