{ NUMTST.PAS : Test NUMLIB Unit

  Title   : NUMTST
  Version : 4.0
  Date    : Nov 11,1996
  Language: Borland Turbo Pascal 5.5 through 7.0 (all targets)
  Author  : J.R. Ferguson
  Usage   : Test program
}

program NumTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  NumLib, DefLib, ChrLib, ConLib;


var
  i, j:  integer;
  x, y:  real;


procedure wrln;  begin writeln end;
procedure wrln2; begin writeln; writeln end;


procedure rdi(prompt: StpTyp; var i: integer);      { read integer }
var err: boolean;
begin
  repeat
    write(prompt);
    {$I-} readln(i); {$I+}
    err:= IOresult <> 0;
    if err then write(chr(AsciiBEL));
  until not err;
 end;


procedure rdr(prompt: StpTyp; var x: real);         { read real }
var err: boolean;
begin
  repeat
    write(prompt);
    {$I-} readln(x); {$I+}
    err:= IOresult <> 0;
    if err then write(chr(AsciiBEL));
  until not err;
 end;


procedure rdi1;  begin wrln2; rdi('i=',i) end;
procedure rdi2;  begin wrln2; rdi('i=',i); rdi('j=',j) end;
procedure rdr1;  begin wrln2; rdr('x=',x) end;
procedure rdr2;  begin wrln2; rdr('x=',x); rdr('y=',y) end;
procedure wri1;  begin writeln('i=',i) end;
procedure wri2;  begin writeln('i=',i); writeln('j=',j) end;
procedure wrr1;  begin writeln('x=',x) end;
procedure wrr2;  begin writeln('x=',x); writeln('y=',y) end;


procedure xconst;
begin
  wrln2; wrln;
  writeln('Pi     = ',Pi);
  writeln('DblPi  = ',DblPi);
  writeln('HalfPi = ',HalfPi);
  writeln('Radian = ',Radian);
  writeln('Ln2    = ',Ln2);
  writeln('Ln10   = ',Ln10);
  wrln;
 end;


procedure xodd;    begin rdi1;writeln('odd(i)=',odd(i)) end;
procedure xeven;   begin rdi1;writeln('even(i)=',even(i)) end;

procedure xRmax;   begin rdr2;writeln('max=',Rmax(x,y)) end;
procedure xRmin;   begin rdr2;writeln('min=',Rmin(x,y)) end;
procedure xImax;   begin rdi2;writeln('max=',Imax(i,j)) end;
procedure xImin;   begin rdi2;writeln('min=',Imin(i,j)) end;

procedure xRsign;  begin rdr1;writeln('Rsign(x)=',Rsign(x)) end;
procedure xIsign;  begin rdi1;writeln('Isign(i)=',Isign(i)) end;

procedure xln;     begin rdr1;writeln('ln(x)=',ln(x)) end;
procedure xlog2;   begin rdr1;writeln('2log(x)=',log2(x)) end;
procedure xlog10;  begin rdr1;writeln('10log(x)=',log10(x)) end;
procedure xlogg;   begin rdr2;writeln('y_log x=',logg(y,x)) end;

procedure xPostInc;begin rdi1;writeln('PostInc(i)=',PostInc(i));wri1 end;
procedure xPostDec;begin rdi1;writeln('PostDec(i)=',PostDec(i));wri1 end;
procedure xPreInc; begin rdi1;writeln('PreInc(i)=',PreInc(i));wri1 end;
procedure xPreDec; begin rdi1;writeln('PreDec(i)=',PreDec(i));wri1 end;

procedure xRpowerR;begin rdr2;writeln('RpowerR(x,y)=',RpowerR(x,y)) end;
procedure xIpowerI;begin rdi2;writeln('IpowerI(i,j)=',IpowerI(i,j)) end;
procedure xRpowerI;begin rdr1;rdi1;writeln('RpowerI(x,i)=',RpowerI(x,i)) end;

procedure xrad;    begin rdr1;writeln('rad(x)=',rad(x)/Pi,' * Pi') end;
procedure xdeg;    begin rdr1;writeln('deg(x * Pi)=',deg(x*Pi)) end;

procedure xtan;    begin rdr1;writeln('tan(x * Pi)=',tan(x*Pi)) end;
procedure xcot;    begin rdr1;writeln('cot(x * Pi)=',cot(x*Pi)) end;
procedure xsec;    begin rdr1;writeln('sec(x * Pi)=',sec(x*Pi)) end;
procedure xcosec;  begin rdr1;writeln('cosec(x * Pi)=',cosec(x*Pi)) end;

procedure xArcSin; begin rdr1;writeln('ArcSin(x)=',ArcSin(x)/Pi,' * Pi') end;
procedure xArcCos; begin rdr1;writeln('ArcCos(x)=',ArcCos(x)/Pi,' * Pi') end;
procedure xArcTan; begin rdr1;writeln('ArcTan(x)=',ArcTan(x)/Pi,' * Pi') end;
procedure xArcCot; begin rdr1;writeln('ArcCot(x)=',ArcCot(x)/Pi,' * Pi') end;

procedure xsinH;   begin rdr1;writeln('sinH(x * Pi)=',sinH(x*Pi)) end;
procedure xcosH;   begin rdr1;writeln('cosH(x * Pi)=',cosH(x*Pi)) end;
procedure xtanH;   begin rdr1;writeln('tanH(x * Pi)=',tanH(x*Pi)) end;
procedure xcotH;   begin rdr1;writeln('cotH(x * Pi)=',cotH(x*Pi)) end;


{$I NUMTSTM1.PAS}
{$I NUMTSTM2.PAS}
{$I NUMTSTM3.PAS}
{$I NUMTSTM.PAS}


begin
  numtstm;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit');
  wrln;
{$ENDIF}
end.
