{ DTMTST.PAS : Test DtmLib unit

  Title    : DTMTST
  Version  : 2.1
  Date     : Nov 24,1996
  Author   : J R Ferguson
  Language : Borland Pascal 4.0 through 7.0 (all targets)
  Usage    : Test program
}


program DTMTST;

uses
{$IFDEF WINDOWS}
  WinCrt, WinDos,
{$ELSE}
  Crt, Dos,
{$ENDIF}
  DtmLib, Deflib, ConLib, ChrLib, StpLib;

var
  dt0,dt : DtmDateRec;
  days   : longint;

Function DayName(day: byte): StpTyp;
begin
  case day of
    1: DayName:= 'Monday   ';
    2: DayName:= 'Tuesday  ';
    3: DayName:= 'Wednesday';
    4: DayName:= 'Thursday ';
    5: DayName:= 'Friday   ';
    6: DayName:= 'Saturday ';
    7: DayName:= 'Sunday   ';
  else DayName:= '?????????';
  end;
end;

Function FnName(Fn: DtmFnTyp): StpTyp;
begin
  case Fn of
    DtmFnCur: FnName:= 'Cur';
    DtmFnIdf: FnName:= 'Idf';
    DtmFnJul: FnName:= 'Jul';
    DtmFnYmd: FnName:= 'Ymd';
    DtmFnCal: FnName:= 'Cal';
    else      FnName:= '???';
  end;
end;

Function RcName(Rc: DtmRcTyp): StpTyp;
begin
  case Rc of
    DtmRcOk : RcName:= 'Ok ';
    DtmRcWrn: RcName:= 'Wrn';
    DtmRcRng: RcName:= 'Rng';
    DtmRcFun: RcName:= 'Fun';
    else      RcName:= '???';
  end;
end;

procedure wrln2; begin writeln; writeln end;

procedure RdIdf;
begin with dt do begin
  writeln; write('Idf = '); ReadLn(Idf);
end end;

procedure RdJul;
begin with dt,Jul do begin
  writeln; write('Jul: Year Day = '); ReadLn(Year,Day);
end end;

procedure RdYmd;
begin with dt,Ymd do begin
  writeln; write('Ymd: Year Month Day = '); ReadLn(Year, Month, Day);
end end;

procedure RdCal;
begin with dt,Cal do begin
  writeln; write('Cal: Year Week Day = '); ReadLn(Year, Week, Day);
end end;

procedure RdDate(prompt: StpTyp);
var c: char; ok: boolean; x,y: integer;
begin with dt do begin
  writeln;
  write(prompt,': 1=Idf, 2=Jul, 3=Ymd, 4=Cal, 5=Cur    [');
  x:= WhereX; y:= WhereY; write(' ]'); GotoXY(x,y);
  repeat
    c:= Key; ok:= (c >= '1') and (c <= '5');
    if ok then begin
      write(c);
      case c of
        '1': begin fn:= DtmFnIdf; RdIdf; end;
        '2': begin fn:= DtmFnJul; RdJul; end;
        '3': begin fn:= DtmFnYmd; RdYmd; end;
        '4': begin fn:= DtmFnCal; RdCal; end;
        '5': begin fn:= DtmFnCur;        end;
      end
    end
    else begin write(#7); GotoXY(x,y); write(' '); GotoXY(x,y); end;
  until ok;
end end;

procedure RdDays;
begin write('Number of days : '); readln(days); end;

procedure Wr1DateRec(var dt: DtmDateRec);
begin with dt do begin
  writeln;
  writeln('RC  = ',RcName(Rc));
  writeln('IDF = ',Idf);
  with Jul do writeln('JUL = ',Year,' ',Day);
  with Ymd do writeln('YMD = ',Year,' ',Month,' ',Day);
  with Cal do writeln('CAL = ',Year,' ',Week,' ',Day,' ',DayName(Day));
end end;

procedure Wr2DateRec(var dt1, dt2: DtmDateRec);
begin
  Wr1DateRec(dt1);
  Wr1DateRec(dt2);
  writeln;
end;

{$I DTMTST1.PAS   }
{$I DTMTST2.PAS   }
{$I DTMTST3.PAS   }

{$I DTMTSTM1.PAS  }
{$I DTMTSTM2.PAS  }
{$I DTMTSTM.PAS   }

begin
  DTMTSTM;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  wrln2; writeln('Exit');
{$ENDIF}
end.
