{ CONTST.PAS : Test CONLIB unit

  Title   : CONTST
  Version : 4.1
  Date    : Jan 29,1997
  Author  : J R Ferguson
  Language: Turbo Pascal v4.0+ (all targets)
  Usage   : Test program 
}

PROGRAM CONTST;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  ConLib, DefLib, ChrLib, NioLib;


{--- General routines ---}

procedure WrLn2; begin writeln; writeln end;

procedure ShowKey(c: char);
var n: byte;
begin
  n:= ord(c);
  obuns(n,10,3); write('d  '); obuhex(n); write('h');
  if (n>31) and (n<>127) then writeln('  ',c) else writeln;
end;


procedure FillScreen;
const
 l: ColStp =
 '.v....1....v....2....v....3....v....4....v....5....v....6....v....7....v.';
var
 r: RowInd;
begin
  ClrScr;
  for r:= 1 to MAXROW-2 do writeln(r:2,' ',l,' ',r:2);
end;


{--- Test routines ---}

procedure xTstEnhKbd;
begin
  WrLn2;
  writeln('TstEnhKbd = ',TstEnhKbd);
  writeln;
end;

procedure xSetCur;
var r: RowInd; c: ColInd; dummy: char;
begin
  FillScreen;
  write('Row Column: '); read(r,c);
  SetCur(r,c); write('*');
  dummy:= Key;
end;

procedure xKey;
var c: char;
begin
  WrLn2;
  write('Press a key: ');
  ShowKey(Key);
  writeln;
end;

procedure xUppKey;
var c: char;
begin
  WrLn2;
  write('Press a key: ');
  ShowKey(UppKey);
  writeln;
end;

procedure xYesNo;
var prompt: ColStp;
begin
  WrLn2;
  write('Prompt: '); readln(prompt);
  writeln(YesNo(prompt));
  writeln;
end;

procedure xJaNee;
var prompt: ColStp;
begin
  WrLn2;
  write('Prompt : '); readln(prompt);
  writeln(JaNee(prompt));
  writeln;
end;

procedure xWaitCR;
begin
  WrLn2;
  WaitCR;
  writeln;  
end;

procedure xMessage;
var msg: ColStp;
begin
  WrLn2;
  write('Message : '); readln(msg);
  write('pre[');
  message(msg);
  writeln(']post');
  writeln;
end;


{--- Menu and main program ---}

{$I CONTSTM.PAS}

BEGIN
  contstm;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  WrLn2;
{$ENDIF}
END.
