{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Text.pas                 [x] Protected mode

  This program demonstrates how you the common file stream can be
  used to process text files.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFFILE;


const BufferSize  = 1000; { Buffer size for the data stream }

var TextFile : tIFile; Text : string;


begin
     { Initialize buffered file stream }
     TextFile.Initialize ('..\hamlet.dat', BufferSize);
                          { Filename }     { Buffer size in bytes }

     while not TextFile.IsEnd do begin

           { Read text words from the stream until
             EOL sequence occurr. Then display the
             line on the screen. }

           Text := TextFile.GetString (' '); { Blank space = delimeter }
           WriteLn (Text);

      end;

      TextFile.Intercept; { Intercept stream }
end.