{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/List5.pas         [x] Protected mode

  How to handle a large linked list (either huge element data or
  many small elements). This example also shows how Capacity and
  IsFree can use to (i) estimate the number of elements that an
  ADT can hold and (ii) guarantee if another element can be stored
  inside the ADT.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFLIST;


const Storage = 16000;

var List : tList;
    MaximumStorage : pointer; Count : word;
    MaximumCapacity, StartMem : longint;

begin
     StartMem := MemAvail;

     GetMem (MaximumStorage, Storage);

     { Test the structures capacity }
     with List do begin

          Initialize (Storage);

          { Estimate the element capacity }
          MaximumCapacity := Capacity;
          { Count elements instead of calling the slow Elements method: }
          Count := 0;

          while IsFree do begin

                { Write current status. }
                Write ('Capacity for another ', MaximumCapacity - Count, ' element(s)');
                Store ( MaximumStorage^ ); Inc (Count);
                WriteLn ('.');

          end;

          WriteLn;
          WriteLn ('We used ', ((StartMem - MemAvail) / StartMem) * 100:0:2, '% of system memory. ');
          WriteLn;
          Clear;

          WriteLn ('Notice that the estimation can differ from the actual');
          WriteLn ('storage capacity since the heap get fragmented. For');
          WriteLn ('more accuracy, estimate the capacity several times.');

          Intercept;
     end;

     FreeMem (MaximumStorage, Storage);

     if MemAvail <> StartMem then WriteLn ('Memory failure.');
end.