/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* video.h  -  header file for VIDEO.C - screen output routines */

#ifndef VIDEO_HEADER
#define VIDEO_HEADER    1

#include <howard.h>
#ifndef __VIDEO             /* can't check conio.h again, redefine #defines => errors */
#include <conio.h>          /* struct text_info */
#endif

/*  Remember, when #including files, <conio.h> MUST come before <video.h> */

#define VIDEO     0x10           /* VIDEO INTerrupt service = 16 (HEX 10) */
#define MODE      *((byte far *) 0x449lu)          /* current video mode */
#define PAGE      *((byte far *) 0x462lu)          /* current display page */
#define PAGELEN   *((unsigned int far *) 0x44Clu)  /* current page length (regen buffer) */
#define VIDOFFSET *((unsigned int far *) 0x44Elu)  /* offset from start of video */
#define ROWCOUNT  *((byte far *) 0x484lu)          /* # rows minus 1 on display (EGA,PGA) */
#define CHARHEIGHT *((unsigned int far *) 0x485lu) /* character height: # bytes/char, # scan lines/char (EGA,PGA) */
#define CURSOR_UNDERBAR   (MODE==7)?0x0B0C:0x0607  /* cursor type: underbar (default) */
#define CURSOR_HALFBLOCK  (MODE==7)?0x070C:0x0407  /* cursor type: half-block */

/* Global variables */
/* These have already been defined, they are just listed here for your
   reference. Do not uncomment these variables.

   char frame1[11] = {'','','','','','','','','\0','',''};
   char frame11[5] = {'','','','',''};
   char frame12[6] = {'','','','','',''};
   char frame2[11] = {'','','','','','','','','\0','',''};
   char frame21[6] = {'','','','','',''};
   char frame22[5] = {'','','','',''};
   char frame0[11] = {' ',' ',' ',' ',' ',' ',' ',' ','\0',' ',' '};
   char framebox[11] = { '','','','','','','','','\0','','' };
   const char emptystring[] = "               ";     /* 15 spaces */
                                                                            */

/* Shadow definitions */
#define SHADOW_TL   0x0080              /* shadow top left corner */
#define SHADOW_T    0x0040              /* shadow top side */
#define SHADOW_TR   0x0020              /* shadow top right corner */
#define SHADOW_R    0x0010              /* shadow right side */
#define SHADOW_BR   0x0008              /* shadow bottom right corner */
#define SHADOW_B    0x0004              /* shadow bottom side */
#define SHADOW_BL   0x0002              /* shadow bottom left corner */
#define SHADOW_L    0x0001              /* shadow left side */

#define SHADOW_TOP      (SHADOW_TL|SHADOW_T|SHADOW_TR)  /* shadow on top row */
#define SHADOW_BOTTOM   (SHADOW_BL|SHADOW_B|SHADOW_BR)  /* shadow on bottom row */
#define SHADOW_LEFT     (SHADOW_TL|SHADOW_L|SHADOW_BL)  /* shadow on left column */
#define SHADOW_RIGHT    (SHADOW_TR|SHADOW_R|SHADOW_BR)  /* shadow on right column */

/* video info */
int center(char *str);              /* @ row,center() SAY ... */
boolean isCGA(void);
boolean isEGA(void);
boolean isHerc(void);
boolean isMDA(void);
byte read_attrib(void);             /* read attribute at cursor */
byte read_char(void);               /* read character at cursor */
void settextinfo(struct text_info *inforec);    /* set TC info according to inforec */
byte whatxy(byte *attrib);          /* read character/attribute at cursor */

/* video mode */
void read_mode(byte *width, byte *mode, byte *page);
void set_mode(byte mode);

/* line drawing */
int box(int left, int top, int right, int bottom, char frame[]);
void shadow(int left, int top, int right, int bottom, char frame[]);
void horiz_line(byte c, int len, int col, int row);     /* does not update cursor */
void vert_line(byte c, int len, int col, int row);      /* updates cursor */
int boxwindow(int left, int top, int right, int bottom, char frame[],
              char *title, int titlejustify, char colborder, char coltitle,
              char colnorm, char *buffer);

/* output */
void putk(byte c);                          /* output 1 char w/attrib, BIOS */
void putsay(int col, int row, byte *c);     /* direct screen writes */
void putstr(byte *c);                       /* INTerrupt output */

/* text manipulation */
void gotohv(int horiz, int vert);           /* goto x,y, absolute, not limited by TC 1.5 */
int whereh(void);                           /* wherex(), absolute, not limited by TC 1.5 */
int wherev(void);                           /* wherey(), absolute, not limited by TC 1.5 */
void clear(int left, int top, int right, int bottom);
void scroll_up(int left, int top, int right, int bottom);
void scroll_down(int left, int top, int right, int bottom);

/* cursor control */
void cursor_blink(boolean fast);
void cursor_flip(unsigned int curs1, unsigned int curs2);   /* toggle cursor type */
void cursor_off(void);
void cursor_on(void);
unsigned int read_cursor(int *col, int *row);  /* returns CX reg, scan lines */
unsigned int getcursor(void);                  /* returns cursor scan lines */
void setcursor(unsigned int cursor);           /* set cursor scan lines */

/* tchk video control */
void set_color(byte colors);

/* Compaq Portable Extensions */
unsigned char CompaqGetMonitor(void);               /* Get active monitor (internal/external) */
void CompaqSelectMonitor(boolean internal);         /* Select active monitor (internal/external) */
unsigned char CompaqGetMasterMode(void);            /* Get master mode of current controller */
void CompaqSetMasterMode(unsigned char mastermode); /* Set master mode of current controller */
unsigned char CompaqInternalMonitorType(void);      /* Internal monitor type */
unsigned char CompaqExternalMonitorType(void);      /* External monitor type */
void CompaqModeSwitchDelay(boolean enable);         /* Set mode switch delay */


#define ismono()            isMDA()|isHerc()
#define iscolor()           !ismono()
#define scrbuff(l,t,r,b)    (b-t+1)*(r-l+1)*2   /* # rows * # cols * 2 */
#define cls()               clrscr()            /* I prefer cls() to clrscr() */
#define color(f,b)          (f|(b<<4))          /* fore/back ground color */
#define set_cursor(h,l)     setcursor(h|l)      /* high and low scan lines */
/*#define gotoxy(x,y)         gotohv(x,y)       uncomment this for my gotoxy(), see docs */

#endif              /* VIDEO_HEADER */
