
/* simpwin9 Copyright 1995 - 1997 Bruce R. O'Banion */

# include <string.h>
# include <stdio.h>
# include <conio.h>
# include <process.h>
# include <dos.h>
# include <io.h>
# include <stdarg.h>
# include <mem.h>
# include <sys\stat.h>
# include <bios.h>
# include <alloc.h>
# include <stdlib.h>
# include <dir.h>
# include <ctype.h>

# include "skdef92.h"
# include "simpwn92.h"

typedef struct
{
	int old[14];
	int new[14];
} WINDOW_DATA;
struct text_info initial_info;
WINDOW_DATA window_data,temp_data,window_temp;
char path_name[255],screen_path[255];
char far *video_buff;
char far *buff_2;
char far *screen_buff;
FILE *t_fp;
unsigned long int popups,screens;
int dev_error;
int mou_installed = 0;
struct ffblk dir_data;


int handler(int errval,int ax,int bp,int si);
int error_write(FILE *err_fp);
int save_window_data(int file);
int load_window_data(int file);

int simp_window(int l,int t,int r,int b,int boarder,int shad,int forground,int background,int shade_locate,int shade_fore,int shade_back,int boarder_char,int fill_char)
{
	int i,j,col_start,col_end,tl,tr,bl,br,rt,cs,at,end_for,start_for;


	window_data.new[0] = l;
	window_data.new[1] = t;
	window_data.new[2] = r;
	window_data.new[3] = b;
	window_data.new[4] = boarder;
	window_data.new[5] = shad;
	window_data.new[6] = forground;
	window_data.new[7] = background;
	window_data.new[8] = shade_locate;
	window_data.new[9] = shade_fore;
	window_data.new[10] = shade_back;
	window_data.new[11] = boarder_char;
	window_data.new[12] = fill_char;
	window(l,t,r,b);
	textattr(forground + (background<<4));
	col_start = ((l - 1) * 2);
	col_end = (r * 2);
	end_for = col_end;
	start_for = col_start;
	at = (forground + (background<<4));
	tr = 0x00;
	tl = 0x00;
	bl = 0x00;
	br = 0x00;
	rt = 0x00;
	cs = 0x00;
	if(boarder == 1)
	{
		tl = 0xda;
		tr = 0xbf;
		bl = 0xc0;
		br = 0xd9;
		rt = 0xc4;
		cs = 0xb3;
	}
	if(boarder == 2)
	{
		tl = 0xc9;
		tr = 0xbb;
		bl = 0xc8;
		br = 0xbc;
		rt = 0xcd;
		cs = 0xba;
	}
	if(boarder == 3)
	{
		tl = 0xd6;
		tr = 0xb7;
		bl = 0xd3;
		br = 0xbd;
		rt = 0xc4;
		cs = 0xba;
	}
	if(boarder == 4)
	{
		tl = 0xd5;
		tr = 0xb8;
		bl = 0xd4;
		br = 0xbe;
		rt = 0xcd;
		cs = 0xb3;
	}
	if(boarder == 5)
	{
		tl = boarder_char;
		tr = boarder_char;
		bl = boarder_char;
		br = boarder_char;
		rt = boarder_char;
		cs = boarder_char;
	}
	if((shade_locate < 1) & (shade_locate > 4))
	{
		shade_locate = 1;
	}
	pokeb(0xb800,col_start + ((t - 1) * 160),tl);
	pokeb(0xb800,col_start + 1 + ((t - 1) * 160),at);
	for(i = col_start + 2;i < col_end - 2;i = i + 2)
	{
		pokeb(0xb800,i + ((t - 1) * 160),rt);
		pokeb(0xb800,i + 1 + ((t - 1) * 160),at);
	}
	pokeb(0xb800,col_end - 2 + ((t - 1) * 160),tr);
	pokeb(0xb800,col_end - 1 + ((t - 1) * 160),at);
	pokeb(0xb800,col_start + ((b - 1) * 160),bl);
	pokeb(0xb800,col_start + ((b - 1) * 160) + 1,at);
	for(i = col_start + 2 + ((b - 1) * 160);i < col_end - 2 + ((b - 1) * 160);i = i + 2)
	{
		pokeb(0xb800,i,rt);
		pokeb(0xb800,i + 1,at);
	}
	pokeb(0xb800,col_end - 2 + ((b - 1) * 160),br);
	pokeb(0xb800,col_end - 1 + ((b - 1) * 160),at);
	for(i = t;i < b - 1;i++)
	{
		pokeb(0xb800,col_start + (i * 160),cs);
		pokeb(0xb800,col_end - 2 + (i * 160),cs);
		pokeb(0xb800,col_start + 1 + (i * 160),at);
		pokeb(0xb800,col_end - 1 + (i * 160),at);
	}
	for(i = t;i < (b - 1);i++)
	{
		for(j = col_start + 2;j < col_end - 2;j = j + 2)
		{
			pokeb(0xb800,j + (i * 160),fill_char);
			pokeb(0xb800,j + 1 + (i * 160),at);
		}
	}
	if((shad > 0) & (shad < 3))
	{
		if((shade_locate == 1) | (shade_locate == 2))
		{
			if(shad == 2)
			{
				end_for = col_end + 2;
			}
		}
		else
		{
			if(shad == 2)
			{
				start_for = col_start - 2;
			}
		}
		if((shade_locate == 1) | (shade_locate == 3))
		{
			for(i = t;i < b + 1;i++)
			{
				if(shade_locate == 1)
				{
					if(shad == 1)
					{
						pokeb(0xb800,col_start - 3 + (i * 160),shade_fore + (shade_back<<4));
					}
					pokeb(0xb800,col_start - 1 + (i * 160),shade_fore + (shade_back<<4));
				}
				else
				{
					if(shad == 1)
					{
						pokeb(0xb800,col_end + 3 + (i * 160),shade_fore + (shade_back<<4));
					}
					pokeb(0xb800,col_end + 1 + (i * 160),shade_fore + (shade_back<<4));
				}
			}
			for(i = start_for;i < end_for - 4;i = i + 2)
			{
				if(shade_locate == 1)
				{
					pokeb(0xb800,i + 1 + (b * 160),shade_fore + (shade_back<<4));
				}
				else
				{
					pokeb(0xb800,i + 5 + (b * 160),shade_fore + (shade_back<<4));
				}
			}
		}
		if((shade_locate == 2) | (shade_locate == 4))
		{
			for(i = t - 2;i < b - 1;i++)
			{
				if(shade_locate == 2)
				{
					if(shad == 1)
					{
						pokeb(0xb800,col_start - 3 + (i * 160),shade_fore + (shade_back<<4));
					}
					pokeb(0xb800,col_start - 1 + (i * 160),shade_fore + (shade_back<<4));
				}
				else
				{
					if(shad == 1)
					{
						pokeb(0xb800,col_end + 3 + (i * 160),shade_fore + (shade_back<<4));
					}
					pokeb(0xb800,col_end + 1 + (i * 160),shade_fore + (shade_back<<4));
				}
			}
			for(i = start_for;i < end_for - 4;i = i + 2)
			{
				if(shade_locate == 2)
				{
					pokeb(0xb800,i + 1 + ((t - 2) * 160),shade_fore + (shade_back<<4));
				}
				else
				{
					pokeb(0xb800,i + 5 + ((t - 2) * 160),shade_fore + (shade_back<<4));
				}
			}
		}
	}
	return(0);
}

int popup_window(int number,int l,int t,int r,int b,int boarder,int shad,int forground,int background,int shade_locate,int shade_fore,int shade_back,int boarder_char,int fill_char)
{
	int i;

	for(i = 0;i < 14;i++)
	{
		window_data.old[i] = window_data.new[i];
	}
	window_data.new[0] = l;
	window_data.new[1] = t;
	window_data.new[2] = r;
	window_data.new[3] = b;
	window_data.new[4] = boarder;
	window_data.new[5] = shad;
	window_data.new[6] = forground;
	window_data.new[7] = background;
	window_data.new[8] = shade_locate;
	window_data.new[9] = shade_fore;
	window_data.new[10] = shade_back;
	window_data.new[11] = boarder_char;
	window_data.new[12] = fill_char;
	window_data.new[13] = number;
	save_window_data(number);
	simp_window(l,t,r,b,boarder,shad,forground,background,shade_locate,shade_fore,shade_back,boarder_char,fill_char);
	return(0);
}


int unpopup_window(int number)
{
	int i;

	if(load_window_data(number) != 0)
	{
		return(1);
	}
	for(i = 0;i < 14;i++)
	{
		window_data.new[i] = window_data.old[i];
	}
	textattr(window_data.new[6] + (window_data.new[7]<<4));
	window((window_data.new[0]),(window_data.new[1]),(window_data.new[2]),(window_data.new[3]));
	return(0);
}

int init_window(int num_popup,int screen_num,char *drive)
{
	unsigned long int size_block = 4056,free_space,convert = 1.0,num_file;
	struct dfree space;
	int i,drive_num,handle;
	FILE init_fp;
	char cur_dir[80];
	char *buff;

	if((buff = (char*)malloc(4096)) == NULL)
	{
		return(1);
	}
	memset(buff,0,4096);
	harderr(handler);
	video_buff = MK_FP(0xb800,0x0000);
	screen_buff = MK_FP(0xb900,0x0000);
	buff_2 = MK_FP(0xba00,0x0000);
	t_fp = &init_fp;
	popups = num_popup + 1;
	screens = screen_num + 1;
	num_file = popups + screens;

	switch(drive[0])
	{
		case 'a' :
		case 'A' : drive_num = 1; break;
		case 'b' :
		case 'B' : drive_num = 2; break;
		case 'c' :
		case 'C' : drive_num = 3; break;
		case 'd' :
		case 'D' : drive_num = 4; break;
		case 'e' :
		case 'E' : drive_num = 5; break;
		case 'f' :
		case 'F' : drive_num = 6; break;
		case 'g' :
		case 'G' : drive_num = 7; break;
		default : drive_num = getdisk() + 1; break;
	}
	getdfree(drive_num,&space);
	free_space = convert * space.df_avail * space.df_bsec * space.df_sclus / size_block;
	if(num_file > free_space)
	{
		free(buff);
		return(1);
	}
	strupr(drive);
	if((strcmp(drive,"G") <= 0) & (strcmp(drive,"A") >= 0) & (getdisk() + 1 != drive_num))
	{
		strcat(drive,":");
		strcpy(path_name,drive);
		strcpy(screen_path,drive);
	}
	else
	{
		getcwd(cur_dir,79);
		i = strlen(cur_dir);
		if(cur_dir[i - 1] == '\\')
		{
			cur_dir[i - 1] = '';
		}
		strcpy(path_name,cur_dir);
		strcpy(screen_path,cur_dir);
	}
	strcat(path_name,"\\win.dat");
	strcat(screen_path,"\\screen.dat");
	handle = creat(path_name,S_IREAD|S_IWRITE);
	close(handle);
	if((t_fp = fopen(path_name,"r+b")) == NULL)
	{
		free(buff);
		return(1);
	}
	for(i = 0;i <= num_popup;i++)
	{
		if(fwrite(buff,sizeof(char) * 4056,1,t_fp) != 1)
		{
			fclose(t_fp);
			free(buff);
			return(1);
		}
	}

	fclose(t_fp);
	handle = creat(screen_path,S_IREAD|S_IWRITE);
	close(handle);
	if((t_fp = fopen(screen_path,"r+b")) == NULL)
	{
		free(buff);
		return(1);
	}
	for(i = 0;i <= screen_num;i++)
	{
		if(fwrite(buff,sizeof(char) * 4056,1,t_fp) != 1)
		{
			fclose(t_fp);
			free(buff);
			return(1);
		}
	}
	fclose(t_fp);
	free(buff);
	return(0);
}

void uninit_window()
{
	remove(path_name);
	remove(screen_path);
}

int load_window_data(int file)
{
	unsigned long int block = 4056;
	int i;

	if(read_file(video_buff,path_name,4056,block * file) != 0)
	{
		return(1);
	}
	for(i = 0;i < 14;i++)
	{
		window_data.new[i] = peek(0xb800,4001 + (i * 2));
		window_data.old[i] = peek(0xb800,4027 + (i * 2));
	}
	return(0);
}

int save_window_data(int file)
{
	unsigned long int block = 4056;
	int i;

	for(i = 0;i < 14;i++)
	{
		poke(0xb800,4001 + (i * 2),window_data.new[i]);
		poke(0xb800,4027 + (i * 2),window_data.old[i]);
	}
	if(write_file(video_buff,path_name,4056,block * file) != 0)
	{
		return(1);
	}
	return(0);
}

int write_window(int x,int y,char *format,...)
{
	va_list ap;
	char * buff;

	if((buff = (char*)malloc(81)) == NULL)
	{
		return(1);
	}
	memset(buff,0,81);
	va_start(ap,format);
	vsprintf(buff,format,ap);
	va_end(ap);
	gotoxy(x,y);
	cprintf("%s",buff);
	free(buff);
	return(0);
}

int clear_window(int fill_char)
{
	int i,j,addr;

	gettextinfo(&initial_info);
	for(i = initial_info.wintop;i < initial_info.winbottom - 1;i++)
	{
		for(j = initial_info.winleft;j < initial_info.winright - 1;j++)
		{
			addr = (i * 160) + (j * 2);
			pokeb(0xb800,addr,fill_char);
			pokeb(0xb800,addr + 1,window_data.new[6] + (window_data.new[7]<<4));
		}
	}
	return(0);
}

int save_screen(int screen_num)
{
	unsigned long int block;

	if(screen_num == 0)
	{
		movedata(0xb800,0x0000,0xb900,0x0000,4000);
		window_temp = window_data;
	}
	else
	{
		block = 4000 + sizeof(WINDOW_DATA);
		if(write_file(video_buff,screen_path,4000,block * screen_num) != 0)
		{
			return(1);
		}
		if(write_file(&window_data,screen_path,sizeof(WINDOW_DATA),(block * screen_num) + 4000) != 0)
		{
			return(1);
		}
	}
	return(0);
}

int load_screen(int screen_num)
{
	unsigned long int block;

	if(screen_num == 0)
	{
		movedata(0xb900,0x0000,0xb800,0x0000,4000);
		window_data = window_temp;
		textattr(window_data.new[6] + (window_data.new[7]<<4));
		window(window_data.new[0],window_data.new[1],window_data.new[2],window_data.new[3]);
	}
	else
	{
		block = 4000 + sizeof(WINDOW_DATA);
		if(read_file(video_buff,screen_path,4000,block * screen_num) != 0)
		{
			return(1);
		}
		if(read_file(&window_data,screen_path,sizeof(WINDOW_DATA),(block * screen_num) + 4000) != 0)
		{
			return(1);
		}
		textattr(window_data.new[6] + (window_data.new[7]<<4));
		window(window_data.new[0],window_data.new[1],window_data.new[2],window_data.new[3]);
	}
	return(0);
}
int get_string(char *enter_string,char *mask,char *format,int x,int y,int strip,int default_dis)
{
	int enter_data[81],i = 0,erase = 0,mask_on = 0,j,temp_data = 0,valid_key;
	int size_data,temp_i,search,first_key,bios_pick;
	char temp_string[81];
	char temp_char[2];

	for(i = 0;i < strlen(format);i++)
	{
		switch(format[i])
		{
			case 'A' : break;
			case '*' : break;
			case 'U' : break;
			case 'u' : break;
			case 'L' : break;
			case 'l' : break;
			case 'F' : break;
			case 'e' : break;
			case '#' : break;
			case '9' : break;
			case 'h' : break;
			case 'o' : break;
			case 'Y' : break;
			case 'T' : break;
			case ' ' : break;
		}
	}
	size_data = strlen(mask);
	for(i = 0;i < 81;i++)
	{
		enter_data[i] = 0;
	}
	strcpy(temp_char,"");
	strcpy(temp_string,"");
	for(i = 0;i < size_data;i++)
	{
		if(format[i] == ' ')
		{
			mask_on = 1;
		}
	}
	if((default_dis == 1) & (strlen(enter_string) <= size_data))
	{
		gotoxy(x,y);
		cprintf("%s",enter_string);
	}
	else if(mask_on == 1)
	{
		gotoxy(x,y);
		cprintf("%s",mask);
	}
	else
	{
		default_dis = 0;
	}
	first_key = 1;
	for(i = 0;i < size_data + 1;i++)
	{
		if(i < 0)
		{
			gotoxy(x,y);
			putch(0x00);
			i = 0;
		}
		temp_i = i;
		if(i < size_data)
		{
			search = 1;
			while(format[i] == ' ')
			{
				if(erase != 1)
				{
					i = i + 1;
					temp_i = temp_i + 1;
				}
				else if(i != 0)
				{
					if(search == 1)
					{
						i = i - 1;
						temp_i = temp_i - 1;
					}
					else
					{
						i = i + 1;
						temp_i = temp_i + 1;
					}
				}
				else
				{
					i = 1;
					temp_i = 1;
					search = 0;
				}
				if(i == size_data)
				{
					break;
				}
			}
			if(i == size_data)
			{
				i = i - 1;
				search = 3;
				while(format[i] == ' ')
				{
					i = i - 1;
				}
				temp_i = i + 1;
			}
			if(erase == 1)
			{
				gotoxy(x + i,y);
				enter_data[i] = 0x00;
				putch(0x00);
			}
		}
		erase = 0;
		if(i <= size_data)
		{
			if((first_key == 1) & (default_dis == 1))
			{
				i = strlen(enter_string);
				temp_i = i;
				for(j = 0;j < i;j++)
				{
					memmove(&enter_data[j],&enter_string[j],1);
				}
			}
			if(i == size_data)
			{
				i = i - 1;
			}
			gotoxy(x + i,y);
			bios_pick = bioskey(0);
			memmove(&temp_data,&bios_pick,1);
			if((temp_data != 13) & (temp_data != 8) & (first_key == 1))
			{
				i = 0;
				temp_i = i;
				for(j = i;j < size_data;j++)
				{
					gotoxy(x + j,y);
					putch(0x00);
					enter_data[j] = 0;
				}
				if(mask_on == 1)
				{
					gotoxy(x,y);
					cprintf("%s",mask);
				}
			}
			first_key = 0;
			valid_key = 1;
			switch(format[i])
			{
				case 'A' :
				case 'u' :
				case 'l' : if((format[i] == 'u') & (temp_data > 96) & (temp_data < 123))
								{
						temp_data = temp_data - 32;
								}
								if((format[i] == 'l') & (temp_data > 64) & (temp_data < 91))
								{
						temp_data = temp_data + 32;
								}
								if(isalnum(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 27 : i = 100; break;
							case 32 : break;
							case 13 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case 'U' : if(isupper(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 27 : i = 100; break;
							case 13 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case 'L' : if(islower(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 27 : i = 100; break;
							case 13 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case 'e' : if(isdigit(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 43 : break;
							case 45 : break;
							case 46 : break;
							case 69 : break;
							case 101 : break;
							case 13 : i = 100; break;
							case 27 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case '9' : if(isdigit(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 13 : i = 100; break;
							case 27 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case 'F' : if(isdigit(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 45 : break;
							case 46 : break;
							case 13 : i = 100; break;
							case 27 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case '#' : if(isdigit(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 45 : break;
							case 13 : i = 100; break;
							case 27 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case 'o' : if((isdigit(temp_data)) & (temp_data != 56) &
						(temp_data != 57))
								{
						switch(temp_data)
						{
							case 45 : break;
							case 13 : i = 100; break;
							case 27 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case 'h' : if(isxdigit(temp_data) == 0)
								{
						switch(temp_data)
						{
							case 45 : break;
							case 13 : i = 100; break;
							case 27 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				case 'Y' : switch(temp_data)
								{
						case 89 : break;
						case 78 : break;
						case 121 : break;
						case 110 : break;
						case 13 : i = 100; break;
						case 27 : i = 100; break;
						case 8 : erase = 1;
								valid_key = 0; break;
						default : erase = 2;
									valid_key = 0; break;
								}
								break;
				case 'T' : switch(temp_data)
								{
						case 70 : break;
						case 84 : break;
						case 102 : break;
						case 116 : break;
						case 13 : i = 100; break;
						case 27 : i = 100; break;
						case 8 : erase = 1;
								valid_key = 0; break;
						default : erase = 2;
									valid_key = 0; break;
								}
								break;
				case '*' : if((temp_data < 35) | (temp_data > 125))
								{
						switch(temp_data)
						{
							case 32 : break;
							case 33 : break;
							case 13 : i = 100; break;
							case 27 : i = 100; break;
							case 8 : erase = 1;
									valid_key = 0; break;
							default : erase = 2;
										valid_key = 0; break;
						}
								}
								break;
				default : if(temp_data == 13)
							{
						i = 100;
							}
							else if(temp_data == 8)
							{
						erase = 1;
						valid_key = 0;
							}
			}
		}
		if(i != 100)
		{
			i = temp_i;
		}
		else
		{
			if(search == 3)
			{
				enter_data[size_data] = temp_data;
			}
			else
			{
				enter_data[temp_i] = temp_data;
			}
			valid_key = 2;
		}
		if(valid_key == 1)
		{
			if((temp_i < size_data) & (search != 3))
			{
				gotoxy(x + temp_i,y);
				putch(temp_data);
				enter_data[temp_i] = temp_data;
			}
			if((temp_i == size_data) | (search == 3))
			{
				gotoxy(x + temp_i - 1,y);
				putch(temp_data);
				enter_data[temp_i - 1] = temp_data;
				i = i - 1;
			}
			valid_key = 0;
		}
		if(erase == 1)
		{
			if(mask_on == 0)
			{
				gotoxy(x + i - 1,y);
				enter_data[i - 1] = 0x00;
				putch(0x00);
				gotoxy(x + i,y);
				enter_data[i] = 0x00;
				putch(0x00);
			}
			else
			{
				gotoxy(x + i,y);
				enter_data[i] = 0x00;
				putch(0x00);
			}
			i = i - 2;
		}
		if(erase == 2)
		{
			i = i - 1;
		}
	}
	if(enter_data[0] == 13)
	{
		gotoxy(x,y);
		cprintf("%s",enter_string);
		return(0);
	}
	i = 0;
	while((enter_data[i] != 13) & (enter_data[i] != 27))
	{
		if(i < size_data)
		{
			if(strip == 1)
			{
				if(format[i] == ' ')
				{
					i = i + 1;
				}
			}
			else
			{
				if(format[i] == ' ')
				{
					temp_char[0] = mask[i];
					temp_char[1] = NULL;
					strcat(temp_string,temp_char);
					i = i + 1;
				}
			}
			if((format[i] != ' ') & (i < size_data))
			{
				if((enter_data[i] > 31) & (enter_data[i] < 127))
				{
					temp_char[0] = enter_data[i];
					temp_char[1] = NULL;
					strcat(temp_string,temp_char);
				}
				i = i + 1;
			}
		}
	}
	if(enter_data[i] == 27)
	{
		return(1);
	}
	if(temp_string[0] != NULL)
	{
		strcpy(enter_string,temp_string);
	}
	return(0);
}

void show_cursor(void)
{
	_CH = 0x06;
	_CL = 0x07;
	_AH = 0x01;
	geninterrupt(0x10);
}

void hide_cursor(void)
{
	_CH = 0x10;
	_CL = 0x00;
	_AH = 0x01;
	geninterrupt(0x10);
}

int read_text(char *file_name,int wrap)
{
	int i,done = 0,error_check,x = 3,y = 2,page = 1,eof,block = 2000,set = 0;
	long int start_byte = 0L;

	gettextinfo(&initial_info);
	eof = 0;
	while(done == 0)
	{
		if(page != 0)
		{
			clear_window(0);
			for(i = 0;i < 2000;i++)
			{
				pokeb(0xba00,i,0x00);
			}
			error_check = read_file(buff_2,file_name,2000,start_byte);
			switch(error_check)
			{
				case 0 : eof = 0; break;
				case -1 : eof = 1; break;
				default : return(error_check);
			}
			if(page == 1)
			{
				for(i = set;i < 2000;i++)
				{
					if(peekb(0xba00,i) == 0x09)
					{
						pokeb(0xba00,i,0x20);
					}
					if(wrap == 1)
					{
						if(peekb(0xba00,i) != '\r')
						{
							if(peekb(0xba00,i) == '')
							{
								break;
							}
							else
							{
								if(((x + initial_info.winleft) < (initial_info.winright)) &
									((y + initial_info.wintop) < (initial_info.winbottom + 1)))
								{
									if(peekb(0xba00,i) == '\n')
									{
										x = 3;
										y++;
									}
									else
									{
										gotoxy(x,y);
										putch(peekb(0xba00,i));
										x++;
									}
								}
								else
								{
									if((x + initial_info.winleft) > (initial_info.winright - 1))
									{
										i--;
										x = 3;
										y++;
									}
									else
									{
										if((y + initial_info.wintop) > (initial_info.winbottom))
										{
											eof = 0;
											break;
										}
									}
								}
							}
						}
					}
					else
					{
						if(peekb(0xba00,i) != '\r')
						{
							if(peekb(0xba00,i) == '')
							{
								break;
							}
							if(((x + initial_info.winleft) < (initial_info.winright)) &
								((y + initial_info.wintop) < (initial_info.winbottom + 1)))
							{
								if(peekb(0xba00,i) == '\n')
								{
									x = 3;
									y++;
								}
								else
								{
									gotoxy(x,y);
									putch(peekb(0xba00,i));
									x++;
								}
							}
							else
							{
								if((x + initial_info.winleft) > (initial_info.winright - 1))
								{
									if(peekb(0xba00,i) == '\n')
									{
										x = 3;
										y++;
									}
								}
								else
								{
									if((y + initial_info.wintop) > (initial_info.winbottom))
									{
										eof = 0;
										break;
									}
								}
							}
						}
					}
				}
				page = 0;
			}
			else
			{
				if(wrap == 0)
				{
					block--;
				}
				for(i = block - 1;i > -1;i--)
				{
					if(peekb(0xba00,i) == 0x09)
					{
						pokeb(0xba00,i,0x20);
					}
					if(wrap == 1)
					{
						if(peekb(0xba00,i) != '\r')
						{
							if(((x - initial_info.winleft) > 1) &
								((y - initial_info.wintop) > 0))
							{
								if(peekb(0xba00,i) == '\n')
								{
									x = initial_info.winright - 2;
									y--;
								}
								else
								{
									x--;
								}
							}
							else
							{
								if((x - initial_info.winleft) < 2)
								{
									x = initial_info.winright - 2;
									y--;
									i++;
								}
								else
								{
									if((y - initial_info.wintop) < 1)
									{
										break;
									}
								}
							}
						}
					}
					else
					{
						if(peekb(0xba00,i) != 'r')
						{
							if(((x - initial_info.winleft) > 1) &
								((y - initial_info.wintop) > 0))
							{
								if(peekb(0xba00,i) == '\n')
								{
									y--;
									x = initial_info.winright - 2;
								}
								else
								{
									x--;
								}
							}
							else
							{
								if((peekb(0xba00,i) == '\n') & ((x - initial_info.winleft) < 2))
								{
									y--;
									x = initial_info.winright - 2;
								}
								else
								{
									if((y - initial_info.wintop) < 1)
									{
										break;
									}
								}
							}
						}
					}
				}
				block = 2000;
				start_byte = start_byte + i + 1;
				page = 1;
				if(wrap == 0)
				{
					set = 1;
				}
				else
				{
					set = 0;
				}
				x = 3;
				y = 2;
			}
		}
		else
		{
			if(wrap < 2)
			{
				switch(bioskey(0))
				{
					case PGDN : page = 1;
										x = 3;
										y = 2;
										if(eof == 0)
										{
											start_byte = start_byte + i;

										}
										eof = 0;
										block = 2000;
										set = 0;
										break;
					case PGUP : if(start_byte < 2000L)
											{
												if(start_byte == 0L)
												{
													block = 2000;
													page = 1;
													x = 3;
													y = 2;
												}
												else
												{
													block = start_byte;
													page = 2;
													x = initial_info.winright - 2;
													y = initial_info.winbottom - 1;
												}
												start_byte = 0L;
											}
											else
											{
												start_byte = start_byte - 2000L;
												block = 2000;
												page = 2;
												x = initial_info.winright - 2;
												y = initial_info.winbottom - 1;
											}
											break;
					case ESC : done = 1; break;
					default : page = 0; break;
				}
			}
			else
			{
				if(wrap == 2)
				{
					bioskey(0);
					done = 1;
				}
				else
				{
					done = 1;
				}
			}
		}
	}
	return(0);
}



int read_file(void far *buff,char *file_name,unsigned int length,unsigned long int byte_start)
{
	FILE r_fp;
	char *file_buff;
	unsigned int seg;
	unsigned int off;

	if((file_buff = (char*)malloc(length)) == NULL)
	{
		return(1);
	}
	#ifdef __LARGE__
		seg = FP_SEG(file_buff);
		off = FP_OFF(file_buff);
	#else
		seg = _DS;
		asm mov cx,file_buff;
		off = _CX;
	#endif
	dev_error = 0;
	t_fp = &r_fp;
	if((t_fp = fopen(file_name,"r+b")) == NULL)
	{
		error_write(t_fp);
		free(file_buff);
		return(dev_error);
	}
	if(fseek(t_fp,byte_start,0) != 0)
	{
		error_write(t_fp);
		fclose(t_fp);
		free(file_buff);
		return(dev_error);
	}
	if(fread(file_buff,length,1,t_fp) != 1)
	{
		error_write(t_fp);
		fclose(t_fp);
		movedata(seg,off,FP_SEG(buff),FP_OFF(buff),length);
		free(file_buff);
		return(dev_error);
	}
	fclose(t_fp);
	movedata(seg,off,FP_SEG(buff),FP_OFF(buff),length);
	free(file_buff);
	return(0);
}

#pragma warn -par

int handler(int errval,int ax,int bp,int si)
{
	if(ax < 0)
	{
		dev_error = _DI & 0x00ff;
		bdosptr(0x09,"$",0);
		hardretn(2);
	}
	dev_error = errval;
	bdosptr(0x09,"$",0);
	hardretn(2);
	return(0);
}

int write_file(void far *buff,char *file_name,unsigned int length,unsigned long int byte_start)
{
	FILE w_fp;
	char *file_buff;
	unsigned int seg;
	unsigned int off;

	if((file_buff = (char*)malloc(length)) == NULL)
	{
		return(1);
	}
	#ifdef __LARGE__
		seg = FP_SEG(file_buff);
		off = FP_OFF(file_buff);
	#else
		seg = _DS;
		asm mov cx,file_buff;
		off = _CX;
	#endif;
	movedata(FP_SEG(buff),FP_OFF(buff),seg,off,length);
	dev_error = 0;
	t_fp = &w_fp;
	if((t_fp = fopen(file_name,"r+b")) == NULL)
	{
		error_write(t_fp);
		free(file_buff);
		return(dev_error);
	}
	if(fseek(t_fp,byte_start,0) != 0)
	{
		error_write(t_fp);
		fclose(t_fp);
		free(file_buff);
		return(dev_error);
	}
	if(fwrite(file_buff,length,1,t_fp) != 1)
	{
		error_write(t_fp);
		fclose(t_fp);
		free(file_buff);
		return(dev_error);
	}
	fclose(t_fp);
	free(file_buff);
	return(0);
}

int error_write(FILE *err_pt)
{
	if(dev_error == 0)
	{
		dev_error = _doserrno;
	}
	if(feof(err_pt) != 0)
	{
		dev_error = -1;
		return(1);
	}
	return(0);
}




