#include <tiff.h>

extern LONG bigRead();
extern LONG get_1st_ifd();
extern SHORT type_length();
extern BOOL access_ifd();
extern BOOL read_dir();
extern LONG lseek();

SHORT
read_tag(fhandle, fdtype, tagnum, buffer, max_length)
SHORT fhandle;
SHORT fdtype;
SHORT tagnum;
LONGPTR buffer;
SHORT max_length;
{
	LONG ifd_offset = get_1st_ifd(fhandle);
	LONG new_offset;
	TIFF_DIR_ENTRY dirent;
	SHORT entry_count;
	SHORT subfile_type;

	/* go through IFD's ... stop at null IFD offset */
	while(ifd_offset)
	{
		/* get pertinent IFD data */
		if(access_ifd(fhandle, ifd_offset,
		  (TIFF_DIR_ENTRY far *)&dirent, &entry_count, &subfile_type,
		  &new_offset))
		{
			return(0);
		}

		/* match on subfile type? */
		if(fdtype == subfile_type)
		{
			SHORT n = entry_count - 1;

			/* go through each entry */
			while(n-- > 0 && !read_dir(fhandle,
			  (TIFF_DIR_ENTRY far *)&dirent))
			{
				SHORT len;

				/* only do it for the supplied tag number */
				if(dirent.tag != tagnum)
				{
					continue;
				}

				/* get length of data to be copied */
				len = type_length(dirent.type);
				len *= (SHORT)dirent.length;

				/* length overflow? */
				if(len > max_length)
				{
					return(0);
				}
				if(len > LONG_SIZE)
				{
					/* read data into user's buffer */
					if(lseek(fhandle, dirent.value_offset,
					  0) == (LONG)(-1))
					{
						return(0);
					}
					if(bigRead(fhandle, buffer,
					  (LONG)len) != (LONG)len)
					{
						return(0);
					}
				}
				else
				{
					LONGPTR dp;
					dp = (LONGPTR)&dirent.value_offset;
					while(len-- > 0)
					{
						*buffer++ = *dp++;
					}
				}

				/* we're done after reading one tag's worth */
				return(1);
			}

			/* matched subfile & unmatched tag => error */
			return(0);
		}
		ifd_offset = new_offset;
	}
	return(0);
}

SHORT
read_dirent(fhandle, fdtype, tagnum, dirent)
SHORT fhandle;
SHORT fdtype;
SHORT tagnum;
TIFF_DIR_ENTRY far *dirent;
{
	LONG ifd_offset = get_1st_ifd(fhandle);
	LONG new_offset;
	SHORT entry_count;
	SHORT subfile_type;

	/* go through IFD's ... stop at null IFD offset */
	while(ifd_offset)
	{
		/* get pertinent IFD data */
		if(access_ifd(fhandle, ifd_offset, dirent, &entry_count,
		  &subfile_type, &new_offset))
		{
			return(0);
		}

		/* match on subfile type? */
		if(fdtype == subfile_type)
		{
			SHORT n = entry_count - 1;

			/* go through each entry */
			while(n-- > 0 && !read_dir(fhandle, dirent))
			{
				/* only do it for the supplied tag number */
				if(dirent->tag == tagnum)
				{
					return(1);
				}
			}

			/* matched subfile & unmatched tag => error */
			return(0);
		}
		ifd_offset = new_offset;
	}
	return(0);
}
