{$A-,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V-}
{Compile with Turbo-Pascal 5.0}
Program Fontable(Input,Output);
{
  This program generates Japanese font tables

  Author: Francois Jalbert
              '
  Date: November 1990

  Version: 1.0

  Date: April 1991

  Version: 2.0

  Modifications: - Added four kanjis.
                 - Run-time parameters now supplied.
                 - Extension is .JEM now.
                 - Page format changed slightly.
                 - Symbols now centered within tables.
                 - Switched to \clearpage since better for tables.
}
Const
  {Highest Bitmap number in JIS24}
  BitmapMax=7806;
  {Highest font number}
  FontMax=60;
  {Number of symbols in a font}
  SymbolMax=128;
  SymbolMax1=127;

Type
  Bitmap0Range=0..BitmapMax;
  Font0Range=0..FontMax;
  Symbol0Range=0..SymbolMax1;

Var OutFile:Text;

Procedure FontTable(Var OutFile:Text);
Var 
  Bitmap:Bitmap0Range;
  Font:Font0Range;
  Symbol:Symbol0Range;
  EUC1,EUC2:Integer;
Begin
Writeln(OutFile,'%JEM2TEX /NoSpace /NoPercent /LaTeX /EUC /Extended /3.0');
Writeln(OutFile,'%');
Writeln(OutFile,'\documentstyle[12pt]{article}');
Writeln(OutFile,'\pagestyle{plain}');
Writeln(OutFile,'\setlength{\oddsidemargin}{-0.5in} %0.5in margin left-right');
Writeln(OutFile,'\setlength{\textwidth}{7.5in} %8.5in-2*0.5in');
Writeln(OutFile,'\setlength{\topmargin}{-0.25in} %0.75in margin top-bottom');
Writeln(OutFile,'\setlength{\textheight}{9.4in} %11.0in-2*0.75in');
Writeln(OutFile,'\setlength{\footskip}{0.1in}');
Writeln(OutFile,'\setlength{\footheight}{0.1in}');
Writeln(OutFile,'\setlength{\headheight}{0pt}');
Writeln(OutFile,'\setlength{\headsep}{0pt}');
Writeln(OutFile,'\setlength{\topskip}{0pt}');
Writeln(OutFile,'\setlength{\parindent}{0pt}');
Writeln(OutFile,'\setlength{\tabcolsep}{4pt}');
Writeln(OutFile,'\renewcommand{\baselinestretch}{0.85}');
Writeln(OutFile,'\begin{document}');
Writeln(OutFile,'\begin{Large}');
Writeln(OutFile);
Writeln(OutFile,'\vspace*{\fill}');
Writeln(OutFile);
For Bitmap:=0 To BitmapMax Do
  Begin
  Symbol:=Bitmap Mod SymbolMax;
  Font:=Bitmap Div SymbolMax;
  EUC1:=Trunc( (Bitmap-1) Div 94 );
  EUC2:=(Bitmap-1)-94*EUC1;
  EUC1:=EUC1+161;
  EUC2:=EUC2+161;
  If Symbol=0 Then
    Begin
    Writeln(OutFile,'\begin{table}[h]');
    Writeln(OutFile,' \centering');
    Writeln(OutFile,' \begin{tabular}{r|cccccccccccccccc|l}');
    Writeln(OutFile,'  Code & \multicolumn{16}{c|}{Characters} & EUC \\ \hline')
    End;
  If (Symbol Mod 16)=0 Then Write(OutFile,Symbol:6,' ')
  Else
    If (Symbol Mod 16) in [5,10,15] Then Write(OutFile,'       ');
  If Bitmap=0 Then Write(OutFile,'&  ')
  Else
    Begin
    Write(OutFile,'&'+Chr(EUC1)+Chr(EUC2));
    If (Symbol Mod 16) in [4,9,14] Then Writeln(OutFile)
    Else
      If (Symbol Mod 16)=15 Then
        Begin
        Write(OutFile,'& ',EUC1,',',EUC2);
        If (Symbol<>SymbolMax1) And (Bitmap<>BitmapMax) Then 
          Write(OutFile,' \\');
        Writeln(OutFile)
        End
      Else
        If Bitmap=BitmapMax Then Writeln(OutFile)
    End;
  If (Symbol=SymbolMax1) Or (Bitmap=BitmapMax) Then
    Begin
    Writeln(OutFile,' \end{tabular}');
    Writeln(OutFile,'\caption{Font {\tt kanji'+Chr(Ord('a')+(Font Div 8))+
            Chr(Ord('a')+(Font Mod 8))+'} (',(Bitmap-Symbol),'--',Bitmap,').}');
    Writeln(OutFile,'\end{table}');
    Writeln(OutFile);
    If Bitmap=BitmapMax Then
      Begin
      Writeln(OutFile,'\vspace*{\fill}');
      Writeln(OutFile)
      End
    Else
      If (Font Mod 3)=2 Then 
        Begin 
        Writeln(OutFile,'\vspace*{\fill}');
        Writeln(OutFile);
        Writeln(OutFile,'\clearpage');
        Writeln(OutFile);
        Writeln(OutFile,'\vspace*{\fill}');
        Writeln(OutFile)
        End
    End
  End;
Writeln(OutFile,'\end{Large}');
Writeln(OutFile,'\end{document}')
End;

Begin
Writeln;
Writeln('Japanese Font Tables Generation Program.');   {To make Borland happy}
Writeln('Version 2.0 Copyright F. Jalbert 1991.');
Writeln;

Write('Creating Japanese file fontable.jem');
Assign(OutFile,'fontable.jem');
Rewrite(OutFile);
Writeln('.');

Write('Generating font tables');
FontTable(OutFile);
Writeln('.');

Write('Closing Japanese file fontable.jem');
Close(OutFile);
Writeln('.');
Writeln;

Writeln('Japanese font tables generation completed.');
Writeln
End.
