/*
 * protogen.c
 *
 * grab function prototypes into a destination file
 *
 */
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <malloc.h>
#include <time.h>
#include "common.h"

#define VERSION 100
#define LINELEN 128

char *usage_text = "[-aq] -fdest ...";

static char FileMode[] = { "w" };
static char *FileName = 0;

static BOOL quiet = FALSE;
static FILE *dest;

void boolargs(char select);
void getfilename (char select, char *string);
ARGLIST ArgList[] = {
  { 'a', ARG_SWITCH, boolargs },
  { 'q', ARG_SWITCH, boolargs },
  { 'f', ARG_CONCATSTRING, getfilename },
  { 0, 0, 0 }
};

static void boolargs( char select)
{
  switch (select) {
    case 'a' :
        FileMode[0] = 'a';
        break;
		case 'q' :
				quiet = TRUE;
				break;
  }
}
static void getfilename( char select, char *string)
{
  FileName = string;
}
// Routine looks for prototype possibilities
void readText( FILE* inF, FILE *outF, char *name)
{
  int i;
  char *temp = name;

  if (FileName && !quiet) {
    // New file, stick out the name
    fputc('\n', dest);
    // Center it
    for (i=0; i< 40 - strlen(name)/2 - 6; i++)
      fputc(' ', dest);
    // Make it a standard C comment
    fputs("/* ",dest);

    // First char uppercase, better not get here without a valid file!
    fputc(toupper(*temp), dest);
    // Others lower
    while (*++temp)
      fputc(tolower(*temp), dest);
    fputs(" */\n\n",dest);
  }

  while (!feof(inF)) {
    char theline[LINELEN];
    char *line = theline;

    // Get the line
    line[0] = '\0';
    fgets(line,LINELEN,inF);
		if ((line[0] == ';') && (line[1] == '*')) {
			line[0] = ' ';
			line[1] = ' ';
			fputs(line,dest);
		}

  }
}
// Main routine
int main(int argc, char *argv[])
{
  banner(VMSG("MkLibHead"));

  if (!parse_args(&argc, argv, FALSE) || (argc < 2))
    usage(argv[0]);

  // No file? put it on CRT
  if (!FileName )
    dest = stdout;
  else
    // open it or error if not
    if (!(dest = fopen(FileName, FileMode)))
      fatal("Can't open destination %s.\n", FileName);

  // Stick out a header
  if (FileName && !quiet) {
    char s[128];
    time_t ttime;
    struct tm *ltime;
    fputs("\n/* ", dest);
    fprintf(dest,"MKLibHead %d.%02d ", VERSION/100, VERSION %100);
    time(&ttime);
    ltime = localtime(&ttime);
    strftime(s,80,"%A %B %d, %Y  %H:%M:%S", ltime);
    fputs(s, dest);
    fputs(" */\n", dest);
  }

	if (FileName) {
		fprintf(dest,"\n#ifndef __OSLIBPROT__\n");
		fprintf(dest,"#define __OSLIBPROT__\n");
		fprintf(dest,"\n#ifdef __cplusplus\n");
		fprintf(dest,"extern \"C\" {\n");
		fprintf(dest,"#endif // __cplusplus\n");
	}
  // Run through all files making the changes
  FileRecurse(argc-1, argv+1, "Grabbing Prototypes from", readText, FALSE);
	if (FileName) {
		fprintf(dest,"\n#ifdef __cplusplus\n");
		fprintf(dest,"}\n");
		fprintf(dest,"#endif // __cplusplus\n");
		fprintf(dest,"#endif // __OSLIBPROT__\n");
		fclose(dest);
	}
  return(0);
}